/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.spi;

import java.io.File;
import java.io.FileFilter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.versioning.Accessor;
import org.netbeans.modules.versioning.FlatFolder;
import org.netbeans.modules.versioning.Utils;
import org.netbeans.modules.versioning.VersioningManager;
import org.netbeans.modules.versioning.spi.AccessorImpl;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VCSContext {
    public static final VCSContext EMPTY = new VCSContext(null, VCSContext.emptySet(), VCSContext.emptySet());
    private static Reference<VCSContext> contextCached = new WeakReference<Object>(null);
    private static Reference<Node[]> contextNodesCached = new WeakReference<Object>(null);
    private final Lookup elements;
    private final Set<File> unfilteredRootFiles;
    private final Set<File> rootFiles;
    private final Set<File> exclusions;
    private Set<File> computedFilesCached;
    private FileFilter fileFilterCached;

    static VCSContext forFiles(Set<File> set) {
        return new VCSContext(null, set, VCSContext.emptySet());
    }

    public static synchronized VCSContext forNodes(Node[] nodeArray) {
        Object object;
        if (Arrays.equals(contextNodesCached.get(), nodeArray) && (object = contextCached.get()) != null) {
            return object;
        }
        object = new HashSet(nodeArray.length);
        HashSet<File> hashSet = new HashSet<File>(nodeArray.length);
        HashSet<File> hashSet2 = new HashSet<File>(5);
        for (int i = 0; i < nodeArray.length; ++i) {
            Node node = nodeArray[i];
            File file = (File)node.getLookup().lookup(File.class);
            if (file != null) {
                object.add(file);
                hashSet.add(file);
                continue;
            }
            Project project = (Project)node.getLookup().lookup(Project.class);
            if (project != null) {
                VCSContext.addProjectFiles(hashSet, hashSet2, project);
                continue;
            }
            VCSContext.addFileObjects(node, (Set<File>)object, hashSet);
        }
        VCSContext vCSContext = new VCSContext(nodeArray, hashSet, hashSet2);
        contextCached = new WeakReference<VCSContext>(vCSContext);
        contextNodesCached = new WeakReference<Node[]>(nodeArray);
        return vCSContext;
    }

    public synchronized Set<File> computeFiles(FileFilter fileFilter) {
        if (this.computedFilesCached == null || fileFilter != this.fileFilterCached) {
            this.computedFilesCached = VCSContext.substract(this.rootFiles, this.exclusions, fileFilter);
            this.fileFilterCached = fileFilter;
        }
        return this.computedFilesCached;
    }

    public Lookup getElements() {
        return this.elements;
    }

    public Set<File> getFiles() {
        return this.unfilteredRootFiles;
    }

    public Set<File> getRootFiles() {
        return this.rootFiles;
    }

    public Set<File> getExclusions() {
        return this.exclusions;
    }

    public boolean contains(File file) {
        block0: for (File file2 : this.rootFiles) {
            if (!Utils.isAncestorOrEqual(file2, file)) continue;
            for (File file3 : this.exclusions) {
                if (!Utils.isAncestorOrEqual(file3, file)) continue;
                continue block0;
            }
            return true;
        }
        return false;
    }

    private static void addProjectFiles(Collection<File> collection, Collection<File> collection2, Project project) {
        Object object;
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("generic");
        ArrayList<File> arrayList = new ArrayList<File>(sourceGroupArray.length);
        HashSet<VersioningSystem> hashSet = new HashSet<VersioningSystem>(2);
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            object = sourceGroupArray[i];
            FileObject fileObject = object.getRootFolder();
            File file = FileUtil.toFile((FileObject)fileObject);
            if (file == null) continue;
            VersioningSystem versioningSystem = VersioningManager.getInstance().getOwner(file);
            if (versioningSystem == null) {
                arrayList.add(file);
            } else {
                hashSet.add(versioningSystem);
            }
            collection.add(file);
            FileObject[] fileObjectArray = fileObject.getChildren();
            for (int j = 0; j < fileObjectArray.length; ++j) {
                FileObject fileObject2 = fileObjectArray[j];
                File file2 = FileUtil.toFile((FileObject)fileObject2);
                if (file2 == null || object.contains(fileObject2) || SharabilityQuery.getSharability((File)file2) == 2) continue;
                collection2.add(file2);
            }
        }
        if (hashSet.size() == 1 && hashSet.iterator().next() != null) {
            collection.removeAll(arrayList);
            Iterator<File> iterator = collection2.iterator();
            block2: while (iterator.hasNext()) {
                object = iterator.next();
                for (File file : collection) {
                    if (!Utils.isAncestorOrEqual(file, (File)object)) continue;
                    continue block2;
                }
                iterator.remove();
            }
        }
    }

    private static void addFileObjects(Node node, Set<File> set, Set<File> set2) {
        Collection collection = node.getLookup().lookup(new Lookup.Template(NonRecursiveFolder.class)).allInstances();
        ArrayList<File> arrayList = new ArrayList<File>();
        if (collection.size() > 0) {
            for (NonRecursiveFolder nonRecursiveFolder : collection) {
                File file = FileUtil.toFile((FileObject)nonRecursiveFolder.getFolder());
                if (file == null) continue;
                arrayList.add(new FlatFolder(file.getAbsolutePath()));
            }
        } else {
            Collection collection2 = node.getLookup().lookup(new Lookup.Template(FileObject.class)).allInstances();
            if (collection2.size() > 0) {
                arrayList.addAll(VCSContext.toFileCollection(collection2));
            } else {
                DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
                if (dataObject instanceof DataShadow) {
                    dataObject = ((DataShadow)dataObject).getOriginal();
                }
                if (dataObject != null) {
                    Collection<File> collection3 = VCSContext.toFileCollection(dataObject.files());
                    arrayList.addAll(collection3);
                }
            }
        }
        set.addAll(arrayList);
        set2.addAll(arrayList);
    }

    private static Collection<File> toFileCollection(Collection<? extends FileObject> collection) {
        HashSet<File> hashSet = new HashSet<File>(collection.size() * 4 / 3 + 1);
        for (FileObject fileObject : collection) {
            hashSet.add(FileUtil.toFile((FileObject)fileObject));
        }
        hashSet.remove(null);
        return hashSet;
    }

    private VCSContext(Node[] nodeArray, Set<File> set, Set<File> set2) {
        this.elements = nodeArray != null ? Lookups.fixed((Object[])nodeArray) : Lookups.fixed((Object[])new Node[0]);
        HashSet<File> hashSet = new HashSet<File>(set);
        HashSet<File> hashSet2 = new HashSet<File>(set2);
        this.unfilteredRootFiles = Collections.unmodifiableSet(new HashSet<File>(hashSet));
        while (this.normalize(hashSet, hashSet2)) {
        }
        this.rootFiles = Collections.unmodifiableSet(hashSet);
        this.exclusions = Collections.unmodifiableSet(hashSet2);
    }

    private boolean normalize(Set<File> set, Set<File> set2) {
        for (File file : set) {
            Iterator<File> iterator = set2.iterator();
            while (iterator.hasNext()) {
                File file2 = iterator.next();
                if (!Utils.isAncestorOrEqual(file2, file)) continue;
                iterator.remove();
                this.exclusionRemoved(set2, file2, file);
                return true;
            }
        }
        this.removeDuplicates(set);
        this.removeDuplicates(set2);
        return false;
    }

    private void exclusionRemoved(Set<File> set, File file, File file2) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            File file3 = fileArray[i];
            if (Utils.isAncestorOrEqual(file2, file3)) continue;
            set.add(file3);
        }
    }

    private static Set<File> substract(Set<File> set, Set<File> set2, FileFilter fileFilter) {
        HashSet<File> hashSet = new HashSet<File>(set);
        for (File file : set2) {
            assert (file != null);
            do {
                VCSContext.addSiblings(hashSet, file, fileFilter);
                file = file.getParentFile();
                hashSet.remove(file);
            } while (!set.contains(file));
        }
        hashSet.removeAll(set2);
        return hashSet;
    }

    private static void addSiblings(Set<File> set, File file, FileFilter fileFilter) {
        File[] fileArray;
        if (file.getParentFile() == null) {
            return;
        }
        for (File file2 : fileArray = file.getParentFile().listFiles()) {
            if (!fileFilter.accept(file2)) continue;
            set.add(file2);
        }
        set.remove(file);
    }

    private static final Set<File> emptySet() {
        return Collections.emptySet();
    }

    private void removeDuplicates(Set<File> set) {
        ArrayList<File> arrayList = new ArrayList<File>();
        block0: for (File file : set) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                File file2 = (File)iterator.next();
                if (Utils.isAncestorOrEqual(file2, file) && (file.isFile() || !VersioningSupport.isFlat(file2))) continue block0;
                if (!Utils.isAncestorOrEqual(file, file2) || !file2.isFile() && VersioningSupport.isFlat(file)) continue;
                iterator.remove();
            }
            arrayList.add(file);
        }
        set.clear();
        set.addAll(arrayList);
    }

    static {
        Accessor.VCSContextAccessor = new AccessorImpl();
    }
}

