/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.RubyModule;
import org.jruby.internal.runtime.JumpTarget;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.MethodFactory;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class CompiledMethod
extends JavaMethod
implements JumpTarget,
Cloneable {
    protected Object $scriptObject;

    public CompiledMethod(RubyModule implementationClass, Arity arity, Visibility visibility, StaticScope staticScope, Object scriptObject, CallConfiguration callConfig) {
        super(implementationClass, visibility, callConfig, staticScope, arity);
        this.$scriptObject = scriptObject;
    }

    protected CompiledMethod() {
    }

    protected void init(RubyModule implementationClass, Arity arity, Visibility visibility, StaticScope staticScope, Object scriptObject, CallConfiguration callConfig) {
        this.$scriptObject = scriptObject;
        super.init(implementationClass, arity, visibility, staticScope, callConfig);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name) {
        return this.call(context, self, clazz, name, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg) {
        return this.call(context, self, clazz, name, arg, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg1, IRubyObject arg2) {
        return this.call(context, self, clazz, name, arg1, arg2, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        return this.call(context, self, clazz, name, arg1, arg2, arg3, Block.NULL_BLOCK);
    }

    public DynamicMethod dup() {
        try {
            CompiledMethod msm = (CompiledMethod)this.clone();
            return msm;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public boolean isNative() {
        return false;
    }

    public static class LazyCompiledMethod
    extends DynamicMethod
    implements JumpTarget,
    Cloneable {
        private final String method;
        private final Arity arity;
        private final StaticScope scope;
        private final Object scriptObject;
        private MethodFactory factory;
        private DynamicMethod compiledMethod;

        public LazyCompiledMethod(RubyModule implementationClass, String method, Arity arity, Visibility visibility, StaticScope scope, Object scriptObject, CallConfiguration callConfig, MethodFactory factory) {
            super(implementationClass, visibility, callConfig);
            this.method = method;
            this.arity = arity;
            this.scope = scope;
            this.scriptObject = scriptObject;
            this.factory = factory;
        }

        private synchronized void initializeMethod() {
            if (this.compiledMethod != null) {
                return;
            }
            this.compiledMethod = this.factory.getCompiledMethod(this.implementationClass, this.method, this.arity, this.visibility, this.scope, this.scriptObject, this.callConfig);
            this.factory = null;
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.call(context, self, clazz, name);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.call(context, self, clazz, name, arg0);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.call(context, self, clazz, name, arg0, arg1);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.call(context, self, clazz, name, arg0, arg1, arg2);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.call(context, self, clazz, name, args);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, Block block) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.call(context, self, clazz, name, block);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, Block block) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.call(context, self, clazz, name, arg0, block);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1, Block block) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.call(context, self, clazz, name, arg0, arg1, block);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.call(context, self, clazz, name, arg0, arg1, arg2, block);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.call(context, self, clazz, name, args, block);
        }

        public Arity getArity() {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.getArity();
        }

        public CallConfiguration getCallConfig() {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.getCallConfig();
        }

        public RubyModule getImplementationClass() {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.getImplementationClass();
        }

        protected RubyModule getProtectedClass() {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.getProtectedClass();
        }

        public DynamicMethod getRealMethod() {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.getRealMethod();
        }

        public Visibility getVisibility() {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.getVisibility();
        }

        public boolean isCallableFrom(IRubyObject caller, CallType callType) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.isCallableFrom(caller, callType);
        }

        public boolean isNative() {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.isNative();
        }

        public void setCallConfig(CallConfiguration callConfig) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            this.compiledMethod.setCallConfig(callConfig);
        }

        public void setImplementationClass(RubyModule implClass) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            this.compiledMethod.setImplementationClass(implClass);
        }

        public void setVisibility(Visibility visibility) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            this.compiledMethod.setVisibility(visibility);
        }

        public DynamicMethod dup() {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.dup();
        }
    }
}

