/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.PrintStream;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaObject;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"NativeException"}, parent="RuntimeError")
public class NativeException
extends RubyException {
    private final Throwable cause;
    public static final String CLASS_NAME = "NativeException";
    private final Ruby runtime;

    public NativeException(Ruby runtime, RubyClass rubyClass, Throwable cause) {
        super(runtime, rubyClass, cause.getClass().getName() + ": " + cause.getMessage());
        this.runtime = runtime;
        this.cause = cause;
    }

    public static RubyClass createClass(Ruby runtime, RubyClass baseClass) {
        RubyClass exceptionClass = runtime.defineClass(CLASS_NAME, baseClass, ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        exceptionClass.defineAnnotatedMethods(NativeException.class);
        return exceptionClass;
    }

    @JRubyMethod(frame=true)
    public IRubyObject cause(Block unusedBlock) {
        return Java.wrap(this.getRuntime(), (IRubyObject)JavaObject.wrap(this.getRuntime(), this.cause));
    }

    public IRubyObject backtrace() {
        IRubyObject rubyTrace = super.backtrace();
        if (rubyTrace.isNil()) {
            return rubyTrace;
        }
        RubyArray array = (RubyArray)rubyTrace.dup();
        StackTraceElement[] stackTrace = this.cause.getStackTrace();
        for (int i = stackTrace.length - 1; i >= 0; --i) {
            StackTraceElement element = stackTrace[i];
            String className = element.getClassName();
            String line = null;
            if (element.getFileName() == null) {
                line = className + ":" + element.getLineNumber() + ":in `" + element.getMethodName() + "'";
            } else {
                int index = className.lastIndexOf(".");
                String packageName = null;
                packageName = index == -1 ? "" : className.substring(0, index) + "/";
                line = packageName.replace(".", "/") + element.getFileName() + ":" + element.getLineNumber() + ":in `" + element.getMethodName() + "'";
            }
            RubyString string = this.runtime.newString(line);
            array.unshift(string);
        }
        return array;
    }

    public void printBacktrace(PrintStream errorStream) {
        super.printBacktrace(errorStream);
        errorStream.println("Complete Java stackTrace");
        this.cause.printStackTrace(errorStream);
    }

    public Throwable getCause() {
        return this.cause;
    }
}

