/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer.html;

import org.w3c.dom.Element;

public final class HtmlAttribute {
    public static final String FOR = "for";
    public static final String FRAME = "frame";
    public static final String RULES = "rules";
    public static final String SIZE = "size";
    public static final String COLOR = "color";
    public static final String CLEAR = "clear";
    public static final String BACKGROUND = "background";
    public static final String BGCOLOR = "bgcolor";
    public static final String TEXT = "text";
    public static final String LINK = "link";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String ALIGN = "align";
    public static final String NAME = "name";
    public static final String HREF = "href";
    public static final String REL = "rel";
    public static final String REV = "rev";
    public static final String TITLE = "title";
    public static final String TARGET = "target";
    public static final String SHAPE = "shape";
    public static final String COORDS = "coords";
    public static final String ISMAP = "ismap";
    public static final String NOHREF = "nohref";
    public static final String ALT = "alt";
    public static final String ID = "id";
    public static final String SRC = "src";
    public static final String HSPACE = "hspace";
    public static final String VSPACE = "vspace";
    public static final String USEMAP = "usemap";
    public static final String LOWSRC = "lowsrc";
    public static final String CODEBASE = "codebase";
    public static final String CODE = "code";
    public static final String ARCHIVE = "archive";
    public static final String VALUE = "value";
    public static final String VALUETYPE = "valuetype";
    public static final String TYPE = "type";
    public static final String CLASS = "class";
    public static final String STYLE = "style";
    public static final String LANG = "lang";
    public static final String FACE = "face";
    public static final String DIR = "dir";
    public static final String DECLARE = "declare";
    public static final String CLASSID = "classid";
    public static final String DATA = "data";
    public static final String CODETYPE = "codetype";
    public static final String ONLOAD = "onload";
    public static final String STANDBY = "standby";
    public static final String BORDER = "border";
    public static final String SHAPES = "shapes";
    public static final String NOSHADE = "noshade";
    public static final String COMPACT = "compact";
    public static final String START = "start";
    public static final String ACTION = "action";
    public static final String METHOD = "method";
    public static final String ENCTYPE = "enctype";
    public static final String CHECKED = "checked";
    public static final String MAXLENGTH = "maxlength";
    public static final String MULTIPLE = "multiple";
    public static final String SELECTED = "selected";
    public static final String ROWS = "rows";
    public static final String COLS = "cols";
    public static final String CELLSPACING = "cellspacing";
    public static final String CELLPADDING = "cellpadding";
    public static final String VALIGN = "valign";
    public static final String HALIGN = "halign";
    public static final String NOWRAP = "nowrap";
    public static final String ROWSPAN = "rowspan";
    public static final String COLSPAN = "colspan";
    public static final String SPAN = "span";
    public static final String PROMPT = "prompt";
    public static final String HTTPEQUIV = "http-equiv";
    public static final String CONTENT = "content";
    public static final String LANGUAGE = "language";
    public static final String VERSION = "version";
    public static final String FRAMEBORDER = "frameborder";
    public static final String MARGINWIDTH = "marginwidth";
    public static final String MARGINHEIGHT = "marginheight";
    public static final String SCROLLING = "scrolling";
    public static final String NORESIZE = "noresize";
    public static final String ENDTAG = "endtag";
    public static final String COMMENT = "comment";
    public static final String MEDIA = "media";
    public static final int ALIGN_ID = 0;
    public static final int VALIGN_ID = 1;
    public static final int BGCOLOR_ID = 2;
    public static final int BACKGROUND_ID = 3;
    public static final int TEXT_ID = 4;
    public static final int WIDTH_ID = 5;
    public static final int HEIGHT_ID = 6;
    public static final int NOWRAP_ID = 7;
    public static final int BORDER_ID = 8;
    public static final int COLOR_ID = 9;
    public static final int SIZE_ID = 10;
    public static final int FACE_ID = 11;
    public static final int TYPE_ID = 12;
    public static final int LINK_ID = 13;
    public static final int CLEAR_ID = 14;
    public static final byte VALUE_ABSOLUTE = 1;
    public static final byte VALUE_PERCENTAGE = 2;
    public static final byte VALUE_RELATIVE = 4;

    public static int getIntegerAttributeValue(Element el, String key, int def) {
        int value = def;
        String istr = el.getAttribute(key);
        if (istr != null && istr.length() > 0) {
            try {
                value = HtmlAttribute.parseInt(istr);
            }
            catch (NumberFormatException e) {
                value = def;
            }
        }
        return value;
    }

    public static byte getNumberType(String s) {
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            if (s.charAt(i) == '%') {
                return 2;
            }
            if (s.charAt(i) != '*') continue;
            return 4;
        }
        return 1;
    }

    public static int parseInt(String s) {
        int radix = 10;
        if (s == null) {
            return 0;
        }
        int result = 0;
        boolean negative = false;
        int i = 0;
        int max = s.length();
        if (max > 0) {
            int digit;
            int limit;
            while (Character.isWhitespace(s.charAt(i))) {
                ++i;
            }
            if (i == max) {
                return 0;
            }
            if (s.charAt(i) == '-') {
                negative = true;
                limit = Integer.MIN_VALUE;
                ++i;
            } else {
                limit = -2147483647;
            }
            int multmin = limit / radix;
            if (i < max) {
                if ((digit = Character.digit(s.charAt(i++), radix)) < 0) {
                    return negative ? result : -result;
                }
                result = -digit;
            }
            while (i < max) {
                if ((digit = Character.digit(s.charAt(i++), radix)) < 0) {
                    return negative ? result : -result;
                }
                if (result < multmin) {
                    return negative ? result : -result;
                }
                if ((result *= radix) < limit + digit) {
                    return negative ? result : -result;
                }
                result -= digit;
            }
        } else {
            return 0;
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            return 0;
        }
        return -result;
    }
}

