/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.io;

import java.io.PrintWriter;
import java.util.ArrayList;

public class XMLWriter {
    private PrintWriter m_out;
    private int m_bias = 0;
    private int m_tab;
    private ArrayList m_tagStack = new ArrayList();
    private static final char LOWER_RANGE = ' ';
    private static final char UPPER_RANGE = '\u007f';
    private static final char[] VALID_CHARS = new char[]{'\t', '\n', '\r'};
    private static final char[] INVALID = new char[]{'<', '>', '\"', '\'', '&'};
    private static final String[] VALID = new String[]{"&lt;", "&gt;", "&quot;", "&apos;", "&amp;"};

    public XMLWriter(PrintWriter out) {
        this(out, 2);
    }

    public XMLWriter(PrintWriter out, int tabLength) {
        this.m_out = out;
        this.m_tab = 2;
    }

    public void print(String s) {
        this.m_out.print(s);
    }

    public void println(String s) {
        this.m_out.print(s);
        this.m_out.print("\n");
    }

    public void println() {
        this.m_out.print("\n");
    }

    public void begin() {
        this.m_out.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.println();
    }

    public void begin(String header, int bias) {
        this.begin();
        this.m_out.print(header);
        this.m_bias = bias;
    }

    public void comment(String comment) {
        this.spacing();
        this.m_out.print("<!-- ");
        this.m_out.print(comment);
        this.m_out.print(" -->");
        this.println();
    }

    protected void tag(String tag, String[] names, String[] values, int nattr, boolean close) {
        this.spacing();
        this.m_out.print('<');
        this.m_out.print(tag);
        for (int i = 0; i < nattr; ++i) {
            this.m_out.print(' ');
            this.m_out.print(names[i]);
            this.m_out.print('=');
            this.m_out.print('\"');
            this.escapeString(values[i]);
            this.m_out.print('\"');
        }
        if (close) {
            this.m_out.print('/');
        }
        this.m_out.print('>');
        this.println();
        if (!close) {
            this.m_tagStack.add(tag);
        }
    }

    public void tag(String tag, String[] names, String[] values, int nattr) {
        this.tag(tag, names, values, nattr, true);
    }

    public void start(String tag, String[] names, String[] values, int nattr) {
        this.tag(tag, names, values, nattr, false);
    }

    protected void tag(String tag, String name, String value, boolean close) {
        this.spacing();
        this.m_out.print('<');
        this.m_out.print(tag);
        this.m_out.print(' ');
        this.m_out.print(name);
        this.m_out.print('=');
        this.m_out.print('\"');
        this.escapeString(value);
        this.m_out.print('\"');
        if (close) {
            this.m_out.print('/');
        }
        this.m_out.print('>');
        this.println();
        if (!close) {
            this.m_tagStack.add(tag);
        }
    }

    public void tag(String tag, String name, String value) {
        this.tag(tag, name, value, true);
    }

    public void start(String tag, String name, String value) {
        this.tag(tag, name, value, false);
    }

    protected void tag(String tag, ArrayList names, ArrayList values, int nattr, boolean close) {
        this.spacing();
        this.m_out.print('<');
        this.m_out.print(tag);
        for (int i = 0; i < nattr; ++i) {
            this.m_out.print(' ');
            this.m_out.print((String)names.get(i));
            this.m_out.print('=');
            this.m_out.print('\"');
            this.escapeString((String)values.get(i));
            this.m_out.print('\"');
        }
        if (close) {
            this.m_out.print('/');
        }
        this.m_out.print('>');
        this.println();
        if (!close) {
            this.m_tagStack.add(tag);
        }
    }

    public void tag(String tag, ArrayList names, ArrayList values, int nattr) {
        this.tag(tag, names, values, nattr, true);
    }

    public void start(String tag, ArrayList names, ArrayList values, int nattr) {
        this.tag(tag, names, values, nattr, false);
    }

    public void start(String tag) {
        this.tag(tag, (String[])null, null, 0, false);
    }

    public void end() {
        String tag = (String)this.m_tagStack.remove(this.m_tagStack.size() - 1);
        this.spacing();
        this.m_out.print('<');
        this.m_out.print('/');
        this.m_out.print(tag);
        this.m_out.print('>');
        this.println();
    }

    public void contentTag(String tag, String name, String value, String content) {
        this.spacing();
        this.m_out.print('<');
        this.m_out.print(tag);
        this.m_out.print(' ');
        this.m_out.print(name);
        this.m_out.print('=');
        this.m_out.print('\"');
        this.escapeString(value);
        this.m_out.print('\"');
        this.m_out.print('>');
        this.escapeString(content);
        this.m_out.print('<');
        this.m_out.print('/');
        this.m_out.print(tag);
        this.m_out.print('>');
        this.println();
    }

    public void contentTag(String tag, String content) {
        this.spacing();
        this.m_out.print('<');
        this.m_out.print(tag);
        this.m_out.print('>');
        this.escapeString(content);
        this.m_out.print('<');
        this.m_out.print('/');
        this.m_out.print(tag);
        this.m_out.print('>');
        this.println();
    }

    public void content(String content) {
        this.escapeString(content);
    }

    public void finish() {
        this.m_bias = 0;
        this.m_out.flush();
    }

    public void finish(String footer) {
        this.m_bias = 0;
        this.m_out.print(footer);
        this.m_out.flush();
    }

    public void spacing() {
        int len = this.m_bias + this.m_tagStack.size() * this.m_tab;
        for (int i = 0; i < len; ++i) {
            this.m_out.print(' ');
        }
    }

    protected void escapeString(String str) {
        if (str == null) {
            this.m_out.print("null");
            return;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c < ' ' && c != VALID_CHARS[0] && c != VALID_CHARS[1] && c != VALID_CHARS[2] || c > '\u007f') {
                this.m_out.print("&#");
                this.m_out.print(Integer.toString(c));
                this.m_out.print(';');
                continue;
            }
            boolean valid = true;
            for (int j = INVALID.length - 1; j >= 0; --j) {
                if (INVALID[j] != c) continue;
                valid = false;
                this.m_out.print(VALID[j]);
                break;
            }
            if (!valid) continue;
            this.m_out.print(c);
        }
    }
}

