/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxwsstack.glassfish;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.netbeans.modules.websvc.core.jaxwsstack.JaxWs;
import org.netbeans.modules.websvc.core.jaxwsstack.WSUriDescriptor;
import org.netbeans.modules.websvc.core.jaxwsstack.glassfish.GlassFishV2JaxWsTool;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.api.WSStackVersion;
import org.netbeans.modules.websvc.wsstack.api.WSTool;
import org.netbeans.modules.websvc.wsstack.spi.WSStackFactory;
import org.netbeans.modules.websvc.wsstack.spi.WSStackImplementation;
import org.netbeans.modules.websvc.wsstack.spi.WSToolImplementation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlassFishV2JaxWsStackImpl
implements WSStackImplementation<JaxWs> {
    private JaxWs jaxWs;
    private File root;
    private WSStackVersion version;

    public GlassFishV2JaxWsStackImpl(File file) {
        this.root = file;
        try {
            this.version = WSStackFactory.createWSStackVersion((String)this.resolveImplementationVersion());
            if (this.version == null) {
                this.version = WSStackVersion.valueOf((int)2, (int)1, (int)3, (int)0);
            }
        }
        catch (IOException iOException) {
            this.version = WSStackVersion.valueOf((int)2, (int)1, (int)3, (int)0);
        }
    }

    public void initJaxWsDescriptor() {
        this.jaxWs = new JaxWs();
        WSUriDescriptor wSUriDescriptor = new WSUriDescriptor(){

            public String getServiceUri(String string, String string2, String string3, boolean bl) {
                if (bl) {
                    return string2 + "/" + string3;
                }
                return string + "/" + string2;
            }

            public String getDescriptorUri(String string, String string2, String string3, boolean bl) {
                return this.getServiceUri(string, string2, string3, bl) + "?wsdl";
            }

            public String getTesterPageUri(String string, String string2, String string3, boolean bl) {
                return this.getServiceUri(string, string2, string3, bl) + "?Tester";
            }
        };
        this.jaxWs.setWSUriDescriptor(wSUriDescriptor);
    }

    public JaxWs get() {
        return this.jaxWs;
    }

    public WSStackVersion getVersion() {
        return this.version;
    }

    public WSTool getWSTool(WSStack.Tool tool) {
        return WSStackFactory.createWSTool((WSToolImplementation)new GlassFishV2JaxWsTool(this.root, tool));
    }

    public boolean isFeatureSupported(WSStack.Feature feature) {
        return feature == JaxWs.Feature.JSR_109 || feature == JaxWs.Feature.SERVICE_REF_INJECTION || feature == JaxWs.Feature.TESTER_PAGE || feature == JaxWs.Feature.WSIT;
    }

    private String resolveImplementationVersion() throws IOException {
        JarFile jarFile;
        JarEntry jarEntry;
        File file = new File(this.root, "lib/webservices-tools.jar");
        if (!file.exists()) {
            file = new File(this.root, "lib/appserv-ws.jar");
        }
        if (file.exists() && (jarEntry = (jarFile = new JarFile(file)).getJarEntry("com/sun/tools/ws/version.properties")) != null) {
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = null;
            String string2 = null;
            while ((string = bufferedReader.readLine()) != null) {
                String string3 = string.trim();
                if (!string3.startsWith("major-version=")) continue;
                string2 = string3.substring(14);
            }
            bufferedReader.close();
            return string2;
        }
        return null;
    }
}

