/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.nodes;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.Binding;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlChangeListener;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelListener;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModeler;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelerFactory;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlOperation;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlPort;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlService;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.core.jaxws.nodes.JaxWsClientChildren;
import org.netbeans.modules.websvc.core.jaxws.nodes.JaxWsNode;
import org.netbeans.modules.websvc.core.jaxws.nodes.OperationNode;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.jaxws.api.WsdlWrapperGenerator;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxWsChildren
extends Children.Keys<Object> {
    private Image cachedIcon;
    private static final String OPERATION_ICON = "org/netbeans/modules/websvc/core/webservices/ui/resources/wsoperation.png";
    private FileObject implClass;
    private Service service;
    private FileObject srcRoot;
    private WsdlModel wsdlModel;
    private WsdlModeler wsdlModeler;
    private boolean modelGenerationFinished;
    private WsdlChangeListener wsdlChangeListener;
    private FileChangeListener fcl;

    public JaxWsChildren(Service service, FileObject fileObject, FileObject fileObject2) {
        this.service = service;
        this.srcRoot = fileObject;
        this.implClass = fileObject2;
    }

    private List<ExecutableElement> getPublicMethods(CompilationController compilationController, TypeElement typeElement) throws IOException {
        List<? extends Element> list = typeElement.getEnclosedElements();
        List<ExecutableElement> list2 = ElementFilter.methodsIn(list);
        ArrayList<ExecutableElement> arrayList = new ArrayList<ExecutableElement>();
        for (ExecutableElement executableElement : list2) {
            Set<Modifier> set = executableElement.getModifiers();
            if (!set.contains((Object)Modifier.PUBLIC)) continue;
            arrayList.add(executableElement);
        }
        return arrayList;
    }

    protected void addNotify() {
        if (this.isFromWsdl()) {
            try {
                String string;
                FileObject fileObject = this.getJAXWSSupport().getLocalWsdlFolderForService(this.service.getName(), false);
                assert (fileObject != null) : "Cannot find folder for local wsdl file";
                FileObject fileObject2 = fileObject.getFileObject(this.service.getLocalWsdlFile());
                if (fileObject2 == null) {
                    return;
                }
                if (this.wsdlModeler == null) {
                    this.wsdlModeler = WsdlModelerFactory.getDefault().getWsdlModeler(fileObject2.getURL());
                }
                if (this.wsdlModeler != null) {
                    this.wsdlChangeListener = new WsdlChangeListener(){

                        public void wsdlModelChanged(WsdlModel wsdlModel, WsdlModel wsdlModel2) {
                            JaxWsChildren.this.wsdlModel = wsdlModel2;
                            JaxWsChildren.this.updateKeys();
                            ((JaxWsNode)JaxWsChildren.this.getNode()).changeIcon();
                        }
                    };
                    this.wsdlModeler.addWsdlChangeListener(this.wsdlChangeListener);
                }
                if ((string = this.service.getPackageName()) != null && this.service.isPackageNameForceReplace()) {
                    this.wsdlModeler.setPackageName(string);
                } else {
                    this.wsdlModeler.setPackageName(null);
                }
                JAXWSSupport jAXWSSupport = this.getJAXWSSupport();
                this.wsdlModeler.setCatalog(jAXWSSupport.getCatalog());
                this.setBindings(jAXWSSupport, this.wsdlModeler, this.service);
                this.modelGenerationFinished = false;
                ((JaxWsNode)this.getNode()).changeIcon();
                this.wsdlModeler.generateWsdlModel(new WsdlModelListener(){

                    public void modelCreated(WsdlModel wsdlModel) {
                        JaxWsChildren.this.modelGenerationFinished = true;
                        if (wsdlModel == null) {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new JaxWsUtils.WsImportServiceFailedMessage(JaxWsChildren.this.wsdlModeler.getCreationException()));
                        }
                    }
                });
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().log(fileStateInvalidException.getLocalizedMessage());
                this.updateKeys();
            }
        } else {
            assert (this.implClass != null);
            if (this.fcl == null) {
                this.fcl = new FileChangeAdapter(){

                    public void fileChanged(FileEvent fileEvent) {
                        JaxWsChildren.this.updateKeys();
                    }
                };
                this.implClass.addFileChangeListener(this.fcl);
            }
            this.updateKeys();
        }
    }

    protected void removeNotify() {
        if (this.wsdlModeler != null) {
            this.wsdlModeler.removeWsdlChangeListener(this.wsdlChangeListener);
        }
        if (this.fcl != null) {
            this.implClass.removeFileChangeListener(this.fcl);
            this.fcl = null;
        }
        this.setKeys(Collections.emptySet());
    }

    private void updateKeys() {
        if (this.isFromWsdl()) {
            WsdlPort wsdlPort;
            WsdlService wsdlService;
            List list = new ArrayList();
            if (this.wsdlModel != null && (wsdlService = this.wsdlModel.getServiceByName(this.service.getServiceName())) != null && (wsdlPort = wsdlService.getPortByName(this.service.getPortName())) != null) {
                list = wsdlPort.getOperations();
            }
            this.setKeys(list);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JavaSource javaSource;
                    final List[] listArray = new List[1];
                    if (JaxWsChildren.this.implClass != null && (javaSource = JavaSource.forFileObject((FileObject)JaxWsChildren.this.implClass)) != null) {
                        CancellableTask<CompilationController> cancellableTask = new CancellableTask<CompilationController>(){

                            public void run(CompilationController compilationController) throws IOException {
                                compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                                TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)compilationController);
                                if (typeElement != null) {
                                    List list = JaxWsChildren.this.getPublicMethods(compilationController, typeElement);
                                    ArrayList<ExecutableElement> arrayList = new ArrayList<ExecutableElement>();
                                    ArrayList<Object> arrayList2 = new ArrayList<Object>();
                                    TypeElement typeElement2 = compilationController.getElements().getTypeElement("javax.jws.WebMethod");
                                    if (typeElement2 != null) {
                                        List<? extends VariableElement> list2;
                                        Object object;
                                        Object object2;
                                        boolean bl = false;
                                        for (ExecutableElement executableElement : list) {
                                            object2 = executableElement.getAnnotationMirrors();
                                            boolean bl2 = false;
                                            object = object2.iterator();
                                            while (object.hasNext()) {
                                                list2 = object.next();
                                                if (!compilationController.getTypes().isSameType(typeElement2.asType(), list2.getAnnotationType())) continue;
                                                bl2 = true;
                                                break;
                                            }
                                            if (bl2) {
                                                if (!bl) {
                                                    bl = true;
                                                    if (arrayList.size() > 0) {
                                                        arrayList.clear();
                                                    }
                                                }
                                                arrayList.add(executableElement);
                                                continue;
                                            }
                                            if (bl) continue;
                                            arrayList.add(executableElement);
                                        }
                                        for (ExecutableElement executableElement : arrayList) {
                                            Object object3;
                                            object2 = new WebOperationInfo();
                                            List<? extends AnnotationMirror> list3 = executableElement.getAnnotationMirrors();
                                            object = list3.iterator();
                                            while (object.hasNext()) {
                                                list2 = object.next();
                                                if (!compilationController.getTypes().isSameType(typeElement2.asType(), list2.getAnnotationType())) continue;
                                                object3 = list2.getElementValues();
                                                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : object3.entrySet()) {
                                                    if (!entry.getKey().getSimpleName().contentEquals("operationName")) continue;
                                                    ((WebOperationInfo)object2).setOperationName((String)((AnnotationValue)object3.get(entry.getKey())).getValue());
                                                }
                                            }
                                            if (((WebOperationInfo)object2).getOperationName() == null) {
                                                ((WebOperationInfo)object2).setOperationName(executableElement.getSimpleName().toString());
                                            }
                                            if ((object = executableElement.getReturnType()).getKind() == TypeKind.DECLARED) {
                                                list2 = (TypeElement)((DeclaredType)object).asElement();
                                                ((WebOperationInfo)object2).setReturnType(list2.getQualifiedName().toString());
                                            } else {
                                                ((WebOperationInfo)object2).setReturnType(object.toString());
                                            }
                                            list2 = executableElement.getParameters();
                                            object3 = new ArrayList();
                                            for (VariableElement variableElement : list2) {
                                                TypeMirror typeMirror = variableElement.asType();
                                                if (typeMirror.getKind() == TypeKind.DECLARED) {
                                                    TypeElement typeElement3 = (TypeElement)((DeclaredType)typeMirror).asElement();
                                                    object3.add(typeElement3.getQualifiedName().toString());
                                                    continue;
                                                }
                                                object3.add(((Object)typeMirror).toString());
                                            }
                                            ((WebOperationInfo)object2).setParamTypes((List<String>)object3);
                                            arrayList2.add(object2);
                                        }
                                    }
                                    listArray[0] = arrayList2;
                                }
                            }

                            public void cancel() {
                            }
                        };
                        try {
                            javaSource.runUserActionTask((Task)cancellableTask, true);
                        }
                        catch (IOException iOException) {
                            ErrorManager.getDefault().notify((Throwable)iOException);
                        }
                    }
                    if (listArray[0] == null) {
                        listArray[0] = Collections.emptyList();
                    }
                    JaxWsChildren.this.setKeys(listArray[0]);
                }
            });
        }
    }

    protected Node[] createNodes(Object object) {
        if (object instanceof WsdlOperation) {
            return new Node[]{new OperationNode((WsdlOperation)object)};
        }
        if (object instanceof WebOperationInfo) {
            final WebOperationInfo webOperationInfo = (WebOperationInfo)object;
            AbstractNode abstractNode = new AbstractNode(Children.LEAF){

                public Image getIcon(int n) {
                    if (JaxWsChildren.this.cachedIcon == null) {
                        JaxWsChildren.this.cachedIcon = Utilities.loadImage((String)JaxWsChildren.OPERATION_ICON);
                    }
                    return JaxWsChildren.this.cachedIcon;
                }

                public String getDisplayName() {
                    return webOperationInfo.getOperationName() + ": " + JaxWsChildren.this.getClassName(webOperationInfo.getReturnType());
                }
            };
            StringBuffer stringBuffer = new StringBuffer();
            for (String string : webOperationInfo.getParamTypes()) {
                stringBuffer.append(stringBuffer.length() == 0 ? string : ", " + string);
            }
            abstractNode.setShortDescription(NbBundle.getMessage(JaxWsClientChildren.class, (String)"TXT_operationDesc", (Object)webOperationInfo.getReturnType(), (Object)webOperationInfo.getOperationName(), (Object)stringBuffer.toString()));
            return new Node[]{abstractNode};
        }
        return new Node[0];
    }

    private boolean isFromWsdl() {
        return this.service.getWsdlUrl() != null;
    }

    private JAXWSSupport getJAXWSSupport() {
        return JAXWSSupport.getJAXWSSupport((FileObject)this.srcRoot);
    }

    private String getClassName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        return string2;
    }

    private void setBindings(JAXWSSupport jAXWSSupport, WsdlModeler wsdlModeler, Service service) {
        Binding[] bindingArray = service.getBindings();
        if (bindingArray == null || bindingArray.length == 0) {
            wsdlModeler.setJAXBBindings(null);
            return;
        }
        String[] stringArray = new String[bindingArray.length];
        for (int i = 0; i < bindingArray.length; ++i) {
            stringArray[i] = bindingArray[i].getFileName();
        }
        FileObject fileObject = jAXWSSupport.getBindingsFolderForService(this.getNode().getName(), true);
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (int i = 0; i < stringArray.length; ++i) {
            FileObject fileObject2 = fileObject.getFileObject(stringArray[i]);
            try {
                arrayList.add(fileObject2.getURL());
                continue;
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
        }
        URL[] uRLArray = new URL[arrayList.size()];
        arrayList.toArray(uRLArray);
        wsdlModeler.setJAXBBindings(uRLArray);
    }

    void refreshKeys(boolean bl, final boolean bl2, String string) {
        if (!this.isFromWsdl()) {
            return;
        }
        super.addNotify();
        try {
            Object object;
            String string2;
            JAXWSSupport jAXWSSupport = this.getJAXWSSupport();
            if (bl) {
                Object object2;
                String string3;
                string2 = this.getNode().getName();
                object = jAXWSSupport.getLocalWsdlFolderForService(string2, true);
                FileObject fileObject = null;
                try {
                    string3 = this.service.getWsdlUrl();
                    boolean bl3 = false;
                    if (string.length() > 0 && !string3.equals(string)) {
                        fileObject = WSUtils.retrieveResource((FileObject)object, (URI)new URI(string));
                        bl3 = true;
                    } else {
                        fileObject = WSUtils.retrieveResource((FileObject)object, (URI)new URI(string3));
                    }
                    if (bl3) {
                        JaxWsModel jaxWsModel;
                        String string4;
                        this.service.setWsdlUrl(string);
                        object2 = jAXWSSupport.getLocalWsdlFolderForService(string2, false);
                        if (object2 != null) {
                            string4 = FileUtil.getRelativePath((FileObject)object2, (FileObject)fileObject);
                            this.service.setLocalWsdlFile(string4);
                        }
                        if ((jaxWsModel = (JaxWsModel)(string4 = FileOwnerQuery.getOwner((FileObject)this.srcRoot)).getLookup().lookup(JaxWsModel.class)) != null) {
                            jaxWsModel.write();
                        }
                    }
                    object2 = this.getWsdlFolderForService(jAXWSSupport, string2);
                    WSUtils.copyFiles((FileObject)object, (FileObject)object2);
                }
                catch (URISyntaxException uRISyntaxException) {
                    ErrorManager.getDefault().notify((Throwable)uRISyntaxException);
                }
                catch (UnknownHostException unknownHostException) {
                    ErrorManager.getDefault().annotate((Throwable)unknownHostException, NbBundle.getMessage(JaxWsClientChildren.class, (String)"MSG_ConnectionProblem"));
                    return;
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().annotate((Throwable)iOException, NbBundle.getMessage(JaxWsClientChildren.class, (String)"MSG_ConnectionProblem"));
                    return;
                }
                if (fileObject != null) {
                    string3 = null;
                    try {
                        string3 = WsdlWrapperGenerator.parse((String)fileObject.getURL().toExternalForm());
                    }
                    catch (ParserConfigurationException parserConfigurationException) {
                        ErrorManager.getDefault().notify(1, (Throwable)parserConfigurationException);
                    }
                    catch (SAXException sAXException) {
                        ErrorManager.getDefault().notify(1, (Throwable)sAXException);
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(1, (Throwable)iOException);
                    }
                    if (!string3.isServiceElement()) {
                        StreamSource streamSource = new StreamSource(fileObject.getURL().toExternalForm());
                        try {
                            object2 = new File(FileUtil.toFile((FileObject)fileObject.getParent()), WsdlWrapperGenerator.getWrapperName((URL)fileObject.getURL()));
                            if (!((File)object2).exists()) {
                                try {
                                    ((File)object2).createNewFile();
                                }
                                catch (IOException iOException) {
                                    ErrorManager.getDefault().notify(4096, (Throwable)iOException);
                                }
                            }
                            if (((File)object2).exists()) {
                                WsdlWrapperGenerator.generateWrapperWSDLContent((File)object2, (StreamSource)streamSource, (String)string3.getTargetNsPrefix(), (String)fileObject.getNameExt());
                            }
                        }
                        catch (IOException iOException) {
                            ErrorManager.getDefault().notify(1, (Throwable)iOException);
                        }
                    }
                }
            }
            string2 = this.getJAXWSSupport().getLocalWsdlFolderForService(this.service.getName(), false).getFileObject(this.service.getLocalWsdlFile());
            this.wsdlModeler = WsdlModelerFactory.getDefault().getWsdlModeler(string2.getURL());
            object = this.service.getPackageName();
            if (object != null && this.service.isPackageNameForceReplace()) {
                this.wsdlModeler.setPackageName((String)object);
            } else {
                this.wsdlModeler.setPackageName(null);
            }
            this.wsdlModeler.setCatalog(jAXWSSupport.getCatalog());
            this.setBindings(jAXWSSupport, this.wsdlModeler, this.service);
            this.regenerateJavaArtifacts();
            this.modelGenerationFinished = false;
            ((JaxWsNode)this.getNode()).changeIcon();
            this.wsdlModeler.generateWsdlModel(new WsdlModelListener(){

                public void modelCreated(WsdlModel wsdlModel) {
                    JaxWsChildren.this.wsdlModel = wsdlModel;
                    JaxWsChildren.this.modelGenerationFinished = true;
                    ((JaxWsNode)JaxWsChildren.this.getNode()).changeIcon();
                    if (wsdlModel == null) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new JaxWsUtils.WsImportServiceFailedMessage(JaxWsChildren.this.wsdlModeler.getCreationException()));
                    }
                    if (wsdlModel != null) {
                        try {
                            JaxWsModel jaxWsModel;
                            String string;
                            Object object;
                            int n;
                            WsdlPort wsdlPort;
                            String string2 = JaxWsChildren.this.service.getServiceName();
                            String string3 = JaxWsChildren.this.service.getPortName();
                            WsdlService wsdlService = wsdlModel.getServiceByName(string2);
                            boolean bl = false;
                            if (wsdlService == null) {
                                wsdlService = (WsdlService)wsdlModel.getServices().get(0);
                                JaxWsChildren.this.service.setServiceName(wsdlService.getName());
                                bl = true;
                            }
                            if ((wsdlPort = wsdlService.getPortByName(string3)) == null) {
                                wsdlPort = (WsdlPort)wsdlService.getPorts().get(0);
                                JaxWsChildren.this.service.setPortName(wsdlPort.getName());
                                bl = true;
                            }
                            String string4 = JaxWsChildren.this.service.getPackageName();
                            if (wsdlService != null && string4 != null && !JaxWsChildren.this.service.isPackageNameForceReplace() && (n = ((String)(object = wsdlService.getJavaName())).lastIndexOf(".")) >= 0 && !string4.equals(string = ((String)object).substring(0, n))) {
                                JaxWsChildren.this.service.setPackageName(string);
                                bl = true;
                            }
                            if (bl && (object = FileOwnerQuery.getOwner((FileObject)JaxWsChildren.this.srcRoot)) != null && (jaxWsModel = (JaxWsModel)object.getLookup().lookup(JaxWsModel.class)) != null) {
                                jaxWsModel.write();
                            }
                            if (bl2) {
                                FileObject fileObject;
                                object = JaxWsChildren.this.service.getImplementationClass();
                                FileObject fileObject2 = JaxWsChildren.this.srcRoot.getFileObject(((String)object).replace('.', '/') + ".java");
                                string = JaxWsChildren.this.srcRoot.getFileObject(((String)object).replace('.', '/') + ".java.old");
                                int n2 = ((String)object).lastIndexOf(".");
                                FileObject fileObject3 = fileObject = n2 > 0 ? JaxWsChildren.this.srcRoot.getFileObject(((String)object).substring(0, n2).replace('.', '/')) : JaxWsChildren.this.srcRoot;
                                if (fileObject != null) {
                                    Object object2;
                                    Object object3 = object2 = n2 >= 0 ? ((String)object).substring(n2 + 1) : object;
                                    if (fileObject2 != null) {
                                        if (string != null) {
                                            string.delete();
                                        }
                                        FileUtil.copyFile((FileObject)fileObject2, (FileObject)fileObject, (String)((String)object2 + ".java"), (String)"old");
                                        fileObject2.delete();
                                    }
                                    JaxWsNode jaxWsNode = (JaxWsNode)JaxWsChildren.this.getNode();
                                    JaxWsUtils.generateJaxWsImplementationClass(FileOwnerQuery.getOwner((FileObject)JaxWsChildren.this.srcRoot), fileObject, (String)object2, wsdlModel, JaxWsChildren.this.service);
                                    FileObject fileObject4 = JaxWsChildren.this.srcRoot.getFileObject(((String)object).replace('.', '/') + ".java");
                                    if (fileObject4 != null) {
                                        JaxWsChildren.this.implClass = fileObject4;
                                    }
                                    jaxWsNode.refreshImplClass();
                                }
                            }
                        }
                        catch (Exception exception) {
                            ErrorManager.getDefault().notify(65536, (Throwable)exception);
                        }
                    }
                }
            });
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            ErrorManager.getDefault().log(fileStateInvalidException.getLocalizedMessage());
        }
    }

    private void regenerateJavaArtifacts() {
        Project project = FileOwnerQuery.getOwner((FileObject)this.srcRoot);
        if (project != null) {
            FileObject fileObject = project.getProjectDirectory().getFileObject("build.xml");
            try {
                String string = this.service.getName();
                ExecutorTask executorTask = ActionUtils.runTarget((FileObject)fileObject, (String[])new String[]{"wsimport-service-clean-" + string, "wsimport-service-" + string}, null);
                executorTask.waitFinished();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().log(iOException.getLocalizedMessage());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ErrorManager.getDefault().log(illegalArgumentException.getLocalizedMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject getWsdlFolderForService(JAXWSSupport jAXWSSupport, String string) throws IOException {
        FileObject fileObject = jAXWSSupport.getWsdlFolder(true);
        FileObject fileObject2 = fileObject.getFileObject(string);
        if (fileObject2 != null) {
            FileLock fileLock = fileObject2.lock();
            try {
                fileObject2.delete(fileLock);
            }
            finally {
                fileLock.releaseLock();
            }
        }
        return fileObject.createFolder(string);
    }

    WsdlModeler getWsdlModeler() {
        return this.wsdlModeler;
    }

    boolean isModelGenerationFinished() {
        return this.modelGenerationFinished;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WebOperationInfo {
        private String operationName;
        private List<String> paramTypes;
        private String returnType;

        private WebOperationInfo() {
        }

        String getOperationName() {
            return this.operationName;
        }

        void setOperationName(String string) {
            this.operationName = string;
        }

        List<String> getParamTypes() {
            return this.paramTypes;
        }

        void setParamTypes(List<String> list) {
            this.paramTypes = list;
        }

        String getReturnType() {
            return this.returnType;
        }

        void setReturnType(String string) {
            this.returnType = string;
        }
    }
}

