/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.client.wizard;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.core.ClientCreator;
import org.netbeans.modules.websvc.core.WSStackUtils;
import org.netbeans.modules.websvc.core.client.wizard.WebServiceClientWizardIterator;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxWsClientCreator
implements ClientCreator {
    private Project project;
    private WizardDescriptor wiz;
    private static final boolean DEBUG = false;
    private static final int JSE_PROJECT_TYPE = 0;
    private static final int WEB_PROJECT_TYPE = 1;
    private static final int EJB_PROJECT_TYPE = 2;
    private static final int CAR_PROJECT_TYPE = 3;
    Task task;

    public JaxWsClientCreator(Project project, WizardDescriptor wizardDescriptor) {
        this.project = project;
        this.wiz = wizardDescriptor;
    }

    @Override
    public void createClient() throws IOException {
        WSStackUtils wSStackUtils = new WSStackUtils(this.project);
        final boolean bl = wSStackUtils.isJsr109Supported();
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(JaxWsClientCreator.class, (String)"MSG_WizCreateClient"));
        this.task = new Task(new Runnable(){

            public void run() {
                try {
                    progressHandle.start();
                    JaxWsClientCreator.this.generate15Client(bl, progressHandle);
                }
                catch (IOException iOException) {
                    progressHandle.finish();
                    ErrorManager.getDefault().notify(4096, (Throwable)iOException);
                }
            }
        });
        RequestProcessor.getDefault().post((Runnable)this.task);
    }

    private void generate15Client(boolean bl, ProgressHandle progressHandle) throws IOException {
        String string;
        JAXWSClientSupport jAXWSClientSupport = null;
        if (this.project != null) {
            jAXWSClientSupport = JAXWSClientSupport.getJaxWsClientSupport((FileObject)this.project.getProjectDirectory());
        }
        if (jAXWSClientSupport == null) {
            String string2 = NbBundle.getMessage(WebServiceClientWizardIterator.class, (String)"ERR_NoWebServiceClientSupport");
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            progressHandle.finish();
            return;
        }
        String string3 = (String)this.wiz.getProperty("wsdlDownloadUrl");
        String string4 = (String)this.wiz.getProperty("wsdlFilePath");
        Boolean bl2 = (Boolean)this.wiz.getProperty("useDispatch");
        if (string3 == null) {
            string3 = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(string4))).getURL().toExternalForm();
        }
        if ((string = (String)this.wiz.getProperty("wsdlPackageName")) != null && string.length() == 0) {
            string = null;
        }
        String string5 = jAXWSClientSupport.addServiceClient(this.getWsdlName(string3), string3, string, bl);
        if (bl2.booleanValue()) {
            List list = jAXWSClientSupport.getServiceClients();
            for (Object e : list) {
                if (!((Client)e).getName().equals(string5)) continue;
                ((Client)e).setUseDispatch(bl2);
            }
            JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
            jaxWsModel.write();
        }
        progressHandle.finish();
    }

    private String getWsdlName(String string) {
        String string2;
        int n = string.lastIndexOf("/");
        String string3 = string2 = n >= 0 ? string.substring(n + 1) : string;
        if (string2.toUpperCase().endsWith("?WSDL")) {
            string2 = string2.substring(0, string2.length() - 5);
        }
        if ((n = string2.lastIndexOf(".")) > 0) {
            string2 = string2.substring(0, n);
        }
        return this.convertAllSpecialChars(string2);
    }

    private String convertAllSpecialChars(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '/' || c == '.' || c == '_' || c == ' ' || c == '-') continue;
            stringBuffer.setCharAt(i, '_');
        }
        return stringBuffer.toString();
    }

    static SourceGroup[] getJavaSourceGroups(Project project) {
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        Set<SourceGroup> set = JaxWsClientCreator.getTestSourceGroups(project, sourceGroupArray);
        ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>();
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            if (set.contains(sourceGroupArray[i])) continue;
            arrayList.add(sourceGroupArray[i]);
        }
        return arrayList.toArray(new SourceGroup[arrayList.size()]);
    }

    private static Set<SourceGroup> getTestSourceGroups(Project project, SourceGroup[] sourceGroupArray) {
        Map<FileObject, SourceGroup> map = JaxWsClientCreator.createFoldersToSourceGroupsMap(sourceGroupArray);
        HashSet<SourceGroup> hashSet = new HashSet<SourceGroup>();
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            hashSet.addAll(JaxWsClientCreator.getTestTargets(sourceGroupArray[i], map));
        }
        return hashSet;
    }

    private static List<SourceGroup> getTestTargets(SourceGroup sourceGroup, Map<FileObject, SourceGroup> map) {
        URL[] uRLArray = UnitTestForSourceQuery.findUnitTests((FileObject)sourceGroup.getRootFolder());
        if (uRLArray.length == 0) {
            return new ArrayList<SourceGroup>();
        }
        ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>();
        List<FileObject> list = JaxWsClientCreator.getFileObjects(uRLArray);
        for (int i = 0; i < list.size(); ++i) {
            FileObject fileObject = list.get(i);
            SourceGroup sourceGroup2 = map.get(fileObject);
            if (sourceGroup2 == null) continue;
            arrayList.add(sourceGroup2);
        }
        return arrayList;
    }

    private static Map<FileObject, SourceGroup> createFoldersToSourceGroupsMap(SourceGroup[] sourceGroupArray) {
        Map<FileObject, SourceGroup> map;
        if (sourceGroupArray.length == 0) {
            map = Collections.emptyMap();
        } else {
            map = new HashMap<FileObject, SourceGroup>(2 * sourceGroupArray.length, 0.5f);
            for (int i = 0; i < sourceGroupArray.length; ++i) {
                SourceGroup sourceGroup = sourceGroupArray[i];
                map.put(sourceGroup.getRootFolder(), sourceGroup);
            }
        }
        return map;
    }

    private static List<FileObject> getFileObjects(URL[] uRLArray) {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (int i = 0; i < uRLArray.length; ++i) {
            FileObject fileObject = URLMapper.findFileObject((URL)uRLArray[i]);
            if (fileObject != null) {
                arrayList.add(fileObject);
                continue;
            }
            int n = 1;
            if (!ErrorManager.getDefault().isNotifiable(n)) continue;
            ErrorManager.getDefault().notify(n, (Throwable)new IllegalStateException("No FileObject found for the following URL: " + uRLArray[i]));
        }
        return arrayList;
    }
}

