/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.xml.retriever.Retriever;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlRetriever
implements Runnable {
    public static final int STATUS_START = 0;
    public static final int STATUS_CONNECTING = 1;
    public static final int STATUS_DOWNLOADING = 2;
    public static final int STATUS_COMPLETE = 3;
    public static final int STATUS_FAILED = 4;
    public static final int STATUS_TERMINATED = 5;
    public static final int STATUS_BAD_WSDL = 6;
    static final String[] STATUS_MESSAGE = new String[]{NbBundle.getMessage(WsdlRetriever.class, (String)"LBL_Ready"), NbBundle.getMessage(WsdlRetriever.class, (String)"LBL_Connecting"), NbBundle.getMessage(WsdlRetriever.class, (String)"LBL_Downloading"), NbBundle.getMessage(WsdlRetriever.class, (String)"LBL_Complete"), NbBundle.getMessage(WsdlRetriever.class, (String)"LBL_Exception"), NbBundle.getMessage(WsdlRetriever.class, (String)"LBL_Terminated"), NbBundle.getMessage(WsdlRetriever.class, (String)"LBL_UnknownFileType")};
    private volatile boolean shutdown = false;
    private volatile int status = 0;
    private String wsdlUrlName;
    private byte[] wsdlContent;
    private List<SchemaInfo> schemas;
    private String wsdlFileName;
    private MessageReceiver receiver;
    private URL wsdlUrl;
    private URLConnection connection;
    private InputStream in;

    public WsdlRetriever(MessageReceiver messageReceiver, String string) {
        this.wsdlUrlName = string;
        this.wsdlContent = null;
        this.wsdlFileName = null;
        this.schemas = null;
        this.receiver = messageReceiver;
    }

    public byte[] getWsdl() {
        return this.wsdlContent;
    }

    public List<SchemaInfo> getSchemas() {
        return this.schemas;
    }

    public int getState() {
        return this.status;
    }

    public String getWsdlFileName() {
        return this.wsdlFileName;
    }

    public String getWsdlUrl() {
        return this.wsdlUrlName;
    }

    public synchronized void stopRetrieval() {
        this.shutdown = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setName("WsdlRetrieval");
        this.wsdlUrl = null;
        this.connection = null;
        this.in = null;
        try {
            List<String> list;
            this.wsdlUrlName = WsdlRetriever.beautifyUrlName(this.wsdlUrlName);
            this.wsdlUrl = new URL(this.wsdlUrlName);
            this.setState(1);
            if (this.wsdlUrlName.startsWith("https")) {
                this.setRetrieverTrustManager();
            }
            this.connection = this.wsdlUrl.openConnection();
            this.in = this.connection.getInputStream();
            this.setState(2);
            this.wsdlContent = this.downloadWsdlFileEncoded(new BufferedInputStream(this.in));
            WsdlInfo wsdlInfo = null;
            if (!this.shutdown) {
                wsdlInfo = this.getWsdlInfo();
                if (wsdlInfo != null) {
                    list = wsdlInfo.getSchemaNames();
                    if (!list.isEmpty()) {
                        this.schemas = new ArrayList<SchemaInfo>();
                        Iterator<String> iterator = list.iterator();
                        while (!this.shutdown && iterator.hasNext()) {
                            String string = iterator.next();
                            String string2 = this.getSchemaUrlName(this.wsdlUrlName, string);
                            URL uRL = new URL(string2);
                            this.connection = uRL.openConnection();
                            this.in = this.connection.getInputStream();
                            this.schemas.add(new SchemaInfo(string, this.downloadWsdlFileEncoded(new BufferedInputStream(this.in))));
                        }
                    }
                } else {
                    throw new MalformedURLException();
                }
            }
            if (!this.shutdown) {
                list = wsdlInfo.getServiceNameList();
                if (list != null && list.size() > 0) {
                    this.wsdlFileName = this.wsdlUrl.getPath();
                    int n = this.wsdlFileName.lastIndexOf(47);
                    if (n != -1) {
                        this.wsdlFileName = this.wsdlFileName.substring(n + 1);
                    }
                    if (this.wsdlFileName.length() == 0) {
                        this.wsdlFileName = list.get(0) + ".wsdl";
                    } else if (this.wsdlFileName.length() < 5 || !".wsdl".equals(this.wsdlFileName.substring(this.wsdlFileName.length() - 5))) {
                        this.wsdlFileName = this.wsdlFileName + ".wsdl";
                    }
                    this.setState(3);
                } else {
                    this.setState(6);
                }
            } else {
                this.setState(5);
            }
        }
        catch (ConnectException connectException) {
            this.setState(4, NbBundle.getMessage(WsdlRetriever.class, (String)"ERR_Connection"), connectException);
            this.log(connectException.getMessage());
        }
        catch (MalformedURLException malformedURLException) {
            this.setState(4, NbBundle.getMessage(WsdlRetriever.class, (String)"ERR_BadUrl"), malformedURLException);
            this.log(malformedURLException.getMessage());
        }
        catch (IOException iOException) {
            this.setState(4, NbBundle.getMessage(WsdlRetriever.class, (String)"ERR_IOException"), iOException);
            this.log(iOException.getMessage());
        }
        finally {
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private byte[] downloadWsdlFileEncoded(InputStream inputStream) throws IOException {
        int n;
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
        boolean bl = false;
        byte[] byArray = new byte[]{};
        while (!this.shutdown && !bl) {
            byte[] byArray2 = new byte[65536];
            int n2 = 0;
            n = 0;
            int n3 = byArray2.length;
            int n4 = 0;
            while (!this.shutdown && (n = inputStream.read(byArray2, n2, n3)) != -1) {
                n2 += n;
                n4 += n;
                if ((n3 -= n) != 0) continue;
            }
            if (n4 > 0) {
                arrayList.add(new Chunk(byArray2, n4));
            }
            bl = n == -1;
        }
        if (!this.shutdown) {
            int n5 = 0;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                n5 += ((Chunk)iterator.next()).getLength();
            }
            byArray = new byte[n5];
            n = 0;
            for (Chunk chunk : arrayList) {
                System.arraycopy(chunk.getData(), 0, byArray, n, chunk.getLength());
                n += chunk.getLength();
            }
        }
        return byArray;
    }

    public static String beautifyUrlName(String string) {
        if (string.indexOf("://") == -1) {
            return "http://" + string;
        }
        return string;
    }

    private String getSchemaUrlName(String string, String string2) {
        int n = string.lastIndexOf("/");
        if (n >= 0) {
            return string.substring(0, n + 1) + string2;
        }
        return null;
    }

    private void setState(int n) {
        this.status = n;
        this.log(STATUS_MESSAGE[n]);
        SwingUtilities.invokeLater(new MessageSender(this.receiver, STATUS_MESSAGE[n]));
    }

    private void setState(int n, String string, Exception exception) {
        this.status = n;
        Object[] objectArray = new Object[]{string, exception.getMessage()};
        String string2 = MessageFormat.format(STATUS_MESSAGE[n], objectArray);
        this.log(string2);
        SwingUtilities.invokeLater(new MessageSender(this.receiver, string2));
    }

    private void log(String string) {
    }

    private WsdlInfo getWsdlInfo() {
        WsdlInfo wsdlInfo = null;
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            ServiceNameParser serviceNameParser = new ServiceNameParser();
            sAXParser.parse(new InputSource(new ByteArrayInputStream(this.wsdlContent)), (DefaultHandler)serviceNameParser);
            wsdlInfo = new WsdlInfo(serviceNameParser.getServiceNameList(), serviceNameParser.getSchemaNames());
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return wsdlInfo;
    }

    private void setRetrieverTrustManager() {
        TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
            }

            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                if (x509CertificateArray != null) {
                    for (int i = 0; i < x509CertificateArray.length; ++i) {
                        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)Retriever.getCertificationPanel((X509Certificate)x509CertificateArray[i]), NbBundle.getMessage(WsdlRetriever.class, (String)"TTL_CertifiedWebSite"), true, 0, DialogDescriptor.YES_OPTION, null);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
                        if (DialogDescriptor.YES_OPTION.equals(dialogDescriptor.getValue())) continue;
                        throw new CertificateException(NbBundle.getMessage(WsdlRetriever.class, (String)"ERR_NotTrustedCertificate"));
                    }
                }
            }
        }};
        try {
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(null, trustManagerArray, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                public boolean verify(String string, SSLSession sSLSession) {
                    return true;
                }
            });
        }
        catch (GeneralSecurityException generalSecurityException) {
            ErrorManager.getDefault().notify((Throwable)generalSecurityException);
        }
    }

    public static class SchemaInfo {
        private String schemaName;
        private byte[] schemaContent;

        SchemaInfo(String string, byte[] byArray) {
            this.schemaName = string;
            this.schemaContent = byArray;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public byte[] getSchemaContent() {
            return this.schemaContent;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WsdlInfo {
        private List<String> serviceNameList;
        private List<String> schemaNames;

        WsdlInfo(List<String> list, List<String> list2) {
            this.serviceNameList = list;
            this.schemaNames = list2;
        }

        List<String> getSchemaNames() {
            return this.schemaNames;
        }

        List<String> getServiceNameList() {
            return this.serviceNameList;
        }
    }

    private static class Chunk {
        private int length;
        private byte[] data;

        public Chunk(byte[] byArray, int n) {
            this.data = byArray;
            this.length = n;
        }

        public byte[] getData() {
            return this.data;
        }

        public int getLength() {
            return this.length;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ServiceNameParser
    extends DefaultHandler {
        private static final String W3C_WSDL_SCHEMA = "http://schemas.xmlsoap.org/wsdl";
        private static final String W3C_WSDL_SCHEMA_SLASH = "http://schemas.xmlsoap.org/wsdl/";
        private List<String> serviceNameList = new ArrayList<String>();
        private List<String> schemaNames = new ArrayList<String>();
        private boolean insideSchema;

        ServiceNameParser() {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            String string4;
            if (W3C_WSDL_SCHEMA.equals(string) || W3C_WSDL_SCHEMA_SLASH.equals(string)) {
                if ("service".equals(string2)) {
                    this.serviceNameList.add(attributes.getValue("name"));
                }
                if ("types".equals(string2)) {
                    this.insideSchema = true;
                }
                if ("import".equals(string2) && (string4 = attributes.getValue("location")) != null && string4.indexOf("/") < 0 && string4.endsWith(".wsdl")) {
                    this.schemaNames.add(string4);
                }
            }
            if (this.insideSchema && "import".equals(string2) && (string4 = attributes.getValue("schemaLocation")) != null && string4.indexOf("/") < 0 && string4.endsWith(".xsd")) {
                this.schemaNames.add(string4);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if ((W3C_WSDL_SCHEMA.equals(string) || W3C_WSDL_SCHEMA_SLASH.equals(string)) && "types".equals(string2)) {
                this.insideSchema = false;
            }
        }

        public List<String> getServiceNameList() {
            return this.serviceNameList;
        }

        public List<String> getSchemaNames() {
            return this.schemaNames;
        }
    }

    public static interface MessageReceiver {
        public void setWsdlDownloadMessage(String var1);
    }

    private static class MessageSender
    implements Runnable {
        private MessageReceiver receiver;
        private String message;

        public MessageSender(MessageReceiver messageReceiver, String string) {
            this.receiver = messageReceiver;
            this.message = string;
        }

        public void run() {
            this.receiver.setWsdlDownloadMessage(this.message);
        }
    }
}

