/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.services;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmInheritanceUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.navigation.services.HierarchyModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HierarchyModelImpl
implements HierarchyModel {
    private Map<CsmClass, Set<CsmClass>> myMap;
    private Action[] actions;
    private Action close;

    public HierarchyModelImpl(CsmClass csmClass, Action[] actionArray, boolean bl, boolean bl2, boolean bl3) {
        Set<CsmClass> set;
        this.actions = actionArray;
        this.myMap = bl ? this.buildSubHierarchy(csmClass) : this.buildSuperHierarchy(csmClass);
        if (!bl3) {
            set = this.myMap.get(csmClass);
            if (set == null) {
                set = new HashSet<CsmClass>();
            }
            this.myMap = new HashMap<CsmClass, Set<CsmClass>>();
            this.myMap.put(csmClass, set);
        }
        if (bl2) {
            set = new HashSet<CsmClass>();
            this.gatherList(csmClass, set, this.myMap);
            this.myMap = new HashMap<CsmClass, Set<CsmClass>>();
            this.myMap.put(csmClass, set);
        }
    }

    @Override
    public Map<CsmClass, Set<CsmClass>> getModel() {
        return this.myMap;
    }

    private void gatherList(CsmClass csmClass, Set<CsmClass> set, Map<CsmClass, Set<CsmClass>> map) {
        Set<CsmClass> set2 = map.get(csmClass);
        if (set2 == null) {
            return;
        }
        for (CsmClass csmClass2 : set2) {
            if (set.contains(csmClass2)) continue;
            set.add(csmClass2);
            this.gatherList(csmClass2, set, map);
        }
    }

    private Map<CsmClass, Set<CsmClass>> buildSuperHierarchy(CsmClass csmClass) {
        HashMap<CsmClass, Set<CsmClass>> hashMap = new HashMap<CsmClass, Set<CsmClass>>();
        this.buildSuperHierarchy(csmClass, hashMap);
        return hashMap;
    }

    private void buildSuperHierarchy(CsmClass csmClass, Map<CsmClass, Set<CsmClass>> map) {
        Set<CsmClass> set = map.get(csmClass);
        if (set != null) {
            return;
        }
        set = new HashSet<CsmClass>();
        map.put(csmClass, set);
        Collection collection = csmClass.getBaseClasses();
        if (collection != null && collection.size() > 0) {
            for (CsmInheritance csmInheritance : collection) {
                CsmClass csmClass2 = CsmInheritanceUtilities.getCsmClass((CsmInheritance)csmInheritance);
                if (csmClass2 == null) continue;
                set.add(csmClass2);
                this.buildSuperHierarchy(csmClass2, map);
            }
        }
    }

    private Map<CsmClass, Set<CsmClass>> buildSubHierarchy(CsmClass csmClass) {
        HashMap<CsmClass, Set<CsmClass>> hashMap = new HashMap<CsmClass, Set<CsmClass>>();
        CsmProject csmProject = csmClass.getContainingFile().getProject();
        this.buildSubHierarchy(csmProject.getGlobalNamespace(), hashMap);
        return hashMap;
    }

    private void buildSubHierarchy(CsmNamespace csmNamespace, Map<CsmClass, Set<CsmClass>> map) {
        Iterator iterator = csmNamespace.getNestedNamespaces().iterator();
        while (iterator.hasNext()) {
            this.buildSubHierarchy((CsmNamespace)iterator.next(), map);
        }
        for (CsmDeclaration csmDeclaration : csmNamespace.getDeclarations()) {
            if (!CsmKindUtilities.isClass((CsmObject)csmDeclaration)) continue;
            this.buildSubHierarchy(map, (CsmClass)csmDeclaration);
        }
    }

    private void buildSubHierarchy(Map<CsmClass, Set<CsmClass>> map, CsmClass csmClass) {
        Collection collection = csmClass.getBaseClasses();
        if (collection != null && collection.size() > 0) {
            for (CsmMember csmMember : collection) {
                CsmClass csmClass2 = CsmInheritanceUtilities.getCsmClass((CsmInheritance)csmMember);
                if (csmClass2 == null) continue;
                Set<CsmClass> set = map.get(csmClass2);
                if (set == null) {
                    set = new HashSet<CsmClass>();
                    map.put(csmClass2, set);
                }
                set.add(csmClass);
            }
        }
        for (CsmMember csmMember : csmClass.getMembers()) {
            if (!CsmKindUtilities.isClass((CsmObject)csmMember)) continue;
            this.buildSubHierarchy(map, (CsmClass)csmMember);
        }
    }

    @Override
    public Action[] getDefaultActions() {
        return this.actions;
    }

    @Override
    public Action getCloseWindowAction() {
        return this.close;
    }

    @Override
    public void setCloseWindowAction(Action action) {
        this.close = action;
    }
}

