/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.classhierarchy;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyVetoException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.navigation.classhierarchy.HierarchyNode;
import org.netbeans.modules.cnd.navigation.services.HierarchyFactory;
import org.netbeans.modules.cnd.navigation.services.HierarchyModel;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;

public class ClassHierarchyPanel
extends JPanel
implements ExplorerManager.Provider,
HelpCtx.Provider {
    public static final String ICON_PATH = "org/netbeans/modules/cnd/navigation/classhierarchy/resources/subtypehierarchy.gif";
    private AbstractNode root;
    private CsmUID<CsmClass> object;
    private boolean subDirection = true;
    private boolean recursive = true;
    private boolean plain = false;
    private ExplorerManager explorerManager = new ExplorerManager();
    private Action[] actions;
    private Action close;
    private JToggleButton directOnlyButton;
    private ButtonGroup directionGroup;
    private JScrollPane hierarchyPane;
    private JPanel jPanel2;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JButton refreshButton;
    private JToggleButton subtypeButton;
    private JToggleButton supertypeButton;
    private JToolBar toolBar;
    private JToggleButton treeButton;
    private static final int SUB_TYPES = 1;
    private static final int SUPER_TYPES = 2;
    private static final int DIRECT_ONLY = 3;
    private static final int TREE = 4;

    public ClassHierarchyPanel(boolean bl) {
        this.initComponents();
        if (!bl) {
            this.toolBar.remove(0);
            this.toolBar.remove(0);
            this.directOnlyButton.setFocusable(true);
            this.subtypeButton.setFocusable(true);
            this.supertypeButton.setFocusable(true);
            this.treeButton.setFocusable(true);
        }
        this.setName(NbBundle.getMessage(this.getClass(), (String)"CTL_ClassHierarchyTopComponent"));
        this.setToolTipText(NbBundle.getMessage(this.getClass(), (String)"HINT_ClassHierarchyTopComponent"));
        this.getTreeView().setRootVisible(false);
        Children.SortedArray sortedArray = new Children.SortedArray();
        this.actions = bl ? new Action[]{new RefreshAction(), null, new SubTypeAction(), new SuperTypeAction(), null, new DirectOnlyAction(), new TreeAction()} : new Action[]{null, new SubTypeAction(), new SuperTypeAction(), null, new DirectOnlyAction(), new TreeAction()};
        this.root = new AbstractNode((Children)sortedArray){

            public Action[] getActions(boolean bl) {
                return ClassHierarchyPanel.this.actions;
            }
        };
        this.getExplorerManager().setRootContext((Node)this.root);
    }

    public void setClose() {
        this.close = new DialogClose();
        this.getTreeView().addCloseAction(this.close);
    }

    public void clearClose() {
        this.close = null;
        this.getTreeView().addCloseAction(this.close);
    }

    private MyBeanTreeView getTreeView() {
        return (MyBeanTreeView)((Object)this.hierarchyPane);
    }

    private void initComponents() {
        this.directionGroup = new ButtonGroup();
        this.toolBar = new JToolBar();
        this.refreshButton = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.subtypeButton = new JToggleButton();
        this.supertypeButton = new JToggleButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.directOnlyButton = new JToggleButton();
        this.treeButton = new JToggleButton();
        this.jPanel2 = new JPanel();
        this.hierarchyPane = new MyBeanTreeView();
        this.setLayout(new GridBagLayout());
        this.toolBar.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.toolBar.setFloatable(false);
        this.toolBar.setBorderPainted(false);
        this.toolBar.setMaximumSize(new Dimension(74, 26));
        this.toolBar.setMinimumSize(new Dimension(74, 26));
        this.toolBar.setOpaque(false);
        this.refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/navigation/classhierarchy/resources/refresh.png")));
        this.refreshButton.setToolTipText(NbBundle.getMessage(ClassHierarchyPanel.class, (String)"ClassHierarchyPanel.refreshButton.toolTipText"));
        this.refreshButton.setFocusable(false);
        this.refreshButton.setHorizontalTextPosition(0);
        this.refreshButton.setMaximumSize(new Dimension(24, 24));
        this.refreshButton.setMinimumSize(new Dimension(24, 24));
        this.refreshButton.setPreferredSize(new Dimension(24, 24));
        this.refreshButton.setVerticalTextPosition(3);
        this.refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassHierarchyPanel.this.refreshButtonActionPerformed(actionEvent);
            }
        });
        this.toolBar.add(this.refreshButton);
        this.toolBar.add(this.jSeparator1);
        this.directionGroup.add(this.subtypeButton);
        this.subtypeButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/navigation/classhierarchy/resources/subtypehierarchy.gif")));
        this.subtypeButton.setSelected(true);
        this.subtypeButton.setToolTipText(NbBundle.getMessage(ClassHierarchyPanel.class, (String)"ClassHierarchyPanel.subtypeButton.toolTipText"));
        this.subtypeButton.setFocusable(false);
        this.subtypeButton.setHorizontalTextPosition(0);
        this.subtypeButton.setMaximumSize(new Dimension(24, 24));
        this.subtypeButton.setMinimumSize(new Dimension(24, 24));
        this.subtypeButton.setPreferredSize(new Dimension(24, 24));
        this.subtypeButton.setVerticalTextPosition(3);
        this.subtypeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassHierarchyPanel.this.subtypeButtonActionPerformed(actionEvent);
            }
        });
        this.toolBar.add(this.subtypeButton);
        this.directionGroup.add(this.supertypeButton);
        this.supertypeButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/navigation/classhierarchy/resources/supertypehierarchy.gif")));
        this.supertypeButton.setToolTipText(NbBundle.getMessage(ClassHierarchyPanel.class, (String)"ClassHierarchyPanel.supertypeButton.toolTipText"));
        this.supertypeButton.setFocusable(false);
        this.supertypeButton.setHorizontalTextPosition(0);
        this.supertypeButton.setMaximumSize(new Dimension(24, 24));
        this.supertypeButton.setMinimumSize(new Dimension(24, 24));
        this.supertypeButton.setPreferredSize(new Dimension(24, 24));
        this.supertypeButton.setVerticalTextPosition(3);
        this.supertypeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassHierarchyPanel.this.supertypeButtonActionPerformed(actionEvent);
            }
        });
        this.toolBar.add(this.supertypeButton);
        this.toolBar.add(this.jSeparator2);
        this.directOnlyButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/navigation/classhierarchy/resources/direct_only.png")));
        this.directOnlyButton.setText(NbBundle.getMessage(ClassHierarchyPanel.class, (String)"ClassHierarchyPanel.directOnlyButton.text"));
        this.directOnlyButton.setToolTipText(NbBundle.getMessage(ClassHierarchyPanel.class, (String)"ClassHierarchyPanel.directOnlyButton.toolTipText"));
        this.directOnlyButton.setFocusable(false);
        this.directOnlyButton.setHorizontalTextPosition(0);
        this.directOnlyButton.setMaximumSize(new Dimension(24, 24));
        this.directOnlyButton.setMinimumSize(new Dimension(24, 24));
        this.directOnlyButton.setPreferredSize(new Dimension(24, 24));
        this.directOnlyButton.setVerticalTextPosition(3);
        this.directOnlyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassHierarchyPanel.this.directOnlyButtonActionPerformed(actionEvent);
            }
        });
        this.toolBar.add(this.directOnlyButton);
        this.treeButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/navigation/classhierarchy/resources/tree.png")));
        this.treeButton.setText(NbBundle.getMessage(ClassHierarchyPanel.class, (String)"ClassHierarchyPanel.treeButton.text"));
        this.treeButton.setToolTipText(NbBundle.getMessage(ClassHierarchyPanel.class, (String)"ClassHierarchyPanel.treeButton.toolTipText"));
        this.treeButton.setFocusable(false);
        this.treeButton.setHorizontalTextPosition(0);
        this.treeButton.setMaximumSize(new Dimension(24, 24));
        this.treeButton.setMinimumSize(new Dimension(24, 24));
        this.treeButton.setPreferredSize(new Dimension(24, 24));
        this.treeButton.setVerticalTextPosition(3);
        this.treeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassHierarchyPanel.this.treeButtonActionPerformed(actionEvent);
            }
        });
        this.toolBar.add(this.treeButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        this.add((Component)this.toolBar, gridBagConstraints);
        this.jPanel2.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("SplitPane.shadow")));
        this.jPanel2.setMinimumSize(new Dimension(1, 1));
        this.jPanel2.setPreferredSize(new Dimension(1, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.hierarchyPane, gridBagConstraints);
    }

    private void refreshButtonActionPerformed(ActionEvent actionEvent) {
        CsmClass csmClass;
        if (this.object != null && (csmClass = (CsmClass)this.object.getObject()) != null) {
            this.update(csmClass);
        }
    }

    private void subtypeButtonActionPerformed(ActionEvent actionEvent) {
        if (this.subDirection == this.subtypeButton.isSelected()) {
            return;
        }
        this.setSubtypeHierarchy(true);
    }

    private void setSubtypeHierarchy(boolean bl) {
        CsmClass csmClass;
        if (this.object != null && (csmClass = (CsmClass)this.object.getObject()) != null) {
            this.subDirection = bl;
            this.updateButtons();
            this.update(csmClass);
        }
    }

    private void supertypeButtonActionPerformed(ActionEvent actionEvent) {
        if (this.subDirection != this.supertypeButton.isSelected()) {
            return;
        }
        this.setSubtypeHierarchy(false);
    }

    private void directOnlyButtonActionPerformed(ActionEvent actionEvent) {
        this.setRecursive(!this.directOnlyButton.isSelected());
    }

    private void treeButtonActionPerformed(ActionEvent actionEvent) {
        this.setPlain(!this.treeButton.isSelected());
    }

    private void setRecursive(boolean bl) {
        CsmClass csmClass;
        if (this.object != null && (csmClass = (CsmClass)this.object.getObject()) != null) {
            this.recursive = bl;
            this.updateButtons();
            this.update(csmClass);
        }
    }

    private void setPlain(boolean bl) {
        CsmClass csmClass;
        if (this.object != null && (csmClass = (CsmClass)this.object.getObject()) != null) {
            this.plain = bl;
            this.updateButtons();
            this.update(csmClass);
        }
    }

    public void setClass(CsmClass csmClass) {
        this.object = csmClass.getUID();
        this.subDirection = true;
        this.updateButtons();
        this.update(csmClass);
    }

    private void updateButtons() {
        this.subtypeButton.setSelected(this.subDirection);
        this.supertypeButton.setSelected(!this.subDirection);
        this.directOnlyButton.setSelected(!this.recursive);
        this.treeButton.setSelected(!this.plain);
    }

    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        return this.hierarchyPane.requestFocusInWindow();
    }

    private synchronized void update(final CsmClass csmClass) {
        if (csmClass != null) {
            final Children children = this.root.getChildren();
            if (!Children.MUTEX.isReadAccess()) {
                Children.MUTEX.writeAccess(new Runnable(){

                    public void run() {
                        children.remove(children.getNodes());
                        HierarchyModel hierarchyModel = HierarchyFactory.getInstance().buildTypeHierarchyModel(csmClass, ClassHierarchyPanel.this.actions, ClassHierarchyPanel.this.subDirection, ClassHierarchyPanel.this.plain, ClassHierarchyPanel.this.recursive);
                        hierarchyModel.setCloseWindowAction(ClassHierarchyPanel.this.close);
                        HierarchyNode hierarchyNode = new HierarchyNode(csmClass, hierarchyModel, null);
                        children.add(new Node[]{hierarchyNode});
                        try {
                            ClassHierarchyPanel.this.getExplorerManager().setSelectedNodes(new Node[]{hierarchyNode});
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                        SwingUtilities.invokeLater(new Runnable((Node)hierarchyNode){
                            final /* synthetic */ Node val$node;
                            {
                                this.val$node = node;
                            }

                            public void run() {
                                ((BeanTreeView)ClassHierarchyPanel.this.hierarchyPane).expandNode(this.val$node);
                            }
                        });
                    }
                });
            }
        } else {
            final Children children = this.root.getChildren();
            if (!Children.MUTEX.isReadAccess()) {
                Children.MUTEX.writeAccess(new Runnable(){

                    public void run() {
                        children.remove(children.getNodes());
                    }
                });
            }
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    private ImageIcon getButtonIcon(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = "/org/netbeans/modules/cnd/navigation/classhierarchy/resources/subtypehierarchy.png";
                break;
            }
            case 2: {
                string = "/org/netbeans/modules/cnd/navigation/classhierarchy/resources/supertypehierarchy.png";
                break;
            }
            case 3: {
                string = "/org/netbeans/modules/cnd/navigation/classhierarchy/resources/direct_only.png";
                break;
            }
            case 4: {
                string = "/org/netbeans/modules/cnd/navigation/classhierarchy/resources/tree.png";
            }
        }
        return new ImageIcon(this.getClass().getResource(string));
    }

    private String getButtonTooltip(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = "ClassHierarchyPanel.subtypeButton.toolTipText";
                break;
            }
            case 2: {
                string = "ClassHierarchyPanel.supertypeButton.toolTipText";
                break;
            }
            case 3: {
                string = "ClassHierarchyPanel.directOnlyButton.toolTipText";
                break;
            }
            case 4: {
                string = "ClassHierarchyPanel.treeButton.toolTipText";
            }
        }
        return NbBundle.getMessage(this.getClass(), (String)string);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("TypeView");
    }

    private class MyBeanTreeView
    extends BeanTreeView {
        public void addCloseAction(final Action action) {
            this.tree.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 27 && action != null) {
                        action.actionPerformed(null);
                        keyEvent.consume();
                    }
                    super.keyReleased(keyEvent);
                }
            });
        }
    }

    private class DialogClose
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            for (Container container = ClassHierarchyPanel.this; container != null; container = container.getParent()) {
                if (container instanceof TopComponent) {
                    ((TopComponent)container).close();
                    return;
                }
                if (!(container instanceof Window)) continue;
                ((Window)container).setVisible(false);
                return;
            }
        }
    }

    private class TreeAction
    extends AbstractAction
    implements Presenter.Popup {
        private JCheckBoxMenuItem menuItem;

        public TreeAction() {
            this.putValue("Name", ClassHierarchyPanel.this.getButtonTooltip(4));
            this.putValue("SmallIcon", ClassHierarchyPanel.this.getButtonIcon(4));
            this.menuItem = new JCheckBoxMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ClassHierarchyPanel.this.setPlain(!ClassHierarchyPanel.this.plain);
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(!ClassHierarchyPanel.this.plain);
            return this.menuItem;
        }
    }

    private class DirectOnlyAction
    extends AbstractAction
    implements Presenter.Popup {
        private JCheckBoxMenuItem menuItem;

        public DirectOnlyAction() {
            this.putValue("Name", ClassHierarchyPanel.this.getButtonTooltip(3));
            this.putValue("SmallIcon", ClassHierarchyPanel.this.getButtonIcon(3));
            this.menuItem = new JCheckBoxMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ClassHierarchyPanel.this.setRecursive(!ClassHierarchyPanel.this.recursive);
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(!ClassHierarchyPanel.this.recursive);
            return this.menuItem;
        }
    }

    private class SuperTypeAction
    extends AbstractAction
    implements Presenter.Popup {
        private JRadioButtonMenuItem menuItem;

        public SuperTypeAction() {
            this.putValue("Name", ClassHierarchyPanel.this.getButtonTooltip(2));
            this.putValue("SmallIcon", ClassHierarchyPanel.this.supertypeButton.getIcon());
            this.menuItem = new JRadioButtonMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ClassHierarchyPanel.this.setSubtypeHierarchy(false);
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(!ClassHierarchyPanel.this.subDirection);
            return this.menuItem;
        }
    }

    private class SubTypeAction
    extends AbstractAction
    implements Presenter.Popup {
        private JRadioButtonMenuItem menuItem;

        public SubTypeAction() {
            this.putValue("Name", ClassHierarchyPanel.this.getButtonTooltip(1));
            this.putValue("SmallIcon", ClassHierarchyPanel.this.subtypeButton.getIcon());
            this.menuItem = new JRadioButtonMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ClassHierarchyPanel.this.setSubtypeHierarchy(true);
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(ClassHierarchyPanel.this.subDirection);
            return this.menuItem;
        }
    }

    private class RefreshAction
    extends AbstractAction
    implements Presenter.Popup {
        private JMenuItem menuItem;

        public RefreshAction() {
            this.putValue("Name", NbBundle.getMessage(ClassHierarchyPanel.class, (String)"ClassHierarchyPanel.refreshButton.toolTipText"));
            this.putValue("SmallIcon", ClassHierarchyPanel.this.refreshButton.getIcon());
            this.menuItem = new JMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ClassHierarchyPanel.this.refreshButtonActionPerformed(actionEvent);
        }

        public final JMenuItem getPopupPresenter() {
            return this.menuItem;
        }
    }
}

