/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp.templates;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.swingapp.templates.ConfigureProjectPanel;
import org.netbeans.spi.java.project.support.ui.SharableLibrariesUtils;
import org.openide.ErrorManager;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.ListView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ConfigureProjectVisualPanel
extends JPanel
implements DocumentListener,
PropertyChangeListener,
ExplorerManager.Provider {
    private ConfigureProjectPanel wizardPanel;
    private ExplorerManager explorerManager;
    private boolean configuring;
    private String currentLibrariesLocation;
    private String projectLocation;
    private JLabel appNameLabel;
    private JTextField appNameTextField;
    private JButton browseButton;
    private JLabel createdFolderLabel;
    private JTextField createdFolderTextField;
    private HtmlBrowser descBrowser;
    private JButton libFolderButton;
    private JCheckBox libFolderCheckBox;
    private JLabel libFolderLabel;
    private JTextField libFolderTextField;
    private JLabel libHintLabel;
    private JCheckBox mainProjectCheckBox;
    private JLabel projectLocationLabel;
    private JTextField projectLocationTextField;
    private JLabel projectNameLabel;
    private JTextField projectNameTextField;
    private JSeparator separator;
    private ListView shellList;
    private JLabel shellListLabel;

    public ConfigureProjectVisualPanel(ConfigureProjectPanel configureProjectPanel) {
        this.wizardPanel = configureProjectPanel;
        this.initComponents();
        this.explorerManager = new ExplorerManager();
        this.explorerManager.setRootContext(this.getTemplatesRootNode());
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
        this.shellList.setPopupAllowed(false);
        this.shellList.setBorder((Border)UIManager.get("Nb.ScrollPane.border"));
        this.projectNameTextField.getDocument().addDocumentListener(this);
        this.projectLocationTextField.getDocument().addDocumentListener(this);
        this.appNameTextField.getDocument().addDocumentListener(this);
        this.libFolderCheckBox.setSelected(SharableLibrariesUtils.isLastProjectSharable());
        this.currentLibrariesLocation = "." + File.separatorChar + "lib";
        this.libFolderTextField.setText(this.currentLibrariesLocation);
        this.libFolderCheckBoxActionPerformed(null);
    }

    void setConfig(File file, String string, String string2) {
        this.configuring = true;
        this.projectLocationTextField.setText(file.getAbsolutePath());
        this.projectNameTextField.setText(string);
        this.projectNameTextField.setSelectionStart(0);
        this.projectNameTextField.setSelectionEnd(string.length());
        if (string2 != null) {
            this.appNameTextField.setText(string2);
        }
        if (this.explorerManager.getSelectedNodes().length == 0) {
            Node[] nodeArray = this.explorerManager.getRootContext().getChildren().getNodes(true);
            try {
                this.explorerManager.setSelectedNodes(new Node[]{nodeArray[0]});
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        this.configuring = false;
        this.wizardPanel.visualPanelChanged(false);
    }

    File getProjectDirectory() {
        return new File(this.createdFolderTextField.getText());
    }

    String getProjectName() {
        return this.projectNameTextField.getText().trim();
    }

    String getApplicationClassName() {
        return this.appNameTextField.getText();
    }

    FileObject getSelectedTemplate() {
        Node[] nodeArray = this.explorerManager.getSelectedNodes();
        if (nodeArray.length == 1) {
            return ConfigureProjectVisualPanel.fileFromNode(nodeArray[0]);
        }
        return null;
    }

    boolean isSetMainProject() {
        return this.mainProjectCheckBox.isSelected();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("selectedNodes")) {
            FileObject fileObject;
            if (!this.configuring) {
                this.wizardPanel.visualPanelChanged(true);
            }
            URL uRL = (fileObject = this.getSelectedTemplate()) != null ? (URL)fileObject.getAttribute("instantiatingWizardURL") : null;
            this.descBrowser.setURL(uRL);
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    private void updateTexts(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.projectNameTextField.getDocument() || documentEvent.getDocument() == this.projectLocationTextField.getDocument()) {
            String string = this.projectNameTextField.getText();
            String string2 = this.projectLocationTextField.getText();
            this.createdFolderTextField.setText(string2 + File.separatorChar + string);
            if (documentEvent.getDocument() == this.projectNameTextField.getDocument()) {
                String string3 = ConfigureProjectVisualPanel.getClassNameFromProject(string);
                String string4 = string3.toLowerCase();
                String string5 = !string4.contains("application") && !string3.endsWith("App") ? string3 + "App" : string3;
                if (Character.isLowerCase(string5.charAt(0))) {
                    string5 = string5.substring(0, 1).toUpperCase() + string5.substring(1);
                }
                this.appNameTextField.setText(string4 + "." + string5);
                return;
            }
        }
        if (!this.configuring) {
            this.wizardPanel.visualPanelChanged(false);
        }
    }

    private static String getClassNameFromProject(String string) {
        if (!Utilities.isJavaIdentifier((String)string)) {
            StringBuilder stringBuilder = new StringBuilder(string.length());
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (stringBuilder.length() == 0) {
                    if (!Character.isJavaIdentifierStart(c)) continue;
                    stringBuilder.append(c);
                    continue;
                }
                if (!Character.isJavaIdentifierPart(c)) continue;
                stringBuilder.append(c);
            }
            return stringBuilder.length() > 0 ? stringBuilder.toString() : "MyApplication";
        }
        return string;
    }

    private Node getTemplatesRootNode() {
        try {
            FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("org-netbeans-modules-swingapp/appshells");
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            return dataObject.getNodeDelegate();
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
            return new AbstractNode((Children)new Children.Array());
        }
    }

    private static FileObject fileFromNode(Node node) {
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        return dataObject != null ? dataObject.getPrimaryFile() : null;
    }

    public boolean isShareable() {
        return this.libFolderCheckBox.isSelected();
    }

    public String getLibFolderPath() {
        return this.libFolderTextField.getText();
    }

    private void initComponents() {
        this.separator = new JSeparator();
        this.descBrowser = new HtmlBrowser();
        this.createdFolderLabel = new JLabel();
        this.appNameTextField = new JTextField();
        this.appNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.projectNameLabel = new JLabel();
        this.mainProjectCheckBox = new JCheckBox();
        this.libHintLabel = new JLabel();
        this.libFolderButton = new JButton();
        this.libFolderTextField = new JTextField();
        this.libFolderLabel = new JLabel();
        this.projectLocationLabel = new JLabel();
        this.libFolderCheckBox = new JCheckBox();
        this.projectLocationTextField = new JTextField();
        this.browseButton = new JButton();
        this.createdFolderTextField = new JTextField();
        this.shellListLabel = new JLabel();
        this.shellList = new TemplatesListView();
        this.setName(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.name"));
        this.descBrowser.setStatusLineVisible(false);
        this.descBrowser.setToolbarVisible(false);
        this.createdFolderLabel.setLabelFor(this.createdFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.createdFolderLabel, (String)NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.createdFolderLabel.text"));
        this.appNameLabel.setLabelFor(this.appNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.appNameLabel, (String)NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.appNameLabel.text"));
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.projectNameLabel.text"));
        this.mainProjectCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.mainProjectCheckBox, (String)NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.mainProjectCheckBox.text"));
        this.mainProjectCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.mainProjectCheckBox.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((JLabel)this.libHintLabel, (String)NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.libHintLabel.text"));
        this.libHintLabel.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.libFolderButton, (String)NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.libFolderButton.text_1"));
        this.libFolderButton.setEnabled(false);
        this.libFolderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigureProjectVisualPanel.this.libFolderButtonActionPerformed(actionEvent);
            }
        });
        this.libFolderTextField.setText(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.libFolderTextField.text"));
        this.libFolderTextField.setEnabled(false);
        Mnemonics.setLocalizedText((JLabel)this.libFolderLabel, (String)NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.libFolderLabel.text"));
        this.libFolderLabel.setEnabled(false);
        this.projectLocationLabel.setLabelFor(this.projectLocationTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLocationLabel, (String)NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.projectLocationLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.libFolderCheckBox, (String)NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.libFolderCheckBox.text"));
        this.libFolderCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.libFolderCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigureProjectVisualPanel.this.libFolderCheckBoxActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.jButton1.text"));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigureProjectVisualPanel.this.browseButtonActionPerformed(actionEvent);
            }
        });
        this.createdFolderTextField.setEditable(false);
        this.shellListLabel.setLabelFor((Component)this.shellList);
        Mnemonics.setLocalizedText((JLabel)this.shellListLabel, (String)NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.shellListLabel.text"));
        this.shellListLabel.setToolTipText(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.shellListLabel.toolTipText"));
        this.shellList.setTraversalAllowed(false);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.shellList, -2, 162, -2).addPreferredGap(0).add((Component)this.descBrowser, -1, 298, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.shellListLabel).add(28, 28, 28)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.projectNameLabel).add((Component)this.projectLocationLabel).add((Component)this.createdFolderLabel).add((Component)this.appNameLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.appNameTextField, -1, 260, Short.MAX_VALUE).add((Component)this.createdFolderTextField, -1, 260, Short.MAX_VALUE).add((Component)this.projectNameTextField, -1, 260, Short.MAX_VALUE).add(2, (Component)this.projectLocationTextField, -1, 260, Short.MAX_VALUE).add((Component)this.libFolderTextField, -1, 260, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.browseButton).add((Component)this.libFolderButton)))).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.libFolderCheckBox).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(19, 19, 19).add((Component)this.libFolderLabel).addPreferredGap(0).add((Component)this.libHintLabel, -1, 256, Short.MAX_VALUE).add(91, 91, 91)).add((Component)this.mainProjectCheckBox)).add(14, 14, 14)))));
        groupLayout.linkSize(new Component[]{this.browseButton, this.libFolderButton}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectNameLabel).add((Component)this.projectNameTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectLocationTextField, -2, -1, -2).add((Component)this.projectLocationLabel).add((Component)this.browseButton)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.createdFolderLabel).add((Component)this.createdFolderTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.appNameLabel).add((Component)this.appNameTextField, -2, -1, -2)).add(18, 18, 18).add((Component)this.shellListLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.descBrowser, 0, 0, Short.MAX_VALUE).add((Component)this.shellList, -1, -1, Short.MAX_VALUE)).add(18, 18, 18).add((Component)this.libFolderCheckBox).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.libFolderLabel).add((Component)this.libFolderTextField, -2, -1, -2).add((Component)this.libFolderButton)).addPreferredGap(0).add((Component)this.libHintLabel).addPreferredGap(0).add((Component)this.mainProjectCheckBox).addContainerGap(21, Short.MAX_VALUE)));
        this.descBrowser.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.descBrowser.accessibleName"));
        this.createdFolderLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.jLabel3.accessibleDescription"));
        this.appNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.jLabel4.accessibleDescription"));
        this.projectNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.jLabel1.accessibleDescription"));
        this.mainProjectCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.mainProjectCheckBox.accessibleDescription"));
        this.libFolderButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.libFolderButton.AccessibleContext.accessibleDescription"));
        this.libFolderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.libFolderTextField.AccessibleContext.accessibleDescription"));
        this.projectLocationLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.jLabel2.accessibleDescription"));
        this.libFolderCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.libFolderCheckBox.AccessibleContext.accessibleDescription"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.jButton1.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"TITLE_NewDesktopApp"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.accessibleDescription"));
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setDialogTitle(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.locationChooserTitle"));
        jFileChooser.setFileSelectionMode(1);
        String string = this.projectLocationTextField.getText();
        if (string.length() > 0 && (file = new File(string)).exists()) {
            jFileChooser.setSelectedFile(file);
        }
        if (0 == jFileChooser.showOpenDialog(this)) {
            file = jFileChooser.getSelectedFile();
            this.projectLocationTextField.setText(FileUtil.normalizeFile((File)file).getAbsolutePath());
        }
        this.wizardPanel.visualPanelChanged(false);
    }

    private void libFolderCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.libFolderButton.setEnabled(this.libFolderCheckBox.isSelected());
        this.libFolderLabel.setEnabled(this.libFolderCheckBox.isSelected());
        this.libFolderTextField.setEnabled(this.libFolderCheckBox.isSelected());
        this.libHintLabel.setEnabled(this.libFolderCheckBox.isSelected());
        if (this.libFolderCheckBox.isSelected()) {
            this.libFolderTextField.setText(this.currentLibrariesLocation);
        } else {
            this.libFolderTextField.setText("");
        }
    }

    private void libFolderButtonActionPerformed(ActionEvent actionEvent) {
        File file = FileUtil.normalizeFile((File)new File(this.projectLocation + File.separatorChar + "project_folder"));
        String string = SharableLibrariesUtils.browseForLibraryLocation((String)this.libFolderTextField.getText().trim(), (Component)this, (File)file);
        if (string != null) {
            this.currentLibrariesLocation = string;
            if (this.libFolderCheckBox.isSelected()) {
                this.libFolderTextField.setText(this.currentLibrariesLocation);
            }
        }
    }

    private static class TemplatesListView
    extends ListView
    implements ActionListener {
        public TemplatesListView() {
            this.list.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0, false));
            this.setDefaultProcessor(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }
}

