/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.remoting.impl;

import java.io.IOException;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shale.remoting.impl.FilteringProcessor;

public class MethodBindingProcessor
extends FilteringProcessor {
    private transient Log log = null;

    public void setExcludes(String excludes) {
        if (excludes != null && excludes.length() > 0) {
            super.setExcludes("/application/*,/applicationScope/*,/facesContext/*,/request/*,/requestScope/*,/response/*,/session/*,/sessionScope/*,/view/*," + excludes);
        } else {
            super.setExcludes("/application/*,/applicationScope/*,/facesContext/*,/request/*,/requestScope/*,/response/*,/session/*,/sessionScope/*,/view/*");
        }
    }

    public void process(FacesContext context, String resourceId) throws IOException {
        if (context.getResponseComplete()) {
            return;
        }
        if (!this.accept(resourceId)) {
            if (this.log().isTraceEnabled()) {
                this.log().trace((Object)("Resource id '" + resourceId + "' rejected by include/exclude rules"));
            }
            this.sendNotFound(context, resourceId);
            context.responseComplete();
            return;
        }
        MethodBinding mb = this.mapResourceId(context, resourceId);
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("Translated resource id '" + resourceId + "' to method binding expression '" + mb.getExpressionString() + "'"));
        }
        mb.invoke(context, new Object[0]);
        context.responseComplete();
    }

    protected MethodBinding mapResourceId(FacesContext context, String resourceId) {
        if (resourceId.startsWith("/")) {
            resourceId = resourceId.substring(1);
        }
        resourceId = resourceId.replace('/', '.');
        resourceId = "#{" + resourceId + "}";
        return context.getApplication().createMethodBinding(resourceId, new Class[0]);
    }

    private Log log() {
        if (this.log == null) {
            this.log = LogFactory.getLog((Class)MethodBindingProcessor.class);
        }
        return this.log;
    }

    private void sendNotFound(FacesContext context, String resourceId) throws IOException {
        if (!this.servletRequest(context)) {
            throw new IllegalArgumentException(resourceId);
        }
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        response.sendError(404, resourceId);
    }

    private boolean servletRequest(FacesContext context) {
        return context.getExternalContext().getContext() instanceof ServletContext;
    }
}

