/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.remoting.impl;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import org.apache.shale.remoting.Processor;

public abstract class FilteringProcessor
implements Processor {
    private String excludes = null;
    private String[] excludesPatterns = new String[0];
    private String includes = null;
    private String[] includesPatterns = new String[0];

    public String getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
        this.excludesPatterns = this.precompile(excludes);
    }

    public String getIncludes() {
        return this.includes;
    }

    public void setIncludes(String includes) {
        this.includes = includes;
        this.includesPatterns = this.precompile(includes);
    }

    protected boolean accept(String resourceId) {
        if (this.matches(resourceId, this.excludesPatterns, false)) {
            return false;
        }
        if (this.matches(resourceId, this.includesPatterns, true)) {
            return true;
        }
        return this.includesPatterns == null || this.includesPatterns.length <= 0;
    }

    private boolean matches(String expr, String[] patterns, boolean unrestricted) {
        if (patterns == null || patterns.length == 0) {
            return unrestricted;
        }
        for (int i = 0; i < patterns.length; ++i) {
            if (!(patterns[i].startsWith("*") ? expr.endsWith(patterns[i].substring(1)) : (patterns[i].endsWith("*") ? expr.startsWith(patterns[i].substring(0, patterns[i].length() - 1)) : patterns[i].equals(expr)))) continue;
            return true;
        }
        return false;
    }

    private String[] precompile(String expr) {
        if (expr == null) {
            return new String[0];
        }
        String pattern = null;
        StreamTokenizer st = new StreamTokenizer(new StringReader(expr));
        st.eolIsSignificant(false);
        st.lowerCaseMode(false);
        st.slashSlashComments(false);
        st.slashStarComments(false);
        st.wordChars(0, 255);
        st.quoteChar(39);
        st.quoteChar(34);
        st.whitespaceChars(0, 32);
        st.whitespaceChars(44, 44);
        ArrayList<String> list = new ArrayList<String>();
        int type = 0;
        while (true) {
            try {
                type = st.nextToken();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (type == -1) break;
            if (type == -2) {
                pattern = "" + st.nval;
            } else if (type == -3) {
                pattern = st.sval.trim();
            } else {
                throw new IllegalArgumentException(expr);
            }
            if (pattern.length() < 1) {
                throw new IllegalArgumentException(pattern);
            }
            if (pattern.startsWith("/")) {
                if (!pattern.endsWith("/*")) {
                    throw new IllegalArgumentException(pattern);
                }
            } else if (pattern.startsWith("*.")) {
                if (pattern.substring(2).indexOf(46) > 0) {
                    throw new IllegalArgumentException(pattern);
                }
            } else {
                throw new IllegalArgumentException(pattern);
            }
            list.add(pattern);
        }
        return list.toArray(new String[list.size()]);
    }
}

