/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.componentssupport.ui.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.CustomComponentWizardPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

class CustomComponentVisualPanel
extends JPanel
implements DocumentListener {
    public static final String PROP_PROJECT_NAME = "projectName";
    public static final String BROWSE = "BROWSE";
    public static final String LBL_SELECT_LOCATION_DLG = "LBL_SelectProjectLocation";
    public static final String MSG_NAME_CANNOT_BE_EMPTY = "MSG_NameCannotBeEmpty";
    public static final String MSG_LOCATION_CANNOT_BE_EMPTY = "MSG_LocationCannotBeEmpty";
    public static final String MSG_LOCATION_MUST_EXIST = "MSG_LocationMustExist";
    public static final String MSG_IS_NOT_DIRECTORY = "MSG_IsNotAFolder";
    public static final String MSG_CANT_CREATE_FOLDER = "MSG_CanNotCreateFolder";
    public static final String MSG_ILLEGAL_FOLDER_PATH = "MSG_IllegalFolderPath";
    public static final String MSG_FOLDER_EXISTS = "MSG_ProjectFolderExists";
    public static final String TXT_DEFAULT_PROJECT_NAME = "TXT_DefaultProjectName";
    public static final String ACSN_PROJECT_PANEL = "ACSN_ProjectPanel";
    public static final String ACSD_PROJECT_PANEL = "ACSD_ProjectPanel";
    private JButton browseButton;
    private JLabel createdFolderLabel;
    private JTextField createdFolderTextField;
    private JCheckBox mainProject;
    private JLabel projectLocationLabel;
    private JTextField projectLocationTextField;
    private JLabel projectNameLabel;
    private JTextField projectNameTextField;
    private WizardDescriptor mySettings;
    private CustomComponentWizardPanel myPanel;

    public CustomComponentVisualPanel(CustomComponentWizardPanel customComponentWizardPanel) {
        this.initComponents();
        this.myPanel = customComponentWizardPanel;
        this.putClientProperty("NewProjectWizard_Title", NbBundle.getMessage(CustomComponentVisualPanel.class, (String)"TXT_MobileDesigner"));
        this.projectNameTextField.getDocument().addDocumentListener(this);
        this.projectLocationTextField.getDocument().addDocumentListener(this);
        this.initAccessibility();
    }

    public void addNotify() {
        super.addNotify();
        this.projectNameTextField.requestFocus();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
        this.checkValidity();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    void store(WizardDescriptor wizardDescriptor) {
        String string = this.projectNameTextField.getText().trim();
        String string2 = this.createdFolderTextField.getText().trim();
        Boolean bl = this.mainProject.isSelected();
        wizardDescriptor.putProperty("projDir", (Object)new File(string2));
        wizardDescriptor.putProperty("projName", (Object)string);
        wizardDescriptor.putProperty("setAsMain", (Object)bl);
    }

    void read(WizardDescriptor wizardDescriptor) {
        this.mySettings = wizardDescriptor;
        if (this.getIsMainProject() != null) {
            this.mainProject.setSelected(this.getIsMainProject());
        }
        this.projectLocationTextField.setText(this.getProjectLocation().getAbsolutePath());
        this.projectNameTextField.setText(this.getProjectName());
        this.projectNameTextField.selectAll();
    }

    protected HelpCtx getHelp() {
        return new HelpCtx(CustomComponentVisualPanel.class);
    }

    private boolean isProjectNameValid() {
        if (this.getProjectNameValue().trim().length() == 0) {
            this.setError(CustomComponentVisualPanel.getMessage(MSG_NAME_CANNOT_BE_EMPTY, new Object[0]));
            return false;
        }
        return true;
    }

    private boolean isProjectLocationValid() {
        String string = this.getProjectLocationValue().trim();
        File file = FileUtil.normalizeFile((File)new File(string).getAbsoluteFile());
        if (string.length() == 0) {
            this.setError(CustomComponentVisualPanel.getMessage(MSG_LOCATION_CANNOT_BE_EMPTY, new Object[0]));
            return false;
        }
        if (!file.exists()) {
            this.setError(CustomComponentVisualPanel.getMessage(MSG_LOCATION_MUST_EXIST, new Object[0]));
            return false;
        }
        if (!file.isDirectory()) {
            this.setError(CustomComponentVisualPanel.getMessage(MSG_IS_NOT_DIRECTORY, new Object[0]));
            return false;
        }
        return true;
    }

    private boolean isCreatedFolderValid() {
        File file;
        File file2;
        String string = this.getCreatedFolderValue();
        for (file2 = file = FileUtil.normalizeFile((File)new File(string).getAbsoluteFile()); file2 != null && !file2.exists(); file2 = file2.getParentFile()) {
        }
        if (file2 == null || !file2.canWrite()) {
            this.setError(CustomComponentVisualPanel.getMessage(MSG_CANT_CREATE_FOLDER, new Object[0]));
            return false;
        }
        if (FileUtil.toFileObject((File)file2) == null) {
            this.setError(CustomComponentVisualPanel.getMessage(MSG_ILLEGAL_FOLDER_PATH, new Object[0]));
            return false;
        }
        File[] fileArray = file.listFiles();
        if (file.exists() && fileArray != null && fileArray.length > 0) {
            this.setError(CustomComponentVisualPanel.getMessage(MSG_FOLDER_EXISTS, new Object[0]));
            return false;
        }
        return true;
    }

    boolean checkValidity() {
        if (!this.isProjectNameValid()) {
            return false;
        }
        if (!this.isProjectLocationValid()) {
            return false;
        }
        if (!this.isCreatedFolderValid()) {
            return false;
        }
        this.markValid();
        return true;
    }

    private String getProjectNameValue() {
        return this.projectNameTextField.getText();
    }

    private String getProjectLocationValue() {
        return this.projectLocationTextField.getText();
    }

    private String getCreatedFolderValue() {
        return this.createdFolderTextField.getText();
    }

    private static String getMessage(String string, Object ... objectArray) {
        return NbBundle.getMessage(CustomComponentVisualPanel.class, (String)string, (Object[])objectArray);
    }

    protected final void setError(String string) {
        assert (string != null);
        this.setMessage(string);
        this.setValid(false);
    }

    private final void setValid(boolean bl) {
        this.myPanel.setValid(bl);
    }

    private final void setMessage(String string) {
        this.mySettings.putProperty("WizardPanel_errorMessage", (Object)string);
    }

    protected final void markValid() {
        this.setMessage(null);
        this.setValid(true);
    }

    File getProjectLocation() {
        File file = (File)this.mySettings.getProperty("projDir");
        file = file == null || file.getParentFile() == null || !file.getParentFile().isDirectory() ? ProjectChooser.getProjectsFolder() : file.getParentFile();
        return file;
    }

    String getProjectName() {
        String string = (String)this.mySettings.getProperty("projName");
        if (string == null) {
            string = this.getDefaultFreeName(this.getProjectLocation());
        }
        return string;
    }

    Boolean getIsMainProject() {
        Boolean bl = (Boolean)this.mySettings.getProperty("setAsMain");
        return bl;
    }

    void validate(WizardDescriptor wizardDescriptor) throws WizardValidationException {
    }

    private void initComponents() {
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.projectLocationLabel = new JLabel();
        this.projectLocationTextField = new JTextField();
        this.browseButton = new JButton();
        this.createdFolderLabel = new JLabel();
        this.createdFolderTextField = new JTextField();
        this.mainProject = new JCheckBox();
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(CustomComponentVisualPanel.class, (String)"LBL_ProjectName"));
        this.projectLocationLabel.setLabelFor(this.projectLocationTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLocationLabel, (String)NbBundle.getMessage(CustomComponentVisualPanel.class, (String)"LBL_ProjectLocation"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(CustomComponentVisualPanel.class, (String)"LBL_Browse_Button"));
        this.browseButton.setActionCommand(BROWSE);
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomComponentVisualPanel.this.browseButtonActionPerformed(actionEvent);
            }
        });
        this.createdFolderLabel.setLabelFor(this.createdFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.createdFolderLabel, (String)NbBundle.getMessage(CustomComponentVisualPanel.class, (String)"LBL_ProjectFolder"));
        this.createdFolderTextField.setEditable(false);
        this.mainProject.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.mainProject, (String)NbBundle.getMessage(CustomComponentVisualPanel.class, (String)"LBL_SetAsMainProject"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.mainProject, -1, 541, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.projectLocationLabel).add((Component)this.createdFolderLabel).add((Component)this.projectNameLabel)).add(19, 19, 19).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.projectNameTextField, -1, 441, Short.MAX_VALUE).add(2, (Component)this.projectLocationTextField, -1, 441, Short.MAX_VALUE).add(2, (Component)this.createdFolderTextField, -1, 441, Short.MAX_VALUE)))).add(18, 18, 18).add((Component)this.browseButton).add(0, 0, 0)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectNameLabel).add((Component)this.projectNameTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectLocationTextField, -2, -1, -2).add((Component)this.projectLocationLabel).add((Component)this.browseButton)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.createdFolderTextField, -2, -1, -2).add((Component)this.createdFolderLabel)).add(18, 18, 18).add((Component)this.mainProject).addContainerGap(183, Short.MAX_VALUE)));
        this.projectNameLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomComponentVisualPanel.class, (String)"ACSN_ProjectName"));
        this.projectNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomComponentVisualPanel.class, (String)"ACSD_ProjectName"));
        this.projectLocationLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomComponentVisualPanel.class, (String)"ACSN_ProjectLocation"));
        this.projectLocationLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomComponentVisualPanel.class, (String)"ACSD_ProjectLocation"));
        this.browseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomComponentVisualPanel.class, (String)"ACSN_Browse_Button"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomComponentVisualPanel.class, (String)"ACSN_Browse_Button"));
        this.createdFolderLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomComponentVisualPanel.class, (String)"ACSN_ProjectFolder"));
        this.createdFolderLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomComponentVisualPanel.class, (String)"ACSD_ProjectFolder"));
        this.mainProject.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomComponentVisualPanel.class, (String)"ACSN_SetAsMainProject"));
        this.mainProject.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomComponentVisualPanel.class, (String)"ACSD_SetAsMainProject"));
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (BROWSE.equals(string)) {
            File file;
            JFileChooser jFileChooser = new JFileChooser();
            FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
            jFileChooser.setDialogTitle(LBL_SELECT_LOCATION_DLG);
            jFileChooser.setFileSelectionMode(1);
            String string2 = this.projectLocationTextField.getText();
            if (string2.length() > 0 && (file = new File(string2)).exists()) {
                jFileChooser.setSelectedFile(file);
            }
            if (0 == jFileChooser.showOpenDialog(this)) {
                file = jFileChooser.getSelectedFile();
                this.projectLocationTextField.setText(FileUtil.normalizeFile((File)file).getAbsolutePath());
            }
        }
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomComponentVisualPanel.class, (String)ACSN_PROJECT_PANEL));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomComponentVisualPanel.class, (String)ACSD_PROJECT_PANEL));
    }

    private String getDefaultFreeName(File file) {
        String string;
        int n = 1;
        while ((string = this.validFreeProjectName(file, n++)) == null) {
        }
        return string;
    }

    private String validFreeProjectName(File file, int n) {
        String string = NbBundle.getMessage(CustomComponentVisualPanel.class, (String)TXT_DEFAULT_PROJECT_NAME, (Object[])new Object[]{n});
        File file2 = new File(file, string);
        if (file2.exists()) {
            return null;
        }
        return string;
    }

    private void updateTexts(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        if (document == this.projectNameTextField.getDocument() || document == this.projectLocationTextField.getDocument()) {
            String string = this.projectNameTextField.getText();
            String string2 = this.projectLocationTextField.getText();
            this.createdFolderTextField.setText(string2 + File.separatorChar + string);
        }
    }
}

