/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.util;

import com.sun.rave.web.ui.util.MessageUtil;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadException;

public class UploadFilter
implements Filter {
    public static final String MAX_SIZE = "maxSize";
    public static final String SIZE_THRESHOLD = "sizeThreshold";
    public static final String TMP_DIR = "tmpDir";
    private long maxSize = 1000000L;
    private int sizeThreshold = 4096;
    private String tmpDir = System.getProperty("java.io.tmpdir");
    private String messages = "com.sun.rave.web.ui.resources.LogMessages";
    private String filterName;
    private static final boolean DEBUG = false;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        if (FileUpload.isMultipartContent((HttpServletRequest)req)) {
            DiskFileUpload fu = new DiskFileUpload();
            fu.setSizeMax(this.maxSize);
            fu.setSizeThreshold(this.sizeThreshold);
            fu.setRepositoryPath(this.tmpDir);
            if (request.getCharacterEncoding() != null) {
                fu.setHeaderEncoding(request.getCharacterEncoding());
            } else {
                fu.setHeaderEncoding("UTF-8");
            }
            List fileItems = null;
            try {
                fileItems = fu.parseRequest(req);
            }
            catch (FileUploadException fue) {
                request.setAttribute("upload_error_key", (Object)fue);
                request.setAttribute("file_size_key", (Object)String.valueOf(this.maxSize));
            }
            Hashtable parameters = null;
            parameters = fileItems != null ? this.parseRequest(fileItems, req) : new Hashtable();
            UploadRequest wrappedRequest = new UploadRequest(req, parameters);
            chain.doFilter((ServletRequest)wrappedRequest, response);
            Enumeration e = request.getAttributeNames();
            while (e.hasMoreElements()) {
                Object o = request.getAttribute(e.nextElement().toString());
                if (!(o instanceof FileItem)) continue;
                ((FileItem)o).delete();
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    private Hashtable parseRequest(List fileItems, HttpServletRequest request) {
        Iterator<Object> iterator = fileItems.iterator();
        String fieldID = null;
        FileItem fileItem = null;
        TreeMap<String, FileItem> fileItemsMap = new TreeMap<String, FileItem>();
        while (iterator.hasNext()) {
            fileItem = (FileItem)iterator.next();
            fieldID = fileItem.getFieldName();
            if (fieldID.endsWith("_com.sun.rave.web.ui.upload")) {
                request.setAttribute(fieldID, (Object)fileItem);
                continue;
            }
            fileItemsMap.put(fieldID, fileItem);
        }
        ArrayList<String> removes = new ArrayList<String>();
        ArrayList<String> unlabeledUploads = new ArrayList<String>();
        iterator = fileItemsMap.keySet().iterator();
        String param = null;
        while (iterator.hasNext()) {
            fieldID = (String)iterator.next();
            if (!fieldID.endsWith("_com.sun.rave.web.ui.uploadParam")) continue;
            fileItem = (FileItem)fileItemsMap.get(fieldID);
            param = fileItem.getString();
            unlabeledUploads.add(param);
            removes.add(fieldID);
        }
        if (!unlabeledUploads.isEmpty()) {
            iterator = unlabeledUploads.iterator();
            while (iterator.hasNext()) {
                fieldID = iterator.next().toString();
                fileItem = (FileItem)fileItemsMap.get(fieldID);
                request.setAttribute(fieldID.concat("_com.sun.rave.web.ui.upload"), (Object)fileItem);
                removes.add(fieldID);
            }
        }
        if (!removes.isEmpty()) {
            iterator = removes.iterator();
            while (iterator.hasNext()) {
                fileItemsMap.remove(iterator.next());
            }
        }
        Hashtable<Object, String> parameters = new Hashtable<Object, String>();
        iterator = fileItemsMap.keySet().iterator();
        Object id = null;
        while (iterator.hasNext()) {
            String aParam;
            id = iterator.next();
            FileItem aFileItem = (FileItem)fileItemsMap.get(id);
            String encoding = this.calculateEncoding(aFileItem, request);
            try {
                aParam = aFileItem.getString(encoding);
            }
            catch (UnsupportedEncodingException e) {
                aParam = aFileItem.getString();
            }
            parameters.put(id, aParam);
        }
        return parameters;
    }

    private String calculateEncoding(FileItem fileItem, HttpServletRequest req) {
        String encoding = req.getCharacterEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return encoding;
    }

    public void init(FilterConfig filterConfig) {
        String error;
        String msg;
        Object[] params;
        this.filterName = filterConfig.getFilterName();
        StringBuffer errorMessageBuffer = new StringBuffer(300);
        String param = filterConfig.getInitParameter(MAX_SIZE);
        if (param != null) {
            try {
                this.maxSize = Long.parseLong(param);
            }
            catch (NumberFormatException nfe) {
                params = new Object[]{MAX_SIZE, param};
                msg = MessageUtil.getMessage(this.messages, "Upload.invalidLong", params);
                errorMessageBuffer.append(msg);
            }
        }
        if ((param = filterConfig.getInitParameter(SIZE_THRESHOLD)) != null) {
            try {
                this.sizeThreshold = Integer.parseInt(param);
            }
            catch (NumberFormatException nfe) {
                params = new Object[]{SIZE_THRESHOLD, param};
                errorMessageBuffer.append(" ");
                msg = MessageUtil.getMessage(this.messages, "Upload.invalidInt", params);
                errorMessageBuffer.append(msg);
            }
        }
        if ((param = filterConfig.getInitParameter(TMP_DIR)) != null) {
            this.tmpDir = param;
            File dir = new File(this.tmpDir);
            if (!dir.canWrite()) {
                params = new Object[]{TMP_DIR, param};
                errorMessageBuffer.append(" ");
                msg = MessageUtil.getMessage(this.messages, "Upload.invalidDir", params);
                errorMessageBuffer.append(msg);
            }
        }
        if ((error = errorMessageBuffer.toString()).length() > 0) {
            throw new RuntimeException(error);
        }
    }

    public String toString() {
        return this.getClass().getName();
    }

    public void destroy() {
    }

    private void log(String s) {
        System.out.println(this.getClass().getName() + "::" + s);
    }

    class UploadRequest
    extends HttpServletRequestWrapper {
        private Hashtable parameters;
        private static final boolean DEBUG = false;

        public UploadRequest(HttpServletRequest request, Hashtable parameters) {
            super(request);
            this.parameters = parameters;
        }

        public String getParameter(String name) {
            Object param = this.parameters.get(name);
            if (param instanceof String) {
                return (String)param;
            }
            if (param instanceof String[]) {
                String[] params = (String[])param;
                return params[0];
            }
            return param == null ? null : param.toString();
        }

        public String[] getParameterValues(String name) {
            Object value = this.parameters.get(name);
            if (value == null) {
                return new String[0];
            }
            if (value instanceof String[]) {
                return (String[])this.parameters.get(name);
            }
            return new String[]{value.toString()};
        }

        public Enumeration getParameterNames() {
            return this.parameters.keys();
        }

        public Map getParameterMap() {
            return this.parameters;
        }
    }
}

