/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.renderer;

import com.sun.rave.web.ui.component.Breadcrumbs;
import com.sun.rave.web.ui.component.Hyperlink;
import com.sun.rave.web.ui.renderer.AbstractRenderer;
import com.sun.rave.web.ui.theme.Theme;
import com.sun.rave.web.ui.util.ConversionUtilities;
import com.sun.rave.web.ui.util.RenderingUtilities;
import com.sun.rave.web.ui.util.ThemeUtilities;
import java.beans.Beans;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class BreadcrumbsRenderer
extends AbstractRenderer {
    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void renderContainingTable(FacesContext context, Breadcrumbs breadcrumbs, Theme theme, ResponseWriter writer) throws IOException {
        writer.startElement("div", (UIComponent)breadcrumbs);
        String tdStyle = theme.getStyleClass("BcmWhtDiv");
        this.addCoreAttributes(context, (UIComponent)breadcrumbs, writer, tdStyle);
        writer.writeText((Object)"\n", null);
    }

    protected void renderBreadcrumbsSeparator(FacesContext context, Breadcrumbs breadcrumbs, Theme theme, ResponseWriter writer) throws IOException {
        writer.startElement("span", (UIComponent)breadcrumbs);
        String separatorStyle = theme.getStyleClass("BcmSep");
        writer.writeAttribute("class", (Object)separatorStyle, null);
        writer.write("&gt;");
        writer.endElement("span");
    }

    protected void renderBreadcrumbsLink(FacesContext context, Hyperlink link, Theme theme) throws IOException {
        String linkStyle = theme.getStyleClass("BcmLnk");
        Map attributes = link.getAttributes();
        if (attributes != null && attributes.get("styleClass") == null) {
            attributes.put("styleClass", linkStyle);
        }
        RenderingUtilities.renderComponent((UIComponent)link, context);
    }

    protected void renderBreadcrumbsText(FacesContext context, Hyperlink crumb, Theme theme, ResponseWriter writer) throws IOException {
        String pageName = ConversionUtilities.convertValueToString((UIComponent)crumb, crumb.getText());
        if (pageName == null || pageName.length() <= 0) {
            return;
        }
        writer.startElement("span", (UIComponent)crumb);
        String textStyle = theme.getStyleClass("BcmTxt");
        writer.writeAttribute("class", (Object)textStyle, null);
        writer.writeText((Object)pageName, null);
        writer.endElement("span");
        writer.endElement("div");
    }

    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        if (context == null || component == null || writer == null) {
            throw new NullPointerException();
        }
        Breadcrumbs breadcrumbs = (Breadcrumbs)component;
        if (!breadcrumbs.isRendered()) {
            return;
        }
        Hyperlink[] pages = null;
        if (breadcrumbs.getPages() != null) {
            pages = breadcrumbs.getPages();
            for (int i = 0; i < pages.length; ++i) {
                pages[i].setParent(component);
            }
        } else if (breadcrumbs.getChildren() != null) {
            List list = breadcrumbs.getChildren();
            pages = list.toArray(new UIComponent[list.size()]);
        }
        if (pages == null || pages.length <= 1 && !Beans.isDesignTime()) {
            return;
        }
        Theme theme = ThemeUtilities.getTheme(context);
        this.renderContainingTable(context, breadcrumbs, theme, writer);
        int length = pages.length;
        for (int i = 0; i < length; ++i) {
            Hyperlink crumb = pages[i];
            if (i < length - 1) {
                this.renderBreadcrumbsLink(context, crumb, theme);
                this.renderBreadcrumbsSeparator(context, breadcrumbs, theme, writer);
                continue;
            }
            this.renderBreadcrumbsText(context, crumb, theme, writer);
        }
    }
}

