/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.component;

import com.sun.rave.web.ui.component.Button;
import com.sun.rave.web.ui.component.Label;
import com.sun.rave.web.ui.component.ListManager;
import com.sun.rave.web.ui.component.OrderableListBase;
import com.sun.rave.web.ui.component.StaticText;
import com.sun.rave.web.ui.model.list.ListItem;
import com.sun.rave.web.ui.theme.Theme;
import com.sun.rave.web.ui.util.ConversionUtilities;
import com.sun.rave.web.ui.util.ThemeUtilities;
import com.sun.rave.web.ui.util.ValueType;
import com.sun.rave.web.ui.util.ValueTypeEvaluator;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;

public class OrderableList
extends OrderableListBase
implements ListManager {
    public static final String MOVEUP_BUTTON_ID = "_moveUpButton";
    public static final String MOVEUP_BUTTON_FACET = "moveUpButton";
    public static final String MOVEDOWN_BUTTON_ID = "_moveDownButton";
    public static final String MOVEDOWN_BUTTON_FACET = "moveDownButton";
    public static final String MOVETOP_BUTTON_ID = "_moveTopButton";
    public static final String MOVETOP_BUTTON_FACET = "moveTopButton";
    public static final String MOVEBOTTOM_BUTTON_ID = "_moveBottomButton";
    public static final String MOVEBOTTOM_BUTTON_FACET = "moveBottomButton";
    public static final String REMOVE_BUTTON_ID = "_removeButton";
    public static final String REMOVE_BUTTON_FACET = "removeButton";
    public static final String LABEL_ID = "_label";
    public static final String LABEL_FACET = "label";
    public static final String READ_ONLY_ID = "_readOnly";
    public static final String READ_ONLY_FACET = "readOnly";
    public static final String FOOTER_FACET = "footer";
    public static final String JSOBJECT = "com.sun.rave.web.ui.OrderableListJS";
    public static final String JAVASCRIPT_PREFIX = "javascript: ";
    public static final String RETURN = "return false;";
    public static final String MOVEUP_FUNCTION = ".moveUp(); ";
    public static final String MOVEDOWN_FUNCTION = ".moveDown();";
    public static final String MOVETOP_FUNCTION = ".moveTop(); ";
    public static final String MOVEBOTTOM_FUNCTION = ".moveBottom();";
    public static final String UPDATEBUTTONS_FUNCTION = ".updateButtons(); ";
    public static final String ONCHANGE_FUNCTION = ".onChange(); ";
    private static final String READ_ONLY_SEPARATOR = ", ";
    private ValueTypeEvaluator valueTypeEvaluator = new ValueTypeEvaluator((UIComponent)this);
    private ArrayList listItems = null;
    private transient Theme theme = null;
    private static final boolean DEBUG = false;

    public UIComponent getMoveUpButtonComponent(FacesContext context) {
        String id = this.getId();
        Object buttonComponent = this.getFacet(MOVEUP_BUTTON_FACET);
        if (buttonComponent == null) {
            buttonComponent = this.createButton(this.getTheme().getMessage("OrderableList.moveUp"), MOVEUP_BUTTON_ID, MOVEUP_BUTTON_FACET);
            StringBuffer jsBuffer = new StringBuffer(200);
            jsBuffer.append(JAVASCRIPT_PREFIX);
            jsBuffer.append(this.getAttributes().get(JSOBJECT));
            jsBuffer.append(MOVEUP_FUNCTION);
            jsBuffer.append(RETURN);
            ((Button)buttonComponent).setOnClick(jsBuffer.toString());
        }
        if (buttonComponent != null && this.isDisabled()) {
            buttonComponent.getAttributes().put("disabled", Boolean.TRUE);
        }
        return buttonComponent;
    }

    public UIComponent getMoveDownButtonComponent(FacesContext context) {
        String id = this.getId();
        Object buttonComponent = this.getFacet(MOVEDOWN_BUTTON_FACET);
        if (buttonComponent == null) {
            buttonComponent = this.createButton(this.getTheme().getMessage("OrderableList.moveDown"), MOVEDOWN_BUTTON_ID, MOVEDOWN_BUTTON_FACET);
            StringBuffer jsBuffer = new StringBuffer(200);
            jsBuffer.append(JAVASCRIPT_PREFIX);
            jsBuffer.append(this.getAttributes().get(JSOBJECT));
            jsBuffer.append(MOVEDOWN_FUNCTION);
            jsBuffer.append(RETURN);
            ((Button)buttonComponent).setOnClick(jsBuffer.toString());
        }
        if (buttonComponent != null && this.isDisabled()) {
            buttonComponent.getAttributes().put("disabled", Boolean.TRUE);
        }
        return buttonComponent;
    }

    public UIComponent getMoveTopButtonComponent(FacesContext context) {
        String id = this.getId();
        Object buttonComponent = this.getFacet(MOVETOP_BUTTON_FACET);
        if (buttonComponent == null) {
            buttonComponent = this.createButton(this.getTheme().getMessage("OrderableList.moveTop"), MOVETOP_BUTTON_ID, MOVETOP_BUTTON_FACET);
            StringBuffer jsBuffer = new StringBuffer(200);
            jsBuffer.append(JAVASCRIPT_PREFIX);
            jsBuffer.append(this.getAttributes().get(JSOBJECT));
            jsBuffer.append(MOVETOP_FUNCTION);
            jsBuffer.append(RETURN);
            ((Button)buttonComponent).setOnClick(jsBuffer.toString());
        }
        if (buttonComponent != null && this.isDisabled()) {
            buttonComponent.getAttributes().put("disabled", Boolean.TRUE);
        }
        return buttonComponent;
    }

    public UIComponent getMoveBottomButtonComponent(FacesContext context) {
        String id = this.getId();
        Object buttonComponent = this.getFacet(MOVEBOTTOM_BUTTON_FACET);
        if (buttonComponent == null) {
            buttonComponent = this.createButton(this.getTheme().getMessage("OrderableList.moveBottom"), MOVEBOTTOM_BUTTON_ID, MOVEBOTTOM_BUTTON_FACET);
            StringBuffer jsBuffer = new StringBuffer(200);
            jsBuffer.append(JAVASCRIPT_PREFIX);
            jsBuffer.append(this.getAttributes().get(JSOBJECT));
            jsBuffer.append(MOVEBOTTOM_FUNCTION);
            jsBuffer.append(RETURN);
            ((Button)buttonComponent).setOnClick(jsBuffer.toString());
        }
        if (buttonComponent != null && this.isDisabled()) {
            buttonComponent.getAttributes().put("disabled", Boolean.TRUE);
        }
        return buttonComponent;
    }

    public UIComponent getHeaderComponent() {
        String id = this.getId();
        Object labelComponent = this.getFacet(LABEL_FACET);
        if (labelComponent == null) {
            String labelString = this.getLabel();
            if (labelString == null || labelString.length() == 0) {
                labelString = this.getTheme().getMessage("OrderableList.defaultListLabel");
            }
            labelComponent = this.createLabel(labelString, LABEL_ID, LABEL_FACET);
            ((Label)((Object)labelComponent)).setLabeledComponent((UIComponent)this);
        }
        return labelComponent;
    }

    public String getPrimaryElementID(FacesContext context) {
        return this.getClientId(context).concat("_list");
    }

    public Iterator getListItems(FacesContext context, boolean ruler) throws FacesException {
        this.listItems = new ArrayList();
        Object submittedValue = this.getSubmittedValue();
        if (submittedValue != null && submittedValue instanceof String[]) {
            ListItem listItem = null;
            String[] values = (String[])submittedValue;
            for (int counter = 0; counter < values.length; ++counter) {
                listItem = new ListItem(values[counter], values[counter]);
                listItem.setValue(values[counter]);
                this.listItems.add(listItem);
            }
            return this.listItems.iterator();
        }
        Object listItemsObject = this.getList();
        if (listItemsObject != null) {
            if (this.valueTypeEvaluator.getValueType() == ValueType.LIST) {
                Iterator items = ((List)listItemsObject).iterator();
                while (items.hasNext()) {
                    Object item = items.next();
                    this.listItems.add(this.createListItem((UIComponent)this, item));
                }
            } else if (this.valueTypeEvaluator.getValueType() == ValueType.ARRAY) {
                Object[] listObjects = (Object[])listItemsObject;
                for (int counter = 0; counter < listObjects.length; ++counter) {
                    this.listItems.add(this.createListItem((UIComponent)this, listObjects[counter]));
                }
            } else {
                String msg = this.getTheme().getMessage("OrderableList.invalidListType");
                throw new FacesException(msg);
            }
        }
        return this.listItems.iterator();
    }

    protected ListItem createListItem(UIComponent comp, Object value) {
        if (value == null) {
            throw new NullPointerException("OrderableList ListItems cannot have null values");
        }
        String label = ConversionUtilities.convertValueToString(comp, value);
        ListItem listItem = new ListItem(value, label);
        listItem.setValue(label);
        return listItem;
    }

    public String[] getValueAsStringArray(FacesContext context) {
        Iterator iterator = this.getListItems(context, false);
        int numItems = this.listItems.size();
        String[] values = new String[numItems];
        for (int counter = 0; counter < numItems; ++counter) {
            values[counter] = ((ListItem)iterator.next()).getValue();
        }
        return values;
    }

    public Object getConvertedValue(FacesContext context, Object submittedValue) throws ConverterException {
        if (!(submittedValue instanceof String[])) {
            throw new ConverterException("Submitted value must be a String array");
        }
        String[] rawValues = (String[])submittedValue;
        if (rawValues.length == 0 && ConversionUtilities.renderedNull((UIComponent)this)) {
            return null;
        }
        Object cValue = null;
        try {
            if (this.valueTypeEvaluator.getValueType() == ValueType.ARRAY) {
                cValue = ConversionUtilities.convertValueToArray((UIComponent)this, rawValues, context);
            } else if (this.valueTypeEvaluator.getValueType() == ValueType.LIST) {
                cValue = ConversionUtilities.convertValueToList((UIComponent)this, rawValues, context);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return cValue;
    }

    protected String getValueAsReadOnly(FacesContext context) throws FacesException {
        StringBuffer valueBuffer = new StringBuffer(200);
        Iterator iterator = this.getListItems(context, false);
        while (iterator.hasNext()) {
            String string = ((ListItem)iterator.next()).getLabel();
            if (string.indexOf("nbsp") > -1) continue;
            valueBuffer.append(string);
            if (!iterator.hasNext()) continue;
            valueBuffer.append(READ_ONLY_SEPARATOR);
        }
        return valueBuffer.toString();
    }

    public UIComponent getReadOnlyValueComponent() {
        String id = this.getId();
        Object textComponent = this.getFacet(READ_ONLY_FACET);
        if (textComponent == null) {
            FacesContext context = FacesContext.getCurrentInstance();
            textComponent = this.createText(this.getValueAsReadOnly(context), READ_ONLY_ID, READ_ONLY_FACET);
        }
        return textComponent;
    }

    private Label createLabel(String labelString, String id, String facetName) {
        if (labelString == null || labelString.length() < 1) {
            labelString = new String();
        }
        Label label = new Label();
        label.setText(labelString);
        label.setLabelLevel(this.getLabelLevel());
        this.getFacets().put(facetName, label);
        label.setId(this.getId().concat(id));
        return label;
    }

    private StaticText createText(String text, String id, String facetName) {
        if (text == null || text.length() < 1) {
            text = new String();
        }
        StaticText field = new StaticText();
        field.setValue(text);
        field.setId(this.getId().concat(id));
        this.getFacets().put(facetName, field);
        return field;
    }

    private Button createButton(String text, String id, String facetName) {
        Button button = new Button();
        button.setId(this.getId().concat(id));
        button.setText(text);
        if (this.getTabIndex() > 0) {
            button.setTabIndex(this.getTabIndex());
        }
        button.setPrimary(true);
        this.getFacets().put(facetName, button);
        return button;
    }

    private void log(String s) {
        System.out.println(this.getClass().getName() + "::" + s);
    }

    private Theme getTheme() {
        return ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
    }

    public int getRows() {
        int rows = super.getRows();
        if (rows < 1) {
            rows = 12;
            super.setRows(12);
        }
        return rows;
    }

    public String getOnChange() {
        return null;
    }

    protected boolean compareValues(Object previous, Object value) {
        if (previous == null || value == null) {
            return super.compareValues(previous, value);
        }
        if (value instanceof Object[]) {
            int length = Array.getLength(value);
            if (Array.getLength(previous) != length) {
                return true;
            }
            for (int i = 0; i < length; ++i) {
                Object newValue = Array.get(value, i);
                Object prevValue = Array.get(previous, i);
                if (newValue == null) {
                    if (prevValue == null) continue;
                    return true;
                }
                if (prevValue == null) {
                    return true;
                }
                if (prevValue.equals(newValue)) continue;
                return true;
            }
            return false;
        }
        return super.compareValues(previous, value);
    }

    public boolean mainListSubmits() {
        return false;
    }
}

