/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component.customizers;

import com.sun.rave.designtime.CheckedDisplayAction;
import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.Result;
import com.sun.rave.designtime.impl.BasicDisplayAction;
import com.sun.webui.jsf.component.CheckboxGroup;
import com.sun.webui.jsf.component.FormDesignInfo;
import com.sun.webui.jsf.component.RadioButtonGroup;
import com.sun.webui.jsf.component.RbCbSelector;
import com.sun.webui.jsf.component.util.DesignMessageUtil;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import java.util.regex.Pattern;

public class AutoSubmitOnChangeAction
extends BasicDisplayAction
implements CheckedDisplayAction {
    private static Pattern submitPattern;
    private static Pattern legacyPattern;
    protected DesignBean bean;

    private static Pattern getSubmitPattern() {
        if (submitPattern == null) {
            submitPattern = Pattern.compile(JavaScriptUtilities.getModuleName((String)"common.timeoutSubmitForm") + "\\s*\\(\\s*this\\s*\\.\\s*form\\s*,\\s*'\\S+'\\s*\\)\\s*;?");
        }
        return submitPattern;
    }

    private static Pattern getLegacyPattern() {
        if (legacyPattern == null) {
            legacyPattern = Pattern.compile("webuijsf\\.\\w+\\.common\\.timeoutSubmitForm\\s*\\(\\s*this\\s*\\.\\s*form\\s*,\\s*'\\S+'\\s*\\)\\s*;?");
        }
        return legacyPattern;
    }

    public AutoSubmitOnChangeAction(DesignBean bean) {
        super(DesignMessageUtil.getMessage(AutoSubmitOnChangeAction.class, "AutoSubmitOnChangeAction.label"));
        this.bean = bean;
    }

    public boolean isChecked() {
        return this.isAutoSubmit();
    }

    public Result invoke() {
        return this.toggleAutoSubmit();
    }

    public boolean isAutoSubmit() {
        DesignProperty property = this.getSubmitProperty();
        if (property == null) {
            return false;
        }
        String value = (String)property.getValue();
        if (value == null) {
            return false;
        }
        boolean valueMatchesSubmitPattern = AutoSubmitOnChangeAction.getSubmitPattern().matcher(value).find();
        if (valueMatchesSubmitPattern) {
            return true;
        }
        return AutoSubmitOnChangeAction.getLegacyPattern().matcher(value).find();
    }

    public Result toggleAutoSubmit() {
        DesignProperty property = this.getSubmitProperty();
        if (property == null) {
            return Result.FAILURE;
        }
        String value = (String)property.getValue();
        if (value == null || value.length() == 0) {
            property.setValue((Object)this.getSubmitScript(null));
        } else if (this.isAutoSubmit()) {
            String newValue = AutoSubmitOnChangeAction.getSubmitPattern().matcher(value).replaceFirst("");
            newValue = AutoSubmitOnChangeAction.getLegacyPattern().matcher(newValue).replaceFirst("");
            property.setValue((Object)newValue);
        } else {
            property.setValue((Object)this.getSubmitScript(value));
        }
        return Result.SUCCESS;
    }

    DesignProperty getSubmitProperty() {
        Object beanInstance = this.bean.getInstance();
        Class<?> beanType = beanInstance.getClass();
        if (RbCbSelector.class.isAssignableFrom(beanType) || beanInstance instanceof RadioButtonGroup || beanInstance instanceof CheckboxGroup) {
            return this.bean.getProperty("onClick");
        }
        return this.bean.getProperty("onChange");
    }

    String getSubmitScript(String previousScript) {
        String id;
        StringBuffer buffer = new StringBuffer();
        if (previousScript != null) {
            buffer.append(previousScript);
            if (!Pattern.compile(";\\s*$").matcher(previousScript).find()) {
                buffer.append(';');
            }
            if (!Pattern.compile("\\s+$").matcher(buffer.toString()).find()) {
                buffer.append(' ');
            }
        }
        if ((id = FormDesignInfo.getFullyQualifiedId(this.bean)) == null) {
            id = this.bean.getInstanceName();
        } else if (id.startsWith(String.valueOf(':')) && id.length() > 1) {
            id = id.substring(1, id.length());
        }
        buffer.append(JavaScriptUtilities.getModuleName((String)"common.timeoutSubmitForm"));
        buffer.append("(this.form, '");
        buffer.append(id);
        buffer.append("');");
        return buffer.toString();
    }
}

