/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.ui.nodes.categorized.customizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.xml.schema.model.Annotation;
import org.netbeans.modules.xml.schema.model.Documentation;
import org.netbeans.modules.xml.schema.model.SchemaComponentReference;
import org.netbeans.modules.xml.schema.ui.nodes.categorized.customizer.AbstractSchemaComponentCustomizer;
import org.netbeans.modules.xml.schema.ui.nodes.categorized.customizer.DocumentationPanel;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationCustomizer
extends AbstractSchemaComponentCustomizer<Annotation>
implements PropertyChangeListener {
    static final long serialVersionUID = 1L;
    private ArrayList<DocumentationPanel> docPanels;
    private JButton addButton;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JPanel panel;

    public AnnotationCustomizer(SchemaComponentReference<Annotation> schemaComponentReference) {
        super(schemaComponentReference);
        this.initComponents();
        this.initialize();
    }

    private void initialize() {
        Annotation annotation = (Annotation)this.getReference().get();
        if (this.docPanels != null) {
            for (int i = this.docPanels.size() - 1; i >= 0; --i) {
                DocumentationPanel documentationPanel = this.docPanels.get(i);
                documentationPanel.removePropertyChangeListener("state", this);
                this.docPanels.remove(documentationPanel);
                this.panel.remove(documentationPanel);
            }
        }
        this.docPanels = new ArrayList();
        Collection collection = annotation.getDocumentationElements();
        int n = 0;
        for (Documentation documentation : collection) {
            DocumentationPanel documentationPanel = new DocumentationPanel(this, documentation, false);
            this.docPanels.add(documentationPanel);
            this.addDocumentationPanel(documentationPanel);
            if (n++ >= 2) continue;
            documentationPanel.setExpanded(true);
        }
    }

    private void addDocumentationPanel(DocumentationPanel documentationPanel) {
        GroupLayout groupLayout = (GroupLayout)this.panel.getLayout();
        GroupLayout.ParallelGroup parallelGroup = (GroupLayout.ParallelGroup)groupLayout.getHorizontalGroup();
        parallelGroup.add((Component)documentationPanel);
        GroupLayout.SequentialGroup sequentialGroup = (GroupLayout.SequentialGroup)groupLayout.getVerticalGroup();
        sequentialGroup.add((Component)documentationPanel);
    }

    protected void applyChanges() throws IOException {
        block5: for (int i = this.docPanels.size() - 1; i >= 0; --i) {
            DocumentationPanel documentationPanel = this.docPanels.get(i);
            switch (documentationPanel.getState()) {
                case REMOVED: {
                    ((Annotation)this.getReference().get()).removeDocumentation(documentationPanel.getDocumentation());
                    this.docPanels.remove(documentationPanel);
                    continue block5;
                }
                case ADDED: {
                    ((Annotation)this.getReference().get()).addDocumentation(documentationPanel.getDocumentation());
                    documentationPanel.getDocumentation().setContentFragment(documentationPanel.getContent());
                    documentationPanel.setState(DocumentationPanel.State.UNMODIFIED);
                    continue block5;
                }
                case MODIFIED: {
                    documentationPanel.getDocumentation().setContentFragment(documentationPanel.getContent());
                    documentationPanel.setState(DocumentationPanel.State.UNMODIFIED);
                }
            }
        }
    }

    public void reset() {
        this.initialize();
        this.repaint();
        this.revalidate();
        this.setSaveEnabled(false);
        this.setResetEnabled(false);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.addButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.panel = new JPanel();
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 100, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 100, Short.MAX_VALUE));
        this.addButton.setText(NbBundle.getMessage(AnnotationCustomizer.class, (String)"LBL_Add"));
        this.addButton.setActionCommand(NbBundle.getMessage(AnnotationCustomizer.class, (String)"LBL_Add"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AnnotationCustomizer.this.addButtonActionPerformed(actionEvent);
            }
        });
        this.jScrollPane1.setBorder(null);
        this.panel.setLayout(null);
        this.panel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        GroupLayout groupLayout2 = new GroupLayout((Container)this.panel);
        this.panel.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setAutocreateGaps(true);
        groupLayout2.setAutocreateContainerGaps(true);
        GroupLayout.ParallelGroup parallelGroup = groupLayout2.createParallelGroup();
        groupLayout2.setHorizontalGroup((GroupLayout.Group)parallelGroup);
        GroupLayout.SequentialGroup sequentialGroup = groupLayout2.createSequentialGroup();
        groupLayout2.setVerticalGroup((GroupLayout.Group)sequentialGroup);
        this.jScrollPane1.setViewportView(this.panel);
        GroupLayout groupLayout3 = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(2).add((Component)this.jScrollPane1, -1, 480, Short.MAX_VALUE).add((Component)this.addButton)).addContainerGap()));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 449, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.addButton).addContainerGap()));
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        Documentation documentation = ((Annotation)this.getReference().get()).getModel().getFactory().createDocumentation();
        DocumentationPanel documentationPanel = new DocumentationPanel(this, documentation, true);
        this.docPanels.add(documentationPanel);
        this.addDocumentationPanel(documentationPanel);
        documentationPanel.setExpanded(true);
        this.revalidate();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("state") && object instanceof DocumentationPanel) {
            DocumentationPanel documentationPanel = (DocumentationPanel)object;
            DocumentationPanel.State state = (DocumentationPanel.State)((Object)propertyChangeEvent.getNewValue());
            boolean bl = false;
            if (state == DocumentationPanel.State.UNMODIFIED) {
                for (DocumentationPanel documentationPanel2 : this.docPanels) {
                    if (documentationPanel2.getState() == DocumentationPanel.State.UNMODIFIED) continue;
                    bl = true;
                    break;
                }
            } else if (state == DocumentationPanel.State.REMOVED) {
                bl = ((Annotation)this.getReference().get()).getDocumentationElements().contains(documentationPanel.getDocumentation());
                if (!bl) {
                    this.docPanels.remove(documentationPanel);
                    for (DocumentationPanel documentationPanel3 : this.docPanels) {
                        if (documentationPanel3.getState() == DocumentationPanel.State.UNMODIFIED) continue;
                        bl = true;
                        break;
                    }
                }
                documentationPanel.removePropertyChangeListener("state", this);
                this.panel.remove(documentationPanel);
                this.repaint();
                this.revalidate();
            } else {
                bl = true;
            }
            this.setSaveEnabled(bl);
            this.setResetEnabled(bl);
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(AnnotationCustomizer.class);
    }
}

