/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.ui.basic.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.xml.schema.model.Derivation;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerivationTypeForm
extends JPanel
implements ActionListener {
    static final long serialVersionUID = 1L;
    private String property = "final";
    private Set<Derivation.Type> currentSelection;
    private Set<Derivation.Type> supportedTypes;
    private boolean isValid = true;
    private JRadioButton allowAllRadioButton;
    private JLabel dummyLabel1;
    private JLabel dummyLabel2;
    private JCheckBox extensionCheckBox;
    private JCheckBox listCheckBox;
    private JRadioButton preventAllRadioButton;
    private JRadioButton preventTypeRadioButton;
    private ButtonGroup radioButtonGroup;
    private JCheckBox restrictionCheckBox;
    private JCheckBox substitutionCheckBox;
    private JCheckBox unionCheckBox;
    private JLabel useDefaultLabel;
    private JRadioButton useDefaultRadioButton;

    public DerivationTypeForm(String string, Set<Derivation.Type> hashSet, Set<Derivation.Type> set) {
        this.currentSelection = hashSet == null ? new HashSet() : hashSet;
        this.property = string;
        this.supportedTypes = set;
        this.initComponents();
        this.initialize();
    }

    private void initComponents() {
        this.radioButtonGroup = new ButtonGroup();
        this.useDefaultRadioButton = new JRadioButton();
        this.useDefaultLabel = new JLabel();
        this.allowAllRadioButton = new JRadioButton();
        this.preventTypeRadioButton = new JRadioButton();
        this.extensionCheckBox = new JCheckBox();
        this.restrictionCheckBox = new JCheckBox();
        this.preventAllRadioButton = new JRadioButton();
        this.listCheckBox = new JCheckBox();
        this.unionCheckBox = new JCheckBox();
        this.substitutionCheckBox = new JCheckBox();
        this.dummyLabel1 = new JLabel();
        this.dummyLabel2 = new JLabel();
        Mnemonics.setLocalizedText((AbstractButton)this.useDefaultRadioButton, (String)NbBundle.getBundle(DerivationTypeForm.class).getString("LBL_Use_Schema_Default_" + this.property));
        this.useDefaultRadioButton.setToolTipText(NbBundle.getBundle(DerivationTypeForm.class).getString("HINT_Use_Schema_Default_" + this.property));
        this.useDefaultRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.useDefaultRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.useDefaultRadioButton.addActionListener(this);
        this.radioButtonGroup.add(this.useDefaultRadioButton);
        Mnemonics.setLocalizedText((JLabel)this.useDefaultLabel, (String)NbBundle.getBundle(DerivationTypeForm.class).getString("LBL_Default_Value_" + this.property));
        this.useDefaultLabel.setToolTipText(NbBundle.getBundle(DerivationTypeForm.class).getString("HINT_Default_Value_" + this.property));
        Mnemonics.setLocalizedText((AbstractButton)this.allowAllRadioButton, (String)NbBundle.getBundle(DerivationTypeForm.class).getString("LBL_Allow_All_" + this.property));
        this.allowAllRadioButton.setToolTipText(NbBundle.getBundle(DerivationTypeForm.class).getString("HINT_Allow_All_" + this.property));
        this.allowAllRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.allowAllRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.allowAllRadioButton.addActionListener(this);
        this.radioButtonGroup.add(this.allowAllRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.preventTypeRadioButton, (String)NbBundle.getBundle(DerivationTypeForm.class).getString("LBL_Prevent_Derivations_" + this.property));
        this.preventTypeRadioButton.setToolTipText(NbBundle.getBundle(DerivationTypeForm.class).getString("HINT_Prevent_Derivations_" + this.property));
        this.preventTypeRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.preventTypeRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.preventTypeRadioButton.addActionListener(this);
        this.radioButtonGroup.add(this.preventTypeRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.extensionCheckBox, (String)NbBundle.getBundle(DerivationTypeForm.class).getString("LBL_Extension"));
        this.extensionCheckBox.setToolTipText(NbBundle.getBundle(DerivationTypeForm.class).getString("HINT_Extension"));
        this.extensionCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.extensionCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.extensionCheckBox.addActionListener(this);
        Mnemonics.setLocalizedText((AbstractButton)this.restrictionCheckBox, (String)NbBundle.getBundle(DerivationTypeForm.class).getString("LBL_Restriction"));
        this.restrictionCheckBox.setToolTipText(NbBundle.getBundle(DerivationTypeForm.class).getString("HINT_Restriction"));
        this.restrictionCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.restrictionCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.restrictionCheckBox.addActionListener(this);
        Mnemonics.setLocalizedText((AbstractButton)this.preventAllRadioButton, (String)NbBundle.getBundle(DerivationTypeForm.class).getString("LBL_Prevent_All_" + this.property));
        this.preventAllRadioButton.setToolTipText(NbBundle.getBundle(DerivationTypeForm.class).getString("HINT_Prevent_All_" + this.property));
        this.preventAllRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.preventAllRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.preventAllRadioButton.addActionListener(this);
        this.radioButtonGroup.add(this.preventAllRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.listCheckBox, (String)NbBundle.getBundle(DerivationTypeForm.class).getString("LBL_List"));
        this.listCheckBox.setToolTipText(NbBundle.getBundle(DerivationTypeForm.class).getString("HINT_List"));
        this.listCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.listCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.listCheckBox.addActionListener(this);
        Mnemonics.setLocalizedText((AbstractButton)this.unionCheckBox, (String)NbBundle.getBundle(DerivationTypeForm.class).getString("LBL_Union"));
        this.unionCheckBox.setToolTipText(NbBundle.getBundle(DerivationTypeForm.class).getString("HINT_Union"));
        this.unionCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.unionCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.unionCheckBox.addActionListener(this);
        Mnemonics.setLocalizedText((AbstractButton)this.substitutionCheckBox, (String)NbBundle.getBundle(DerivationTypeForm.class).getString("LBL_Substitution"));
        this.substitutionCheckBox.setToolTipText(NbBundle.getBundle(DerivationTypeForm.class).getString("HINT_Substitution"));
        this.substitutionCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.substitutionCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.substitutionCheckBox.addActionListener(this);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(17, 17, 17).add((Component)this.useDefaultLabel)).add((Component)this.useDefaultRadioButton).add((Component)this.allowAllRadioButton).add((Component)this.preventAllRadioButton).add((Component)this.preventTypeRadioButton).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(17, 17, 17).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.extensionCheckBox).add((Component)this.restrictionCheckBox).add((Component)this.substitutionCheckBox).add((Component)this.listCheckBox).add((Component)this.unionCheckBox).add((Component)this.dummyLabel2).add((Component)this.dummyLabel1)))).addContainerGap(227, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.useDefaultRadioButton).addPreferredGap(0).add((Component)this.useDefaultLabel).addPreferredGap(0).add((Component)this.allowAllRadioButton).addPreferredGap(0).add((Component)this.preventAllRadioButton).addPreferredGap(0).add((Component)this.preventTypeRadioButton).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.dummyLabel1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.extensionCheckBox).addPreferredGap(0).add((Component)this.restrictionCheckBox).addPreferredGap(0).add((Component)this.substitutionCheckBox).addPreferredGap(0).add((Component)this.dummyLabel2).addPreferredGap(0).add((Component)this.listCheckBox).addPreferredGap(0).add((Component)this.unionCheckBox))).addContainerGap(102, Short.MAX_VALUE)));
    }

    private void initialize() {
        if (!this.supportedTypes.contains(Derivation.Type.EXTENSION)) {
            this.extensionCheckBox.setVisible(false);
        }
        if (!this.supportedTypes.contains(Derivation.Type.RESTRICTION)) {
            this.restrictionCheckBox.setVisible(false);
        }
        if (!this.supportedTypes.contains(Derivation.Type.LIST)) {
            this.listCheckBox.setVisible(false);
        }
        if (!this.supportedTypes.contains(Derivation.Type.UNION)) {
            this.unionCheckBox.setVisible(false);
        }
        if (!this.supportedTypes.contains(Derivation.Type.SUBSTITUTION)) {
            this.substitutionCheckBox.setVisible(false);
        }
        if (this.currentSelection.isEmpty()) {
            this.useDefaultRadioButton.setSelected(true);
        } else if (this.currentSelection.contains(Derivation.Type.EMPTY)) {
            this.allowAllRadioButton.setSelected(true);
        } else if (this.currentSelection.contains(Derivation.Type.ALL)) {
            this.preventAllRadioButton.setSelected(true);
        } else {
            for (Derivation.Type type : this.currentSelection) {
                if (type == Derivation.Type.EXTENSION) {
                    this.extensionCheckBox.setSelected(true);
                    continue;
                }
                if (type == Derivation.Type.RESTRICTION) {
                    this.restrictionCheckBox.setSelected(true);
                    continue;
                }
                if (type == Derivation.Type.LIST) {
                    this.listCheckBox.setSelected(true);
                    continue;
                }
                if (type == Derivation.Type.UNION) {
                    this.unionCheckBox.setSelected(true);
                    continue;
                }
                if (type != Derivation.Type.SUBSTITUTION) continue;
                this.substitutionCheckBox.setSelected(true);
            }
            if (this.checkBoxSelected()) {
                this.preventTypeRadioButton.setSelected(true);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JRadioButton) {
            if (object.equals(this.useDefaultRadioButton)) {
                this.currentSelection.clear();
                this.setCheckBoxesSelected(false);
            } else if (object.equals(this.allowAllRadioButton)) {
                this.currentSelection.clear();
                this.currentSelection.add(Derivation.Type.EMPTY);
                this.setCheckBoxesSelected(false);
            } else if (object.equals(this.preventAllRadioButton)) {
                this.currentSelection.clear();
                this.currentSelection.add(Derivation.Type.ALL);
                this.setCheckBoxesSelected(false);
            } else if (object.equals(this.preventTypeRadioButton) && !this.checkBoxSelected()) {
                this.currentSelection.clear();
            }
        } else if (object instanceof JCheckBox) {
            if (((JCheckBox)object).isSelected() && !this.preventTypeRadioButton.isSelected()) {
                this.preventTypeRadioButton.setSelected(true);
                this.currentSelection.clear();
            }
            if (object.equals(this.extensionCheckBox)) {
                if (this.extensionCheckBox.isSelected()) {
                    this.currentSelection.add(Derivation.Type.EXTENSION);
                } else {
                    this.currentSelection.remove(Derivation.Type.EXTENSION);
                }
            } else if (object.equals(this.restrictionCheckBox)) {
                if (this.restrictionCheckBox.isSelected()) {
                    this.currentSelection.add(Derivation.Type.RESTRICTION);
                } else {
                    this.currentSelection.remove(Derivation.Type.RESTRICTION);
                }
            } else if (object.equals(this.listCheckBox)) {
                if (this.listCheckBox.isSelected()) {
                    this.currentSelection.add(Derivation.Type.LIST);
                } else {
                    this.currentSelection.remove(Derivation.Type.LIST);
                }
            } else if (object.equals(this.unionCheckBox)) {
                if (this.unionCheckBox.isSelected()) {
                    this.currentSelection.add(Derivation.Type.UNION);
                } else {
                    this.currentSelection.remove(Derivation.Type.UNION);
                }
            } else if (object.equals(this.substitutionCheckBox)) {
                if (this.substitutionCheckBox.isSelected()) {
                    this.currentSelection.add(Derivation.Type.SUBSTITUTION);
                } else {
                    this.currentSelection.remove(Derivation.Type.SUBSTITUTION);
                }
            }
        }
        this.firePropertyChange("valid", this.isValid, !this.currentSelection.isEmpty() || !this.preventTypeRadioButton.isSelected());
        this.isValid = !this.currentSelection.isEmpty() || !this.preventTypeRadioButton.isSelected();
    }

    public Set<Derivation.Type> getCurrentSelection() {
        return this.currentSelection;
    }

    private boolean checkBoxSelected() {
        return this.extensionCheckBox.isSelected() || this.restrictionCheckBox.isSelected() || this.listCheckBox.isSelected() || this.unionCheckBox.isSelected() || this.substitutionCheckBox.isSelected();
    }

    private void setCheckBoxesSelected(boolean bl) {
        this.extensionCheckBox.setSelected(bl);
        this.restrictionCheckBox.setSelected(bl);
        this.listCheckBox.setSelected(bl);
        this.unionCheckBox.setSelected(bl);
        this.substitutionCheckBox.setSelected(bl);
    }
}

