/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.websvc.saas.codegen.SaasClientCodeGenerationManager;
import org.netbeans.modules.websvc.saas.codegen.SaasClientCodeGenerator;
import org.netbeans.modules.websvc.saas.codegen.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.model.RestClientSaasBean;
import org.netbeans.modules.websvc.saas.codegen.ui.CodeSetupPanel;
import org.netbeans.modules.websvc.saas.codegen.ui.ProgressDialog;
import org.netbeans.modules.websvc.saas.codegen.util.Util;
import org.netbeans.modules.websvc.saas.model.SaasMethod;
import org.netbeans.modules.websvc.saas.model.WadlSaasMethod;
import org.netbeans.modules.websvc.saas.model.wadl.Method;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.ActiveEditorDrop;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class RestClientEditorDrop
implements ActiveEditorDrop {
    private WadlSaasMethod method;
    private FileObject targetFO;
    private RequestProcessor.Task generatorTask;

    public RestClientEditorDrop(WadlSaasMethod wadlSaasMethod) {
        this.method = wadlSaasMethod;
    }

    public boolean handleTransfer(JTextComponent jTextComponent) {
        if (SaasClientCodeGenerationManager.canAccept((SaasMethod)this.method, jTextComponent.getDocument())) {
            return this.doHandleTransfer(jTextComponent);
        }
        return false;
    }

    private boolean doHandleTransfer(final JTextComponent jTextComponent) {
        final Document document = jTextComponent.getDocument();
        final FileObject fileObject = NbEditorUtilities.getFileObject((Document)document);
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        Method method = this.method.getWadlMethod();
        if (method == null) {
            Exceptions.printStackTrace((Throwable)new IOException("Wadl method not found"));
        }
        final String string = method.getName();
        this.targetFO = RestClientEditorDrop.getTargetFile(document);
        if (this.targetFO == null) {
            return false;
        }
        final ArrayList arrayList = new ArrayList();
        final ProgressDialog progressDialog = new ProgressDialog(NbBundle.getMessage(RestClientEditorDrop.class, (String)"LBL_CodeGenProgress", (Object)string));
        this.generatorTask = RequestProcessor.getDefault().create(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    SaasClientCodeGenerator saasClientCodeGenerator = (SaasClientCodeGenerator)SaasClientCodeGenerationManager.lookup((SaasMethod)RestClientEditorDrop.this.method, document);
                    saasClientCodeGenerator.init((SaasMethod)RestClientEditorDrop.this.method, document);
                    saasClientCodeGenerator.setDropLocation(jTextComponent);
                    RestClientSaasBean restClientSaasBean = (RestClientSaasBean)saasClientCodeGenerator.getBean();
                    List<ParameterInfo> list = restClientSaasBean.filterParametersByAuth(restClientSaasBean.filterParameters(new ParameterInfo.ParamFilter[]{ParameterInfo.ParamFilter.FIXED}));
                    if (!list.isEmpty()) {
                        boolean bl = Util.isJava(document) || Util.isJsp(document);
                        CodeSetupPanel codeSetupPanel = new CodeSetupPanel(list, bl);
                        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)codeSetupPanel, NbBundle.getMessage(RestClientEditorDrop.class, (String)"LBL_CustomizeSaasService", (Object)string));
                        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
                        if (object.equals(NotifyDescriptor.CANCEL_OPTION)) {
                            return;
                        }
                    }
                    try {
                        saasClientCodeGenerator.initProgressReporting(progressDialog.getProgressHandle());
                        saasClientCodeGenerator.generate();
                    }
                    catch (IOException iOException) {
                        if (!iOException.getMessage().equals("ScanningInProgress")) {
                            arrayList.add(iOException);
                        }
                    }
                }
                catch (Exception exception) {
                    if (exception.getMessage().equals("WARN_UnsupportedDropTarget")) {
                        Util.showUnsupportedDropMessage(new Object[]{fileObject.getNameExt(), "Java Client"});
                        return;
                    }
                    arrayList.add(exception);
                }
                finally {
                    progressDialog.close();
                }
            }
        });
        this.generatorTask.schedule(50);
        progressDialog.open();
        if (arrayList.size() > 0) {
            Exceptions.printStackTrace((Throwable)((Throwable)arrayList.get(0)));
            return false;
        }
        return true;
    }

    public static FileObject getTargetFile(Document document) {
        if (document == null) {
            return null;
        }
        DataObject dataObject = NbEditorUtilities.getDataObject((Document)document);
        if (dataObject == null) {
            return null;
        }
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null || editorCookie.getOpenedPanes() == null) {
            return null;
        }
        return dataObject.getPrimaryFile();
    }
}

