/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.csm;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.completion.cplusplus.CsmCompletionProvider;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletionQuery;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmResultItem;
import org.netbeans.modules.cnd.completion.csm.CsmContext;
import org.netbeans.modules.cnd.completion.csm.CsmContextUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetResolver;
import org.netbeans.modules.cnd.completion.csm.CsmProjectContentResolver;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.editor.NbEditorUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompletionUtilities {
    public static List findFunctionLocalVariables(BaseDocument baseDocument, int n) {
        CsmFile csmFile = CsmUtilities.getCsmFile((Document)baseDocument, (boolean)true);
        CsmContext csmContext = CsmOffsetResolver.findContext(csmFile, n);
        return CsmContextUtilities.findFunctionLocalVariables(csmContext);
    }

    public static List findClassFields(BaseDocument baseDocument, int n) {
        CsmClass csmClass = CompletionUtilities.findClassOnPosition(baseDocument, n);
        List list = null;
        if (csmClass != null) {
            list = new CsmProjectContentResolver().getFields(csmClass, false);
        }
        return list;
    }

    public static List findFileVariables(BaseDocument baseDocument, int n) {
        CsmFile csmFile = CsmUtilities.getCsmFile((Document)baseDocument, (boolean)true);
        CsmContext csmContext = CsmOffsetResolver.findContext(csmFile, n);
        return CsmContextUtilities.findFileLocalVariables(csmContext);
    }

    public static List findGlobalVariables(BaseDocument baseDocument, int n) {
        CsmProject csmProject = CsmUtilities.getCsmProject((Document)baseDocument);
        if (csmProject == null) {
            return null;
        }
        return CsmContextUtilities.findGlobalVariables(csmProject);
    }

    public static CsmClass findClassOnPosition(BaseDocument baseDocument, int n) {
        CsmFile csmFile = CsmUtilities.getCsmFile((Document)baseDocument, (boolean)true);
        CsmContext csmContext = CsmOffsetResolver.findContext(csmFile, n);
        CsmClass csmClass = CsmContextUtilities.getClass(csmContext, true);
        return csmClass;
    }

    public static CsmOffsetableDeclaration findFunDefinitionOrClassOnPosition(BaseDocument baseDocument, int n) {
        CsmContext csmContext;
        CsmFunctionDefinition csmFunctionDefinition = null;
        CsmFile csmFile = CsmUtilities.getCsmFile((Document)baseDocument, (boolean)true);
        if (!(csmFile == null || (csmFunctionDefinition = CsmContextUtilities.getFunctionDefinition(csmContext = CsmOffsetResolver.findContext(csmFile, n))) != null && CsmContextUtilities.isInFunctionBodyOrInitializerList(csmContext, n))) {
            csmFunctionDefinition = CsmContextUtilities.getClass(csmContext, false);
        }
        return csmFunctionDefinition;
    }

    public static CsmObject findItemAtCaretPos(JTextComponent jTextComponent, int n) {
        return CompletionUtilities.findItemAtCaretPos(jTextComponent, null, CsmCompletionProvider.getCompletionQuery(), n);
    }

    public static CsmObject findItemAtCaretPos(JTextComponent jTextComponent, Document document, CsmCompletionQuery csmCompletionQuery, int n) {
        try {
            BaseDocument baseDocument = null;
            if (document instanceof BaseDocument) {
                baseDocument = (BaseDocument)document;
            }
            baseDocument = baseDocument != null ? baseDocument : (BaseDocument)jTextComponent.getDocument();
            SyntaxSupport syntaxSupport = baseDocument.getSyntaxSupport();
            int[] nArray = NbEditorUtilities.getIdentifierAndMethodBlock((BaseDocument)baseDocument, (int)n);
            if (nArray == null) {
                nArray = new int[]{n, n};
            }
            boolean bl = nArray.length == 3;
            for (int i = nArray.length - 1; i >= 1; --i) {
                CompletionQuery.Result result;
                int n2;
                CsmObject csmObject;
                CompletionQuery.Result result2 = csmCompletionQuery.query(jTextComponent, baseDocument, nArray[i], syntaxSupport, true, false);
                if (result2 == null || result2.getData().size() <= 0) continue;
                List<CsmObject> list = CompletionUtilities.getAssociatedObjects(result2.getData(), bl);
                CsmObject csmObject2 = csmObject = list.size() > 0 ? list.get(0) : CompletionUtilities.getAssociatedObject(result2.getData().get(0));
                if (list.size() > 1 && bl && (n2 = CompletionUtilities.findEndOfMethod(baseDocument, nArray[i] - 1)) > -1 && (result = csmCompletionQuery.query(jTextComponent, baseDocument, n2, syntaxSupport, true, false)) != null && result.getData().size() > 0) {
                    return CompletionUtilities.getAssociatedObject(result.getData().get(0));
                }
                return csmObject;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    private static List<CsmObject> getAssociatedObjects(List list, boolean bl) {
        ArrayList<CsmObject> arrayList = new ArrayList<CsmObject>();
        ArrayList<CsmObject> arrayList2 = new ArrayList<CsmObject>();
        for (Object e : list) {
            if (!(e instanceof CsmResultItem)) continue;
            CsmObject csmObject = CompletionUtilities.getAssociatedObject(e);
            boolean bl2 = CsmKindUtilities.isFunction((CsmObject)csmObject);
            if (bl2) {
                arrayList2.add(csmObject);
                continue;
            }
            arrayList.add(csmObject);
        }
        if (!bl) {
            arrayList.addAll(arrayList2);
        } else {
            arrayList = arrayList2;
        }
        return arrayList;
    }

    private static CsmObject getAssociatedObject(Object object) {
        CsmObject csmObject;
        if (object instanceof CsmResultItem && (csmObject = (CsmObject)((CsmResultItem)object).getAssociatedObject()) != null) {
            return csmObject;
        }
        return null;
    }

    static int findEndOfMethod(BaseDocument baseDocument, int n) {
        try {
            int n2 = 0;
            for (int i = n; i < baseDocument.getLength(); ++i) {
                char c = baseDocument.getChars(i, 1)[0];
                if (c == ';') {
                    return -1;
                }
                if (c == '(') {
                    ++n2;
                }
                if (c != ')' || --n2 != 0) continue;
                return i + 1;
            }
            return -1;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }
}

