/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus.hyperlink;

import java.awt.Toolkit;
import java.text.MessageFormat;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.cnd.api.lexer.CndTokenUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProvider;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.completion.cplusplus.NbCsmSyntaxSupport;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CsmAbstractHyperlinkProvider
implements HyperlinkProvider {
    private Token<CppTokenId> jumpToken = null;

    protected CsmAbstractHyperlinkProvider() {
        DefaultCaret defaultCaret = new DefaultCaret();
        defaultCaret.setMagicCaretPosition(null);
    }

    protected abstract void performAction(Document var1, JTextComponent var2, int var3);

    public void performClickAction(Document document, final int n) {
        if (!(document instanceof Document)) {
            return;
        }
        final Document document2 = document;
        final JTextComponent jTextComponent = Utilities.getFocusedComponent();
        if (jTextComponent == null || jTextComponent.getDocument() != document2) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                CsmAbstractHyperlinkProvider.this.performAction(document2, jTextComponent, n);
            }
        };
        CsmModelAccessor.getModel().enqueue(runnable, (CharSequence)"Following hyperlink");
    }

    public boolean isHyperlinkPoint(Document document, int n) {
        Token<CppTokenId> token = CsmAbstractHyperlinkProvider.getToken(document, n);
        return this.isValidToken(token);
    }

    protected abstract boolean isValidToken(Token<CppTokenId> var1);

    public int[] getHyperlinkSpan(Document document, int n) {
        Token<CppTokenId> token = CsmAbstractHyperlinkProvider.getToken(document, n);
        if (this.isValidToken(token)) {
            return new int[]{token.offset(null), token.offset(null) + token.length()};
        }
        return null;
    }

    protected boolean preJump(Document document, JTextComponent jTextComponent, int n, String string) {
        if (document == null || jTextComponent == null || n < 0 || n > document.getLength()) {
            return false;
        }
        this.jumpToken = CsmAbstractHyperlinkProvider.getToken(document, n);
        if (!this.isValidToken(this.jumpToken)) {
            return false;
        }
        String string2 = ((Object)this.jumpToken.text()).toString();
        String string3 = NbBundle.getBundle(NbCsmSyntaxSupport.class).getString(string);
        string3 = MessageFormat.format(string3, string2);
        StatusDisplayer.getDefault().setStatusText(string3);
        return true;
    }

    protected boolean postJump(CsmOffsetable csmOffsetable, String string, String string2) {
        if (this.jumpToken == null) {
            return false;
        }
        if (csmOffsetable == null || !CsmUtilities.openSource((CsmObject)csmOffsetable)) {
            String string3;
            String string4;
            Toolkit.getDefaultToolkit().beep();
            String string5 = CsmUtilities.getElementJumpName((CsmObject)csmOffsetable);
            if (string5 != null && string5.length() > 0) {
                string4 = "goto_source_source_not_found";
                string3 = string5;
            } else {
                string4 = "cannot-open-csm-element";
                string3 = ((Object)this.jumpToken.text()).toString();
            }
            String string6 = NbBundle.getBundle(NbCsmSyntaxSupport.class).getString(string4);
            StatusDisplayer.getDefault().setStatusText(MessageFormat.format(string6, string3));
            return false;
        }
        return true;
    }

    protected Token getJumpToken() {
        return this.jumpToken;
    }

    static Token<CppTokenId> getToken(final Document document, final int n) {
        final Token[] tokenArray = new Token[]{null};
        Runnable runnable = new Runnable(){

            public void run() {
                tokenArray[0] = CndTokenUtilities.getOffsetTokenCheckPrev((Document)document, (int)n);
            }
        };
        if (document instanceof BaseDocument) {
            ((BaseDocument)document).runAtomic(runnable);
        } else {
            runnable.run();
        }
        return tokenArray[0];
    }
}

