/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.ruby.platform.execution.OutputRecognizer;
import org.netbeans.modules.ruby.testrunner.ui.Manager;
import org.netbeans.modules.ruby.testrunner.ui.Report;
import org.netbeans.modules.ruby.testrunner.ui.TestRecognizerHandler;
import org.netbeans.modules.ruby.testrunner.ui.TestSession;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestUnitHandlerFactory {
    private static final Logger LOGGER = Logger.getLogger(TestUnitHandlerFactory.class.getName());

    public static List<TestRecognizerHandler> getHandlers() {
        ArrayList<TestRecognizerHandler> arrayList = new ArrayList<TestRecognizerHandler>();
        arrayList.add(new SuiteStartingHandler());
        arrayList.add(new SuiteStartedHandler());
        arrayList.add(new SuiteFinishedHandler());
        arrayList.add(new SuiteErrorOutputHandler());
        arrayList.add(new TestStartedHandler());
        arrayList.add(new TestFailedHandler());
        arrayList.add(new TestErrorHandler());
        arrayList.add(new TestFinishedHandler());
        arrayList.add(new TestLoggerHandler());
        arrayList.add(new TestMiscHandler());
        arrayList.add(new SuiteMiscHandler());
        return arrayList;
    }

    private static String errorMsg(long l) {
        return NbBundle.getMessage(TestUnitHandlerFactory.class, (String)"MSG_Error", (Object)l);
    }

    private static String failureMsg(long l) {
        return NbBundle.getMessage(TestUnitHandlerFactory.class, (String)"MSG_Failure", (Object)l);
    }

    static String[] getStackTrace(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        for (String string3 : string2.split("%BR%")) {
            if (string3.contains("nb_test_mediator.rb") || string3.contains("nb_test_runner.rb")) continue;
            arrayList.add(string3);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    static class TestLoggerHandler
    extends TestRecognizerHandler {
        public TestLoggerHandler() {
            super("%TEST_LOGGER%\\slevel=(.+)\\smsg=(.*)");
        }

        void updateUI(Manager manager, TestSession testSession) {
            Level level = Level.parse(this.matcher.group(1));
            if (LOGGER.isLoggable(level)) {
                LOGGER.log(level, this.matcher.group(2));
            }
        }
    }

    static class SuiteMiscHandler
    extends TestRecognizerHandler {
        public SuiteMiscHandler() {
            super("%SUITE_.*");
        }

        void updateUI(Manager manager, TestSession testSession) {
        }
    }

    static class SuiteStartingHandler
    extends TestRecognizerHandler {
        private boolean firstSuite = true;

        public SuiteStartingHandler() {
            super("%SUITE_STARTING%\\s(.+)");
        }

        void updateUI(Manager manager, TestSession testSession) {
            if (this.firstSuite) {
                this.firstSuite = false;
                manager.testStarted(testSession);
            }
            String string = this.matcher.group(1);
            testSession.setSuiteName(string);
            manager.displaySuiteRunning(testSession, string);
        }
    }

    static class SuiteErrorOutputHandler
    extends TestRecognizerHandler {
        public SuiteErrorOutputHandler() {
            super("%SUITE_ERROR_OUTPUT%\\serror=(.*)");
        }

        void updateUI(Manager manager, TestSession testSession) {
            manager.displayOutput(testSession, this.matcher.group(1), true);
            manager.displayOutput(testSession, "", false);
        }

        OutputRecognizer.RecognizedOutput getRecognizedOutput() {
            return new OutputRecognizer.FilteredOutput(new String[]{this.matcher.group(1)});
        }
    }

    static class SuiteStartedHandler
    extends TestRecognizerHandler {
        public SuiteStartedHandler() {
            super("%SUITE_STARTED%\\s.*");
        }

        void updateUI(Manager manager, TestSession testSession) {
        }
    }

    static class SuiteFinishedHandler
    extends TestRecognizerHandler {
        public SuiteFinishedHandler() {
            super("%SUITE_FINISHED%\\stime=(.+)");
        }

        void updateUI(Manager manager, TestSession testSession) {
            String string = this.matcher.group(1);
            Double d = Double.parseDouble(string) * 1000.0;
            Report report = testSession.getReport();
            report.elapsedTimeMillis = d.intValue();
            manager.displayReport(testSession, report);
        }
    }

    static class TestMiscHandler
    extends TestRecognizerHandler {
        public TestMiscHandler() {
            super("%TEST_.*");
        }

        void updateUI(Manager manager, TestSession testSession) {
        }
    }

    static class TestFinishedHandler
    extends TestRecognizerHandler {
        public TestFinishedHandler() {
            super("%TEST_FINISHED%\\stime=(.+)\\s([\\w]+)\\((.+)\\)");
        }

        void updateUI(Manager manager, TestSession testSession) {
            Report.Testcase testcase = new Report.Testcase();
            testcase.timeMillis = TestFinishedHandler.toMillis(this.matcher.group(1));
            testcase.className = this.matcher.group(3);
            testcase.name = this.matcher.group(2);
            testSession.addTestCase(testcase);
        }
    }

    static class TestStartedHandler
    extends TestRecognizerHandler {
        public TestStartedHandler() {
            super("%TEST_STARTED%\\s([\\w]+)\\((.+)\\)");
        }

        void updateUI(Manager manager, TestSession testSession) {
        }
    }

    static class TestErrorHandler
    extends TestRecognizerHandler {
        private List<String> output;

        public TestErrorHandler() {
            super("%TEST_ERROR%\\stime=(.+)\\stestname=(.+)\\((.+)\\)\\smessage=(.*)\\slocation=(.*)");
        }

        void updateUI(Manager manager, TestSession testSession) {
            Report.Testcase testcase = new Report.Testcase();
            testcase.timeMillis = TestErrorHandler.toMillis(this.matcher.group(1));
            testcase.className = this.matcher.group(3);
            testcase.name = this.matcher.group(2);
            testcase.trouble = new Report.Trouble(true);
            testcase.trouble.stackTrace = TestUnitHandlerFactory.getStackTrace(this.matcher.group(4), this.matcher.group(5));
            testSession.addTestCase(testcase);
            String string = TestUnitHandlerFactory.errorMsg(testSession.incrementFailuresCount());
            String string2 = testcase.name + "(" + testcase.className + "):";
            this.output = new ArrayList<String>();
            this.output.add("");
            this.output.add(string);
            this.output.add(string2);
            this.output.addAll(Arrays.asList(testcase.trouble.stackTrace));
            this.output.add("");
            manager.displayOutput(testSession, "", false);
            manager.displayOutput(testSession, string, false);
            manager.displayOutput(testSession, string2, false);
            for (String string3 : testcase.trouble.stackTrace) {
                manager.displayOutput(testSession, string3, true);
            }
            manager.displayOutput(testSession, "", false);
        }

        OutputRecognizer.RecognizedOutput getRecognizedOutput() {
            return new OutputRecognizer.FilteredOutput(this.output.toArray(new String[this.output.size()]));
        }
    }

    static class TestFailedHandler
    extends TestRecognizerHandler {
        private List<String> output;

        public TestFailedHandler() {
            super("%TEST_FAILED%\\stime=(.+)\\stestname=(.+)\\((.+)\\)\\smessage=(.*)\\slocation=(.*)");
        }

        void updateUI(Manager manager, TestSession testSession) {
            Report.Testcase testcase = new Report.Testcase();
            testcase.timeMillis = TestFailedHandler.toMillis(this.matcher.group(1));
            testcase.name = this.matcher.group(2);
            testcase.className = this.matcher.group(3);
            testcase.trouble = new Report.Trouble(false);
            String string = this.matcher.group(4);
            String string2 = this.matcher.group(5);
            testcase.trouble.stackTrace = TestUnitHandlerFactory.getStackTrace(string, string2);
            testSession.addTestCase(testcase);
            String string3 = TestUnitHandlerFactory.failureMsg(testSession.incrementFailuresCount());
            String string4 = testcase.name + "(" + testcase.className + "):";
            this.output = new ArrayList<String>();
            this.output.add("");
            this.output.add(string3);
            this.output.add(string4);
            this.output.addAll(Arrays.asList(testcase.trouble.stackTrace));
            this.output.add("");
            manager.displayOutput(testSession, "", false);
            manager.displayOutput(testSession, string3, false);
            manager.displayOutput(testSession, string4, false);
            for (String string5 : testcase.trouble.stackTrace) {
                manager.displayOutput(testSession, string5, false);
            }
            manager.displayOutput(testSession, "", false);
        }

        OutputRecognizer.RecognizedOutput getRecognizedOutput() {
            return new OutputRecognizer.FilteredOutput(this.output.toArray(new String[this.output.size()]));
        }
    }
}

