/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner.ui;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.ruby.platform.execution.FileLocator;
import org.netbeans.modules.ruby.testrunner.ui.Report;
import org.netbeans.modules.ruby.testrunner.ui.Status;

public class TestSession {
    private long failuresCount = 0L;
    private final List<Report.Testcase> testCases = new ArrayList<Report.Testcase>();
    private String suiteName;
    private final FileLocator fileLocator;
    private final SessionType sessionType;

    public TestSession(FileLocator fileLocator, SessionType sessionType) {
        this.fileLocator = fileLocator;
        this.sessionType = sessionType;
    }

    void setSuiteName(String string) {
        this.testCases.clear();
        this.suiteName = string;
    }

    void addTestCase(Report.Testcase testcase) {
        for (Report.Testcase testcase2 : this.testCases) {
            if (!testcase.className.equals(testcase2.className) || !testcase.name.equals(testcase2.name)) continue;
            return;
        }
        this.testCases.add(testcase);
    }

    Report getReport() {
        Report report = new Report(this.suiteName, this.fileLocator);
        for (Report.Testcase testcase : this.testCases) {
            report.reportTest(testcase);
            ++report.totalTests;
            if (testcase.getStatus() == Status.ERROR) {
                ++report.errors;
                continue;
            }
            if (testcase.getStatus() == Status.FAILED) {
                ++report.failures;
                continue;
            }
            if (testcase.getStatus() == Status.PENDING) {
                ++report.pending;
                continue;
            }
            ++report.detectedPassedTests;
        }
        return report;
    }

    String getSuiteName() {
        return this.suiteName;
    }

    SessionType getSessionType() {
        return this.sessionType;
    }

    synchronized long incrementFailuresCount() {
        return ++this.failuresCount;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SessionType {
        TEST,
        DEBUG;

    }
}

