/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner.ui;

import java.awt.Image;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.testrunner.ui.JumpAction;
import org.netbeans.modules.ruby.testrunner.ui.Report;
import org.netbeans.modules.ruby.testrunner.ui.Status;
import org.netbeans.modules.ruby.testrunner.ui.TestMethodNodeChildren;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

final class TestMethodNode
extends AbstractNode {
    private final Report.Testcase testcase;

    TestMethodNode(Report.Testcase testcase) {
        super((Children)(testcase.trouble != null ? new TestMethodNodeChildren(testcase) : Children.LEAF));
        this.testcase = testcase;
        this.setDisplayName();
        this.setIconBaseWithExtension("org/netbeans/modules/ruby/testrunner/ui/res/method.gif");
    }

    private void setDisplayName() {
        int n;
        int n2 = this.testcase.trouble == null ? 0 : (n = this.testcase.trouble.isError() ? 1 : 2);
        if (n == 0 && this.testcase.timeMillis < 0) {
            this.setDisplayName(this.testcase.name);
            return;
        }
        String[] stringArray = new String[]{null, "MSG_TestMethodError", "MSG_TestMethodFailed"};
        String[] stringArray2 = new String[]{"MSG_TestMethodPassed_time", "MSG_TestMethodError_time", "MSG_TestMethodFailed_time"};
        this.setDisplayName(this.testcase.timeMillis < 0 ? NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)stringArray[n], (Object)this.testcase.name) : NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)stringArray2[n], (Object)this.testcase.name, (Object)new Float((float)this.testcase.timeMillis / 1000.0f)));
    }

    public String getHtmlDisplayName() {
        Status status = this.testcase.getStatus();
        StringBuffer stringBuffer = new StringBuffer(60);
        stringBuffer.append(this.testcase.name);
        stringBuffer.append("&nbsp;&nbsp;");
        stringBuffer.append("<font color='#");
        stringBuffer.append(status.getHtmlDisplayColor() + "'>");
        stringBuffer.append(this.testcase.timeMillis < 0 ? NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)DisplayNameMapper.getNoTimeKey(status)) : NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)DisplayNameMapper.getTimeKey(status), (Object)new Float((float)this.testcase.timeMillis / 1000.0f)));
        stringBuffer.append("</font>");
        return stringBuffer.toString();
    }

    public Action getPreferredAction() {
        return new JumpAction((Node)this, this.getTestCaseLineFromStackTrace());
    }

    private String getTestCaseLineFromStackTrace() {
        if (this.testcase.trouble == null) {
            return null;
        }
        String[] stringArray = this.testcase.trouble.stackTrace;
        if (stringArray == null || stringArray.length <= 1) {
            return null;
        }
        if (stringArray.length > 2) {
            String string = RubyUtils.camelToUnderlinedName((String)this.testcase.className);
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].contains(string) || !stringArray[i].contains(this.testcase.name)) continue;
                return stringArray[i];
            }
        }
        return stringArray[1];
    }

    public SystemAction[] getActions(boolean bl) {
        return new SystemAction[0];
    }

    public Image getIcon(int n) {
        Image image = ImageUtilities.loadImage((String)"org/netbeans/modules/ruby/testrunner/ui/res/method.gif");
        if (this.failed()) {
            Image image2 = ImageUtilities.loadImage((String)"org/netbeans/modules/ruby/testrunner/ui/res/error-badge.gif");
            return ImageUtilities.mergeImages((Image)image, (Image)image2, (int)0, (int)8);
        }
        return image;
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    boolean failed() {
        return this.testcase.trouble != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DisplayNameMapper {
        private static final Map<Status, String> NO_TIME_KEYS = DisplayNameMapper.initNoTimeKeys();
        private static final Map<Status, String> TIME_KEYS = DisplayNameMapper.initTimeKeys();

        private DisplayNameMapper() {
        }

        private static Map<Status, String> initNoTimeKeys() {
            HashMap<Status, String> hashMap = new HashMap<Status, String>(4);
            hashMap.put(Status.PASSED, "MSG_TestMethodPassed_HTML");
            hashMap.put(Status.ERROR, "MSG_TestMethodError_HTML");
            hashMap.put(Status.FAILED, "MSG_TestMethodFailed_HTML");
            hashMap.put(Status.PENDING, "MSG_TestMethodPending_HTML");
            return hashMap;
        }

        private static Map<Status, String> initTimeKeys() {
            HashMap<Status, String> hashMap = new HashMap<Status, String>(4);
            hashMap.put(Status.PASSED, "MSG_TestMethodPassed_HTML_time");
            hashMap.put(Status.ERROR, "MSG_TestMethodError_HTML_time");
            hashMap.put(Status.FAILED, "MSG_TestMethodFailed_HTML_time");
            hashMap.put(Status.PENDING, "MSG_TestMethodPending_HTML_time");
            return hashMap;
        }

        static String getNoTimeKey(Status status) {
            return NO_TIME_KEYS.get((Object)status);
        }

        static String getTimeKey(Status status) {
            return TIME_KEYS.get((Object)status);
        }
    }
}

