/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner.ui;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.ruby.platform.execution.OutputRecognizer;
import org.netbeans.modules.ruby.testrunner.ui.Manager;
import org.netbeans.modules.ruby.testrunner.ui.Report;
import org.netbeans.modules.ruby.testrunner.ui.Status;
import org.netbeans.modules.ruby.testrunner.ui.TestRecognizerHandler;
import org.netbeans.modules.ruby.testrunner.ui.TestSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RspecHandlerFactory {
    public static List<TestRecognizerHandler> getHandlers() {
        ArrayList<TestRecognizerHandler> arrayList = new ArrayList<TestRecognizerHandler>();
        arrayList.add(new SuiteStartingHandler());
        arrayList.add(new SuiteStartedHandler());
        arrayList.add(new SuiteFinishedHandler());
        arrayList.add(new TestStartedHandler());
        arrayList.add(new TestFailedHandler());
        arrayList.add(new TestPendingHandler());
        arrayList.add(new TestFinishedHandler());
        arrayList.add(new StackTraceFilterHandler());
        return arrayList;
    }

    static class StackTraceFilterHandler
    extends TestRecognizerHandler {
        public StackTraceFilterHandler() {
            super(".*nb_rspec_mediator.rb.*");
        }

        void updateUI(Manager manager, TestSession testSession) {
        }
    }

    static class SuiteStartingHandler
    extends TestRecognizerHandler {
        private boolean firstSuite = true;

        public SuiteStartingHandler() {
            super(".*%SUITE_STARTING%\\s(.+)");
        }

        void updateUI(Manager manager, TestSession testSession) {
            if (this.firstSuite) {
                this.firstSuite = false;
                manager.testStarted(testSession);
            }
            String string = this.matcher.group(1);
            testSession.setSuiteName(string);
            manager.displaySuiteRunning(testSession, string);
        }
    }

    static class SuiteStartedHandler
    extends TestRecognizerHandler {
        public SuiteStartedHandler() {
            super(".*%SUITE_STARTED%\\s.*");
        }

        void updateUI(Manager manager, TestSession testSession) {
        }
    }

    static class SuiteFinishedHandler
    extends TestRecognizerHandler {
        public SuiteFinishedHandler() {
            super(".*%SUITE_FINISHED%\\s(.+)\\stime=(.+)");
        }

        void updateUI(Manager manager, TestSession testSession) {
            String string = this.matcher.group(1);
            Report report = testSession.getReport();
            report.elapsedTimeMillis = SuiteFinishedHandler.toMillis(this.matcher.group(2));
            manager.displayReport(testSession, report);
        }
    }

    static class TestPendingHandler
    extends TestRecognizerHandler {
        public TestPendingHandler() {
            super(".*%TEST_PENDING%\\s(.*)\\stime=(.+)\\smessage=(.*)");
        }

        void updateUI(Manager manager, TestSession testSession) {
            Report.Testcase testcase = new Report.Testcase();
            testcase.timeMillis = TestPendingHandler.toMillis(this.matcher.group(2));
            testcase.className = testSession.getSuiteName();
            testcase.name = this.matcher.group(1);
            testcase.trouble = new Report.Trouble(false);
            testcase.trouble.stackTrace = new String[]{this.matcher.group(3)};
            testcase.setStatus(Status.PENDING);
            testSession.addTestCase(testcase);
        }
    }

    static class TestFinishedHandler
    extends TestRecognizerHandler {
        public TestFinishedHandler() {
            super(".*%TEST_FINISHED%\\s(.*)\\stime=(.+)");
        }

        void updateUI(Manager manager, TestSession testSession) {
            Report.Testcase testcase = new Report.Testcase();
            testcase.timeMillis = TestFinishedHandler.toMillis(this.matcher.group(2));
            testcase.className = testSession.getSuiteName();
            testcase.name = this.matcher.group(1);
            testSession.addTestCase(testcase);
        }
    }

    static class TestStartedHandler
    extends TestRecognizerHandler {
        public TestStartedHandler() {
            super(".*%TEST_STARTED%\\s(.*)");
        }

        void updateUI(Manager manager, TestSession testSession) {
        }
    }

    static class TestFailedHandler
    extends TestRecognizerHandler {
        public TestFailedHandler() {
            super(".*%TEST_FAILED%\\s(.*)\\stime=(\\d+\\.\\d+)\\smessage=(.*)\\slocation=(.*)");
        }

        void updateUI(Manager manager, TestSession testSession) {
            Report.Testcase testcase = new Report.Testcase();
            testcase.timeMillis = TestFailedHandler.toMillis(this.matcher.group(2));
            testcase.className = this.matcher.group(1);
            testcase.name = this.matcher.group(1);
            testcase.trouble = new Report.Trouble(false);
            testcase.trouble.stackTrace = this.filterStackTrace(this.matcher.group(3), this.matcher.group(4));
            testSession.addTestCase(testcase);
            for (String string : testcase.trouble.stackTrace) {
                manager.displayOutput(testSession, string, false);
            }
        }

        OutputRecognizer.RecognizedOutput getRecognizedOutput() {
            return new OutputRecognizer.FilteredOutput(new String[]{this.matcher.group(3), this.matcher.group(4)});
        }

        private String[] filterStackTrace(String ... stringArray) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : stringArray) {
                if (string.contains("nb_rspec_mediator.rb")) continue;
                arrayList.add(string);
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
    }
}

