/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner.ui;

import java.io.File;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.modules.ruby.platform.RubyExecution;
import org.netbeans.modules.ruby.platform.execution.FileLocator;
import org.netbeans.modules.ruby.platform.execution.OutputProcessor;
import org.netbeans.modules.ruby.platform.execution.OutputRecognizer;
import org.netbeans.modules.ruby.platform.execution.RegexpOutputRecognizer;
import org.netbeans.modules.ruby.testrunner.ui.Report;
import org.netbeans.modules.ruby.testrunner.ui.TestsuiteNode;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;

final class OutputUtils {
    private static final Logger LOGGER = Logger.getLogger(OutputUtils.class.getName());

    private OutputUtils() {
    }

    static void openCallstackFrame(Node node, String string) {
        List list = RubyExecution.getStandardRubyRecognizers();
        Report report = OutputUtils.getTestsuiteNode(node).getReport();
        for (RegexpOutputRecognizer regexpOutputRecognizer : list) {
            FileObject fileObject;
            OutputRecognizer.FileLocation fileLocation = regexpOutputRecognizer.processLine(string);
            if (fileLocation == null || (fileObject = OutputUtils.findFile(fileLocation.file, report.getFileLocator())) == null) continue;
            OutputProcessor.open((FileObject)fileObject, (int)fileLocation.line);
            return;
        }
        LOGGER.info("Could not open a file for " + string);
    }

    private static TestsuiteNode getTestsuiteNode(Node node) {
        while (!(node instanceof TestsuiteNode)) {
            node = node.getParentNode();
        }
        return (TestsuiteNode)node;
    }

    private static FileObject findFile(String string, FileLocator fileLocator) {
        Object object;
        if (fileLocator != null && (object = fileLocator.find(string)) != null) {
            return object;
        }
        object = new File(string);
        if (((File)object).isFile()) {
            return FileUtil.toFileObject((File)FileUtil.normalizeFile((File)object));
        }
        LOGGER.warning("Cannot resolve file for \"" + string + "\" path.");
        return null;
    }
}

