/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelutil;

import java.awt.Color;
import java.io.IOException;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsmDisplayUtilities {
    private static final boolean SKIP_COLORING = Boolean.getBoolean("cnd.test.skip.coloring");

    public static String getContextLineHtml(CsmFile csmFile, int n, int n2, boolean bl) {
        CloneableEditorSupport cloneableEditorSupport = CsmUtilities.findCloneableEditorSupport(csmFile);
        StyledDocument styledDocument = null;
        try {
            styledDocument = cloneableEditorSupport.openDocument();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string = null;
        if (styledDocument instanceof BaseDocument) {
            BaseDocument baseDocument = (BaseDocument)styledDocument;
            try {
                int n3 = n;
                int n4 = n2;
                int n5 = org.netbeans.editor.Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n3);
                int n6 = org.netbeans.editor.Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n4) + 1;
                if (!bl) {
                    n3 = -1;
                    n4 = -1;
                }
                string = CsmDisplayUtilities.getLineHtml(n5, n6, n3, n4, baseDocument);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return string;
    }

    public static String getLineHtml(int n, int n2, int n3, int n4, BaseDocument baseDocument) throws BadLocationException {
        int n5 = n3 - n;
        int n6 = n4 - n;
        String string = baseDocument.getText(n, n2 - n);
        String string2 = (String)baseDocument.getProperty((Object)"mimeType");
        if (n5 >= 0 && n6 >= 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(CsmDisplayUtilities.getHtml(string2, CsmDisplayUtilities.trimStart(string.substring(0, n5))));
            stringBuilder.append("<b>");
            stringBuilder.append(CsmDisplayUtilities.getHtml(string2, string.substring(n5, n6)));
            stringBuilder.append("</b>");
            stringBuilder.append(CsmDisplayUtilities.getHtml(string2, CsmDisplayUtilities.trimEnd(string.substring(n6))));
            return stringBuilder.toString();
        }
        return CsmDisplayUtilities.getHtml(string2, string);
    }

    public static String getHtml(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        Language language = CndLexerUtilities.getLanguage((String)string);
        if (language == null) {
            return string2;
        }
        TokenHierarchy tokenHierarchy = TokenHierarchy.create((CharSequence)string2, (Language)language);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        CsmDisplayUtilities.appendHtml(stringBuilder, tokenSequence);
        return stringBuilder.toString();
    }

    private static void appendHtml(StringBuilder stringBuilder, TokenSequence<?> tokenSequence) {
        TokenSequence tokenSequence2;
        Object object;
        FontColorSettings fontColorSettings = null;
        LanguagePath languagePath = tokenSequence.languagePath();
        while (!SKIP_COLORING && languagePath != null && fontColorSettings == null) {
            object = languagePath.mimePath();
            tokenSequence2 = MimeLookup.getLookup((String)object);
            fontColorSettings = (FontColorSettings)tokenSequence2.lookup(FontColorSettings.class);
        }
        while (tokenSequence.moveNext()) {
            object = tokenSequence.token();
            tokenSequence2 = tokenSequence.embedded();
            if (tokenSequence2 != null && tokenSequence2.language() == CppTokenId.languagePreproc()) {
                CsmDisplayUtilities.appendHtml(stringBuilder, tokenSequence2);
                continue;
            }
            String string = object.id().primaryCategory();
            if (string == null) {
                string = "whitespace";
            }
            String string2 = "whitespace".equals(string) ? " " : ((Object)object.text()).toString();
            if (fontColorSettings != null) {
                AttributeSet attributeSet = fontColorSettings.getTokenFontColors(string);
                stringBuilder.append(CsmDisplayUtilities.color(CsmDisplayUtilities.htmlize(string2), attributeSet));
                continue;
            }
            stringBuilder.append(CsmDisplayUtilities.htmlize(string2));
        }
    }

    public static String htmlize(String string) {
        String string2 = Utilities.replaceString((String)string, (String)"<", (String)"&lt;");
        string2 = Utilities.replaceString((String)string2, (String)">", (String)"&gt;");
        return string2;
    }

    private static String color(String string, AttributeSet attributeSet) {
        if (attributeSet == null) {
            return string;
        }
        if (string.trim().length() == 0) {
            return Utilities.replaceString((String)Utilities.replaceString((String)string, (String)" ", (String)"&nbsp;"), (String)"\n", (String)"<br>");
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        if (StyleConstants.isBold(attributeSet)) {
            stringBuilder.insert(0, "<b>");
            stringBuilder.append("</b>");
        }
        if (StyleConstants.isItalic(attributeSet)) {
            stringBuilder.insert(0, "<i>");
            stringBuilder.append("</i>");
        }
        if (StyleConstants.isStrikeThrough(attributeSet)) {
            stringBuilder.insert(0, "<s>");
            stringBuilder.append("</s>");
        }
        stringBuilder.insert(0, "<font color=" + CsmDisplayUtilities.getHTMLColor(StyleConstants.getForeground(attributeSet)) + ">");
        stringBuilder.append("</font>");
        return stringBuilder.toString();
    }

    private static String getHTMLColor(Color color) {
        String string = "0" + Integer.toHexString(color.getRed());
        string = string.substring(string.length() - 2);
        String string2 = "0" + Integer.toHexString(color.getGreen());
        string2 = string2.substring(string2.length() - 2);
        String string3 = "0" + Integer.toHexString(color.getBlue());
        string3 = string3.substring(string3.length() - 2);
        String string4 = "#" + string + string2 + string3;
        return string4;
    }

    private static String trimStart(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return string.substring(i, string.length());
        }
        return "";
    }

    private static String trimEnd(String string) {
        for (int i = string.length() - 1; i >= 0; --i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return string.substring(0, i + 1);
        }
        return "";
    }
}

