/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.actions;

import java.util.Collections;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.SessionId;
import org.netbeans.modules.php.dbgp.actions.AbstractActionProvider;
import org.netbeans.modules.php.dbgp.breakpoints.Utils;
import org.netbeans.modules.php.dbgp.packets.BrkpntCommandBuilder;
import org.netbeans.modules.php.dbgp.packets.BrkpntSetCommand;
import org.netbeans.modules.php.dbgp.packets.RunCommand;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.text.Line;

public class RunToCursorActionProvider
extends AbstractActionProvider {
    public RunToCursorActionProvider(ContextProvider contextProvider) {
        super(contextProvider);
    }

    public void doAction(Object object) {
        SessionId sessionId = this.getSessionId();
        if (sessionId == null) {
            return;
        }
        this.hideSuspendAnnotations();
        DebugSession debugSession = this.getSession();
        if (debugSession == null) {
            return;
        }
        Line line = Utils.getCurrentLine();
        BrkpntSetCommand brkpntSetCommand = BrkpntCommandBuilder.buildLineBreakpoint(sessionId, debugSession.getTransactionId(), EditorContextDispatcher.getDefault().getCurrentFile(), line.getLineNumber());
        brkpntSetCommand.setTemporary(true);
        debugSession.sendCommandLater(brkpntSetCommand);
        this.hideSuspendAnnotations();
        RunCommand runCommand = new RunCommand(debugSession.getTransactionId());
        debugSession.sendCommandLater(runCommand);
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_RUN_TO_CURSOR);
    }
}

