/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp;

import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.php.dbgp.DebuggerOptions;
import org.netbeans.modules.php.dbgp.SessionId;
import org.netbeans.modules.php.dbgp.StartActionProviderImpl;
import org.netbeans.modules.php.dbgp.models.AbstractIDEBridge;
import org.netbeans.modules.php.dbgp.packets.DbgpCommand;
import org.netbeans.modules.php.dbgp.packets.DbgpMessage;
import org.netbeans.modules.php.dbgp.packets.DbgpResponse;
import org.netbeans.modules.php.dbgp.packets.InitMessage;
import org.openide.util.RequestProcessor;

public class DebugSession
implements Runnable {
    private static final int SLEEP_TIME = 100;
    private DebuggerOptions options;
    private Socket mySocket;
    private AtomicBoolean isStopped;
    private Thread mySessionThread;
    private List<DbgpCommand> myCommands;
    private AtomicReference<SessionId> mySessionId;
    private AtomicReference<DebuggerEngine> myEngine;
    private static final AtomicInteger myTransactionId = new AtomicInteger(0);
    private IDESessionBridge myBridge;
    private AtomicReference<String> myFileName;

    DebugSession(DebuggerOptions debuggerOptions) {
        this.init(null);
        this.options = debuggerOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.setSessionThread(Thread.currentThread());
        boolean bl = false;
        List<DbgpCommand> list = this.myCommands;
        synchronized (list) {
            bl = this.myCommands.size() > 0;
        }
        while (this.continueDebugging()) {
            try {
                this.sendCommands();
                if (!this.continueDebugging()) continue;
                this.receiveData();
                this.sleepTillNewCommand();
            }
            catch (IOException iOException) {
                this.log(iOException);
            }
        }
        this.setSessionThread(null);
        try {
            this.getSocket().close();
        }
        catch (IOException iOException) {
            this.log(iOException);
        }
    }

    private boolean continueDebugging() {
        return !this.isStopped.get() && this.mySocket != null && !this.mySocket.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendCommandLater(DbgpCommand dbgpCommand) {
        DebugSession debugSession = this;
        synchronized (debugSession) {
            if (this.getSessionId() == null) {
                return;
            }
            if (this.getSessionThread() == null) {
                return;
            }
            this.addCommand(dbgpCommand);
        }
    }

    public DbgpResponse sendSynchronCommand(DbgpCommand dbgpCommand) {
        if (this.getSessionThread() != Thread.currentThread()) {
            throw new IllegalStateException("Method incorrect usage. It should be called in handler thread only");
        }
        try {
            DbgpMessage dbgpMessage;
            dbgpCommand.send(this.getSocket().getOutputStream());
            if (dbgpCommand.wantAcknowledgment() && (dbgpMessage = this.receiveData(dbgpCommand)) instanceof DbgpResponse) {
                return (DbgpResponse)dbgpMessage;
            }
        }
        catch (IOException iOException) {
            this.log(iOException);
        }
        return null;
    }

    public String getTransactionId() {
        return myTransactionId.getAndIncrement() + "";
    }

    public void start(Socket socket) {
        this.init(socket);
        RequestProcessor.getDefault().post((Runnable)this);
    }

    public void stop() {
        this.isStopped.set(true);
        this.getBridge().setSuspended(false);
        this.getBridge().hideAnnotations();
        StartActionProviderImpl.getInstance().removeSession(this);
        this.getBridge().getBreakpointModel().setCurrentStack(null, this);
        this.getBridge().getCallStackModel().clearModel();
        this.getBridge().getThreadsModel().update();
        this.getBridge().getVariablesModel().clearModel();
        this.getBridge().getWatchesModel().clearModel();
    }

    public void setId(InitMessage initMessage) {
        DebuggerEngine[] debuggerEngineArray;
        this.setSessionFile(initMessage.getFileUri());
        String string = initMessage.getSessionId();
        DebuggerEngine[] debuggerEngineArray2 = debuggerEngineArray = DebuggerManager.getDebuggerManager().getDebuggerEngines();
        int n = debuggerEngineArray2.length;
        for (int i = 0; i < n; ++i) {
            DebuggerEngine debuggerEngine = debuggerEngineArray2[i];
            SessionId sessionId = (SessionId)debuggerEngine.lookupFirst(null, SessionId.class);
            if (sessionId == null || !sessionId.getId().equals(string)) continue;
            this.mySessionId.set(sessionId);
            sessionId.setFileUri(initMessage.getFileUri());
            this.myEngine.set(debuggerEngine);
        }
        for (DebuggerEngine debuggerEngine : debuggerEngineArray2 = DebuggerManager.getDebuggerManager().getSessions()) {
            SessionId sessionId = (SessionId)debuggerEngine.lookupFirst(null, SessionId.class);
            if (sessionId == null || !sessionId.getId().equals(string)) continue;
            StartActionProviderImpl.getInstance().attachDebugSession((Session)debuggerEngine, this);
        }
    }

    public SessionId getSessionId() {
        return this.mySessionId.get();
    }

    public IDESessionBridge getBridge() {
        return this.myBridge;
    }

    public String getFileName() {
        return this.myFileName.get();
    }

    private void init(Socket socket) {
        this.mySocket = socket;
        this.isStopped = new AtomicBoolean(false);
        this.myCommands = new LinkedList<DbgpCommand>();
        this.mySessionId = new AtomicReference();
        this.myBridge = new IDESessionBridge();
        this.myFileName = new AtomicReference();
        this.myEngine = new AtomicReference();
    }

    private void setSessionFile(String string) {
        this.myFileName.set(string);
    }

    private void sleepTillNewCommand() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized void setSessionThread(Thread thread) {
        this.mySessionThread = thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCommands() throws IOException {
        ArrayList<DbgpCommand> arrayList;
        List<DbgpCommand> list = this.myCommands;
        synchronized (list) {
            arrayList = new ArrayList<DbgpCommand>(this.myCommands);
            this.myCommands.clear();
        }
        for (DbgpCommand dbgpCommand : arrayList) {
            if (!this.continueDebugging()) continue;
            dbgpCommand.send(this.getSocket().getOutputStream());
            if (!this.continueDebugging() || !dbgpCommand.wantAcknowledgment()) continue;
            this.receiveData(dbgpCommand);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCommand(DbgpCommand dbgpCommand) {
        List<DbgpCommand> list = this.myCommands;
        synchronized (list) {
            this.myCommands.add(dbgpCommand);
        }
    }

    private Thread getSessionThread() {
        return this.mySessionThread;
    }

    private void receiveData() throws IOException {
        this.receiveData(null);
    }

    private DbgpMessage receiveData(DbgpCommand dbgpCommand) throws IOException {
        if (dbgpCommand != null || this.getSocket().getInputStream().available() > 0) {
            DbgpMessage dbgpMessage = DbgpMessage.create(this.getSocket().getInputStream());
            this.handleMessage(dbgpCommand, dbgpMessage);
            return dbgpMessage;
        }
        return null;
    }

    private void handleMessage(DbgpCommand dbgpCommand, DbgpMessage dbgpMessage) throws IOException {
        DbgpResponse dbgpResponse;
        String string;
        if (dbgpMessage == null) {
            return;
        }
        if (dbgpCommand == null) {
            dbgpMessage.process(this, null);
            return;
        }
        boolean bl = false;
        if (dbgpMessage instanceof DbgpResponse && (string = (dbgpResponse = (DbgpResponse)dbgpMessage).getTransactionId()).equals(dbgpCommand.getTransactionId())) {
            bl = true;
            dbgpMessage.process(this, dbgpCommand);
        }
        if (!bl) {
            dbgpMessage.process(this, null);
            this.receiveData(dbgpCommand);
        }
    }

    private Socket getSocket() {
        return this.mySocket;
    }

    private void log(IOException iOException) {
        Logger.getLogger(DebugSession.class.getName()).log(Level.SEVERE, null, iOException);
    }

    public DebuggerOptions getOptions() {
        return this.options;
    }

    public class IDESessionBridge
    extends AbstractIDEBridge {
        protected DebuggerEngine getEngine() {
            return (DebuggerEngine)DebugSession.this.myEngine.get();
        }

        protected DebugSession getDebugSession() {
            return DebugSession.this;
        }
    }
}

