/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.tools.api;

import java.util.Collection;
import java.util.logging.Level;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.web.client.tools.api.FirefoxBrowserUtils;
import org.netbeans.modules.web.client.tools.api.Log;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.Utilities;

public final class WebClientToolsProjectUtils {
    private static final String CLIENT_DEBUG_PROP = "clientdebug";
    private static final String SERVER_DEBUG_PROP = "serverdebug";
    private static final boolean CLIENT_DEBUG_DEFAULT = true;
    private static final boolean SERVER_DEBUG_DEFAULT = true;
    public static final Browser BROWSER_DEFAULT = Browser.FIREFOX;

    public static HtmlBrowser.Factory getFirefoxBrowser() {
        return WebClientToolsProjectUtils.findBrowser("org.netbeans.modules.extbrowser.FirefoxBrowser");
    }

    public static HtmlBrowser.Factory getInternetExplorerBrowser() {
        return WebClientToolsProjectUtils.findBrowser("org.netbeans.modules.extbrowser.IExplorerBrowser");
    }

    public static boolean getClientDebugProperty(Project project) {
        return WebClientToolsProjectUtils.getProjectProperty(project, CLIENT_DEBUG_PROP, true);
    }

    public static boolean getServerDebugProperty(Project project) {
        if (WebClientToolsProjectUtils.supportedBrowsersAvailable()) {
            return WebClientToolsProjectUtils.getProjectProperty(project, SERVER_DEBUG_PROP, true);
        }
        return true;
    }

    public static boolean isDebugPropertySet(Project project) {
        Preferences preferences = ProjectUtils.getPreferences((Project)project, WebClientToolsProjectUtils.class, (boolean)true);
        assert (preferences != null);
        return preferences.get(CLIENT_DEBUG_PROP, null) != null;
    }

    public static boolean isFirefox(Project project) {
        return WebClientToolsProjectUtils.getProjectProperty(project, Browser.FIREFOX.name(), BROWSER_DEFAULT == Browser.FIREFOX);
    }

    public static boolean isInternetExplorer(Project project) {
        return WebClientToolsProjectUtils.getProjectProperty(project, Browser.INTERNET_EXPLORER.name(), BROWSER_DEFAULT == Browser.INTERNET_EXPLORER);
    }

    private static boolean getProjectProperty(Project project, String string, boolean bl) {
        Preferences preferences = ProjectUtils.getPreferences((Project)project, WebClientToolsProjectUtils.class, (boolean)true);
        assert (preferences != null);
        return preferences.getBoolean(string, bl);
    }

    public static void setProjectProperties(final Project project, final boolean bl, final boolean bl2, final Browser browser) {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){

                public Boolean run() throws BackingStoreException {
                    Preferences preferences = ProjectUtils.getPreferences((Project)project, WebClientToolsProjectUtils.class, (boolean)true);
                    assert (preferences != null);
                    boolean bl3 = browser == Browser.FIREFOX;
                    boolean bl22 = browser == Browser.INTERNET_EXPLORER;
                    preferences.putBoolean(WebClientToolsProjectUtils.SERVER_DEBUG_PROP, bl);
                    preferences.putBoolean(WebClientToolsProjectUtils.CLIENT_DEBUG_PROP, bl2);
                    preferences.putBoolean(Browser.FIREFOX.name(), bl3);
                    preferences.putBoolean(Browser.INTERNET_EXPLORER.name(), bl22);
                    preferences.sync();
                    return Boolean.TRUE;
                }
            });
        }
        catch (MutexException mutexException) {
            Log.getLogger().log(Level.SEVERE, "Unable to set javascript debugger project properties", mutexException);
        }
    }

    private static HtmlBrowser.Factory findBrowser(String string) {
        Collection collection = Lookup.getDefault().lookupAll(HtmlBrowser.Factory.class);
        for (HtmlBrowser.Factory factory : collection) {
            if (!factory.getClass().getName().equals(string)) continue;
            return factory;
        }
        return null;
    }

    public static boolean isFirefoxSupported() {
        HtmlBrowser.Factory factory = WebClientToolsProjectUtils.getFirefoxBrowser();
        return factory != null && FirefoxBrowserUtils.isSupportedFirefox(factory);
    }

    public static boolean isInternetExplorerSupported() {
        return Utilities.isWindows() && WebClientToolsProjectUtils.getInternetExplorerBrowser() != null;
    }

    public static boolean supportedBrowsersAvailable() {
        return WebClientToolsProjectUtils.isInternetExplorerSupported() || WebClientToolsProjectUtils.isFirefoxSupported();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Browser {
        FIREFOX,
        INTERNET_EXPLORER;

    }
}

