/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListDataListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.modules.db.mysql.DatabaseServer;
import org.netbeans.modules.db.mysql.DatabaseUser;
import org.netbeans.modules.db.mysql.impl.SampleManager;
import org.netbeans.modules.db.mysql.util.DatabaseUtils;
import org.netbeans.modules.db.mysql.util.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CreateDatabasePanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(CreateDatabasePanel.class.getName());
    DialogDescriptor descriptor;
    final DatabaseServer server;
    private Color nbErrorForeground;
    private JCheckBox chkGrantAccess;
    private JComboBox comboDatabaseName;
    private JComboBox comboUsers;
    private JLabel jLabel1;
    private JLabel messageLabel;

    private void validatePanel(String string) {
        if (this.descriptor == null) {
            return;
        }
        String string2 = null;
        this.comboUsers.setEnabled(this.isGrantAccess());
        if (Utils.isEmpty(string)) {
            string2 = NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.MSG_SpecifyDatabase");
        }
        if (string2 != null) {
            this.messageLabel.setText(string2);
            this.descriptor.setValid(false);
        } else {
            this.messageLabel.setText(" ");
            this.descriptor.setValid(true);
        }
    }

    public static DatabaseConnection showCreateDatabaseDialog(DatabaseServer databaseServer) {
        assert (SwingUtilities.isEventDispatchThread());
        CreateDatabasePanel createDatabasePanel = new CreateDatabasePanel(databaseServer);
        String string = NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.LBL_CreateDatabaseTitle");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)createDatabasePanel, string);
        createDatabasePanel.setDialogDescriptor(dialogDescriptor);
        while (true) {
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            String string2 = NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.ACSD_CreateDatabasePanel");
            dialog.getAccessibleContext().setAccessibleDescription(string2);
            dialog.setVisible(true);
            dialog.dispose();
            if (!DialogDescriptor.OK_OPTION.equals(dialogDescriptor.getValue())) {
                return null;
            }
            if (!Utils.isEmpty(createDatabasePanel.getDatabaseName())) break;
            Utils.displayErrorMessage(NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.MSG_EmptyDatabaseName"));
        }
        return CreateDatabasePanel.createDatabase(createDatabasePanel.getServer(), createDatabasePanel.getDatabaseName(), createDatabasePanel.getGrantUser());
    }

    private static DatabaseConnection createDatabase(DatabaseServer databaseServer, final String string, DatabaseUser databaseUser) {
        boolean bl = false;
        DatabaseConnection databaseConnection = null;
        try {
            String string2;
            if (!CreateDatabasePanel.checkExistingDatabase(databaseServer, string)) {
                return null;
            }
            databaseServer.createDatabase(string);
            bl = true;
            if (databaseUser != null) {
                databaseServer.grantFullDatabaseRights(string, databaseUser);
                string2 = databaseUser.getUser();
            } else {
                string2 = databaseServer.getUser();
            }
            final DatabaseConnection databaseConnection2 = databaseConnection = CreateDatabasePanel.createConnection(databaseServer, string, string2);
            if (databaseConnection != null && SampleManager.isSample(string)) {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        try {
                            SampleManager.createSample(string, databaseConnection2);
                        }
                        catch (DatabaseException databaseException) {
                            Exceptions.printStackTrace((Throwable)databaseException);
                        }
                    }
                });
            }
        }
        catch (DatabaseException databaseException) {
            CreateDatabasePanel.displayCreateFailure(databaseServer, databaseException, string, bl);
            return null;
        }
        return databaseConnection;
    }

    private static void displayCreateFailure(DatabaseServer databaseServer, DatabaseException databaseException, String string, boolean bl) {
        Utils.displayError(NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.MSG_CreateFailed"), (Exception)((Object)databaseException));
        if (bl) {
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.MSG_DeleteCreatedDatabase", (Object)string), NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.STR_DeleteCreatedDatabaseTitle"), 0);
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            if (object == NotifyDescriptor.YES_OPTION) {
                databaseServer.dropDatabase(string);
            }
        }
    }

    private static boolean checkExistingDatabase(DatabaseServer databaseServer, String string) throws DatabaseException {
        if (!databaseServer.databaseExists(string)) {
            return true;
        }
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.MSG_DatabaseAlreadyExists", (Object)string));
        message.setTitle(NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.STR_DatabaseExistsTitle"));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        return false;
    }

    private static DatabaseConnection createConnection(DatabaseServer databaseServer, String string, String string2) {
        List<DatabaseConnection> list = DatabaseUtils.findDatabaseConnections(databaseServer.getURL(string));
        if (!list.isEmpty()) {
            return list.get(0);
        }
        String string3 = string2 == null || string2.equals("") ? databaseServer.getUser() : string2;
        String string4 = databaseServer.getURL(string);
        return ConnectionManager.getDefault().showAddConnectionDialogFromEventThread(DatabaseUtils.getJDBCDriver(), string4, string3, null);
    }

    public CreateDatabasePanel(DatabaseServer databaseServer) {
        this.server = databaseServer;
        this.nbErrorForeground = UIManager.getColor("nb.errorForeground");
        if (this.nbErrorForeground == null) {
            this.nbErrorForeground = new Color(255, 0, 0);
        }
        this.initComponents();
        this.comboDatabaseName.setModel(new DatabaseComboModel());
        this.comboDatabaseName.getEditor().getEditorComponent().addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent keyEvent) {
                String string = Character.toString(keyEvent.getKeyChar()).trim();
                String string2 = Utils.isEmpty(string) ? CreateDatabasePanel.this.comboDatabaseName.getEditor().getItem().toString().trim() : string;
                CreateDatabasePanel.this.validatePanel(string2);
            }

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        this.comboUsers.setModel(new UsersComboModel(databaseServer));
        if (this.comboUsers.getItemCount() == 0) {
            this.comboUsers.setVisible(false);
            this.chkGrantAccess.setVisible(false);
        } else {
            this.comboUsers.setSelectedIndex(0);
            this.setGrantAccess(false);
        }
        this.setBackground(this.getBackground());
        this.messageLabel.setBackground(this.getBackground());
        this.messageLabel.setText(" ");
    }

    private String getDatabaseName() {
        String string = (String)this.comboDatabaseName.getSelectedItem();
        if (string != null) {
            string = string.trim();
        }
        return string;
    }

    private DatabaseUser getGrantUser() {
        return (DatabaseUser)this.comboUsers.getSelectedItem();
    }

    private void setDialogDescriptor(DialogDescriptor dialogDescriptor) {
        this.descriptor = dialogDescriptor;
        this.validatePanel("");
    }

    private void setGrantAccess(boolean bl) {
        this.chkGrantAccess.setSelected(bl);
    }

    private boolean isGrantAccess() {
        return this.chkGrantAccess.isSelected();
    }

    private DatabaseServer getServer() {
        return this.server;
    }

    private void initComponents() {
        this.messageLabel = new JLabel();
        this.comboDatabaseName = new JComboBox();
        this.jLabel1 = new JLabel();
        this.chkGrantAccess = new JCheckBox();
        this.comboUsers = new JComboBox();
        this.messageLabel.setForeground(new Color(255, 0, 51));
        Mnemonics.setLocalizedText((JLabel)this.messageLabel, (String)NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.messageLabel.text"));
        this.comboDatabaseName.setEditable(true);
        this.comboDatabaseName.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.comboDatabaseName.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                CreateDatabasePanel.this.comboDatabaseNameItemStateChanged(itemEvent);
            }
        });
        this.comboDatabaseName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateDatabasePanel.this.comboDatabaseNameActionPerformed(actionEvent);
            }
        });
        this.comboDatabaseName.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                CreateDatabasePanel.this.comboDatabaseNameFocusLost(focusEvent);
            }
        });
        this.comboDatabaseName.addInputMethodListener(new InputMethodListener(){

            public void inputMethodTextChanged(InputMethodEvent inputMethodEvent) {
                CreateDatabasePanel.this.comboDatabaseNameInputMethodTextChanged(inputMethodEvent);
            }

            public void caretPositionChanged(InputMethodEvent inputMethodEvent) {
            }
        });
        this.comboDatabaseName.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                CreateDatabasePanel.this.comboDatabaseNameKeyTyped(keyEvent);
            }

            public void keyPressed(KeyEvent keyEvent) {
                CreateDatabasePanel.this.comboDatabaseNameKeyPressed(keyEvent);
            }
        });
        this.comboDatabaseName.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                CreateDatabasePanel.this.comboDatabaseNameMouseReleased(mouseEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.jLabel1.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.chkGrantAccess, (String)NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.chkGrantAccess.text"));
        this.chkGrantAccess.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                CreateDatabasePanel.this.chkGrantAccessItemStateChanged(itemEvent);
            }
        });
        this.comboUsers.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.chkGrantAccess).add(18, 18, 18).add((Component)this.comboUsers, -2, 216, -2)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel1).add(18, 18, 18).add((Component)this.comboDatabaseName, 0, -1, Short.MAX_VALUE)).add((Component)this.messageLabel, -2, 344, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap(20, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.comboDatabaseName, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.chkGrantAccess).add((Component)this.comboUsers, -2, -1, -2)).addPreferredGap(0).add((Component)this.messageLabel).add(22, 22, 22)));
        this.messageLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.messageLabel.AccessibleContext.accessibleName"));
        this.chkGrantAccess.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.chkGrantAccess.AccessibleContext.accessibleDescription"));
    }

    private void comboDatabaseNameActionPerformed(ActionEvent actionEvent) {
    }

    private void comboDatabaseNameItemStateChanged(ItemEvent itemEvent) {
        this.validatePanel(itemEvent.getItem().toString().trim());
    }

    private void comboDatabaseNameMouseReleased(MouseEvent mouseEvent) {
    }

    private void comboDatabaseNameKeyTyped(KeyEvent keyEvent) {
    }

    private void comboDatabaseNameFocusLost(FocusEvent focusEvent) {
    }

    private void chkGrantAccessItemStateChanged(ItemEvent itemEvent) {
        if (this.isGrantAccess()) {
            this.comboUsers.setEnabled(true);
        } else {
            this.comboUsers.setEnabled(false);
        }
    }

    private void comboDatabaseNameKeyPressed(KeyEvent keyEvent) {
    }

    private void comboDatabaseNameInputMethodTextChanged(InputMethodEvent inputMethodEvent) {
    }

    private static class UsersComboModel
    implements ComboBoxModel {
        final DatabaseServer server;
        ArrayList<DatabaseUser> users = new ArrayList();
        DatabaseUser selected;

        public UsersComboModel(DatabaseServer databaseServer) {
            this.server = databaseServer;
            try {
                this.users.addAll(databaseServer.getUsers());
                DatabaseUser databaseUser = null;
                for (DatabaseUser databaseUser2 : this.users) {
                    if (databaseUser2.getUser() == null || !databaseUser2.getUser().equals("root")) continue;
                    databaseUser = databaseUser2;
                    break;
                }
                if (databaseUser != null) {
                    this.users.remove(databaseUser);
                }
            }
            catch (DatabaseException databaseException) {
                LOGGER.log(Level.INFO, null, databaseException);
                this.users.clear();
            }
        }

        public void setSelectedItem(Object object) {
            this.selected = (DatabaseUser)object;
        }

        public Object getSelectedItem() {
            return this.selected;
        }

        public int getSize() {
            return this.users.size();
        }

        public Object getElementAt(int n) {
            return this.users.get(n);
        }

        public void addListDataListener(ListDataListener listDataListener) {
        }

        public void removeListDataListener(ListDataListener listDataListener) {
        }
    }

    private static class DatabaseComboModel
    implements ComboBoxModel {
        static final List<String> SAMPLES = SampleManager.getSampleNames();
        static final String samplePrefix = NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.STR_SampleDatabase") + ": ";
        String selected = null;
        final ArrayList<ListDataListener> listeners = new ArrayList();

        private DatabaseComboModel() {
        }

        public void setSelectedItem(Object object) {
            this.selected = (String)object;
        }

        public Object getSelectedItem() {
            if (this.selected != null && this.selected.startsWith(samplePrefix)) {
                return this.selected.replace(samplePrefix, "");
            }
            if (this.selected != null) {
                return this.selected;
            }
            return "";
        }

        public int getSize() {
            return SAMPLES.size();
        }

        public Object getElementAt(int n) {
            if (n < 0) {
                return null;
            }
            return samplePrefix + SAMPLES.get(n).toString();
        }

        public void addListDataListener(ListDataListener listDataListener) {
        }

        public void removeListDataListener(ListDataListener listDataListener) {
        }
    }
}

