/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.db.api.explorer.NodeProvider;
import org.netbeans.modules.db.mysql.DatabaseServer;
import org.netbeans.modules.db.mysql.DatabaseServerManager;
import org.netbeans.modules.db.mysql.impl.MySQLOptions;
import org.netbeans.modules.db.mysql.nodes.ServerNode;
import org.openide.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerNodeProvider
implements NodeProvider {
    private static volatile ServerNodeProvider DEFAULT;
    private static final MySQLOptions options;
    private final ArrayList<Node> nodes = new ArrayList();
    private static final ArrayList<Node> emptyNodeList;
    private final CopyOnWriteArrayList<ChangeListener> listeners = new CopyOnWriteArrayList();

    public static synchronized ServerNodeProvider getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new ServerNodeProvider();
        }
        return DEFAULT;
    }

    public List<Node> getNodes() {
        this.checkNodeArray();
        if (options.isProviderRegistered()) {
            return this.nodes;
        }
        DatabaseServerManager.getDatabaseServer().disconnect();
        return emptyNodeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNodeArray() {
        if (this.nodes.size() == 0) {
            ServerNode serverNode = ServerNode.create(DatabaseServerManager.getDatabaseServer());
            ServerNodeProvider serverNodeProvider = this;
            synchronized (serverNodeProvider) {
                if (this.nodes.size() == 0) {
                    this.nodes.add((Node)serverNode);
                }
            }
        }
    }

    public void setRegistered(boolean bl) {
        boolean bl2 = this.isRegistered();
        if (bl != bl2) {
            DatabaseServer databaseServer = DatabaseServerManager.getDatabaseServer();
            options.setProviderRegistered(bl);
            if (!bl) {
                databaseServer.disconnect();
            } else {
                databaseServer.reconnect(true, true);
            }
            this.notifyChange();
        }
    }

    public synchronized boolean isRegistered() {
        return options.isProviderRegistered();
    }

    void notifyChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    static {
        options = MySQLOptions.getDefault();
        emptyNodeList = new ArrayList();
    }
}

