/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.impl;

import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.db.mysql.Database;
import org.netbeans.modules.db.mysql.DatabaseServer;
import org.netbeans.modules.db.mysql.DatabaseUser;
import org.netbeans.modules.db.mysql.impl.ConnectionProcessor;
import org.netbeans.modules.db.mysql.impl.MySQLOptions;
import org.netbeans.modules.db.mysql.ui.PropertiesDialog;
import org.netbeans.modules.db.mysql.util.DatabaseUtils;
import org.netbeans.modules.db.mysql.util.ExecSupport;
import org.netbeans.modules.db.mysql.util.Utils;
import org.openide.awt.HtmlBrowser;
import org.openide.execution.NbProcessDescriptor;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySQLDatabaseServer
implements DatabaseServer {
    private String displayName;
    private RequestProcessor.Task refreshTask;
    private static final Logger LOGGER = Logger.getLogger(DatabaseServer.class.getName());
    private static DatabaseServer DEFAULT;
    private static final MySQLOptions OPTIONS;
    private static final String GET_DATABASES_SQL = "SHOW DATABASES";
    private static final String GET_USERS_SQL = "SELECT DISTINCT user, host FROM mysql.user";
    private static final String CREATE_DATABASE_SQL = "CREATE DATABASE ";
    private static final String DROP_DATABASE_SQL = "DROP DATABASE ";
    private static final String GRANT_ALL_SQL_1 = "GRANT ALL ON ";
    private static final String GRANT_ALL_SQL_2 = ".* TO ?@?";
    final LinkedBlockingQueue<Runnable> commandQueue = new LinkedBlockingQueue();
    final ConnectionProcessor connProcessor = new ConnectionProcessor(this.commandQueue);
    final ArrayList<ChangeListener> listeners = new ArrayList();
    private String adminPassword;
    private volatile HashMap<String, Database> databases = new HashMap();

    public static synchronized DatabaseServer getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new MySQLDatabaseServer();
        }
        return DEFAULT;
    }

    private MySQLDatabaseServer() {
        this.updateDisplayName();
        RequestProcessor.getDefault().post((Runnable)this.connProcessor);
    }

    @Override
    public String getHost() {
        return Utils.isEmpty(OPTIONS.getHost()) ? MySQLOptions.getDefaultHost() : OPTIONS.getHost();
    }

    @Override
    public void setHost(String string) {
        OPTIONS.setHost(string);
    }

    @Override
    public String getPort() {
        String string = OPTIONS.getPort();
        if (Utils.isEmpty(string)) {
            return MySQLOptions.getDefaultPort();
        }
        return string;
    }

    @Override
    public void setPort(String string) {
        OPTIONS.setPort(string);
    }

    @Override
    public String getUser() {
        String string = OPTIONS.getAdminUser();
        if (Utils.isEmpty(string)) {
            return MySQLOptions.getDefaultAdminUser();
        }
        return string;
    }

    @Override
    public void setUser(String string) {
        OPTIONS.setAdminUser(string);
    }

    @Override
    public synchronized String getPassword() {
        if (this.adminPassword != null) {
            return this.adminPassword;
        }
        return OPTIONS.getAdminPassword();
    }

    @Override
    public synchronized void setPassword(String string) {
        String string2 = this.adminPassword = string == null ? "" : string;
        if (this.isSavePassword()) {
            OPTIONS.setAdminPassword(string);
        }
    }

    @Override
    public boolean isSavePassword() {
        return OPTIONS.isSavePassword();
    }

    @Override
    public void setSavePassword(boolean bl) {
        OPTIONS.setSavePassword(bl);
        OPTIONS.setAdminPassword(this.getPassword());
    }

    @Override
    public String getAdminPath() {
        return OPTIONS.getAdminPath();
    }

    @Override
    public void setAdminPath(String string) {
        OPTIONS.setAdminPath(string);
    }

    @Override
    public String getStartPath() {
        return OPTIONS.getStartPath();
    }

    @Override
    public void setStartPath(String string) {
        OPTIONS.setStartPath(string);
    }

    @Override
    public String getStopPath() {
        return OPTIONS.getStopPath();
    }

    @Override
    public void setStopPath(String string) {
        OPTIONS.setStopPath(string);
    }

    @Override
    public String getStopArgs() {
        return OPTIONS.getStopArgs();
    }

    @Override
    public void setStopArgs(String string) {
        OPTIONS.setStopArgs(string);
    }

    @Override
    public String getStartArgs() {
        return OPTIONS.getStartArgs();
    }

    @Override
    public void setStartArgs(String string) {
        OPTIONS.setStartArgs(string);
    }

    @Override
    public String getAdminArgs() {
        return OPTIONS.getAdminArgs();
    }

    @Override
    public void setAdminArgs(String string) {
        OPTIONS.setAdminArgs(string);
    }

    @Override
    public boolean isConnected() {
        return this.connProcessor.isConnected();
    }

    @Override
    public synchronized String getDisplayName() {
        return this.displayName;
    }

    private synchronized void setDisplayName(String string) {
        this.displayName = string;
    }

    private synchronized void updateDisplayName() {
        String string = this.isConnected() ? "LBL_ServerDisplayName" : "LBL_ServerNotConnectedDisplayName";
        this.setDisplayName(Utils.getMessage(string, this.getHostPort(), this.getUser()));
    }

    @Override
    public String getShortDescription() {
        return Utils.getMessage("LBL_ServerShortDescription", this.getHostPort(), this.getUser());
    }

    private String getHostPort() {
        String string = this.getPort();
        string = Utils.isEmpty(string) ? "" : ":" + string;
        return this.getHost() + string;
    }

    @Override
    public String getURL() {
        return DatabaseUtils.getURL(this.getHost(), this.getPort());
    }

    @Override
    public String getURL(String string) {
        return DatabaseUtils.getURL(this.getHost(), this.getPort(), string);
    }

    private void notifyChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    @Override
    public void refreshDatabaseList() {
        if (this.isConnected()) {
            final MySQLDatabaseServer mySQLDatabaseServer = this;
            this.commandQueue.offer(new DatabaseCommand(){

                public void execute() throws Exception {
                    Connection connection = MySQLDatabaseServer.this.connProcessor.getConnection();
                    PreparedStatement preparedStatement = connection.prepareStatement(MySQLDatabaseServer.GET_DATABASES_SQL);
                    ResultSet resultSet = preparedStatement.executeQuery();
                    HashMap<String, Database> hashMap = new HashMap<String, Database>();
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        hashMap.put(string, new Database(mySQLDatabaseServer, string));
                    }
                    MySQLDatabaseServer.this.setDatabases(hashMap);
                    MySQLDatabaseServer.this.notifyChange();
                }
            });
        } else {
            this.setDatabases(new HashMap<String, Database>());
            this.notifyChange();
        }
    }

    private synchronized void setDatabases(HashMap<String, Database> hashMap) {
        this.databases = hashMap;
    }

    @Override
    public synchronized Collection<Database> getDatabases() throws DatabaseException {
        return this.databases.values();
    }

    @Override
    public void reconnect() throws DatabaseException {
        try {
            this.reconnect(true, false);
        }
        catch (Throwable throwable) {
            throw new DatabaseException(throwable);
        }
    }

    private void checkNotOnDispatchThread() {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Can not call this method on the event dispatch thread");
        }
    }

    @Override
    public void disconnectSync() {
        this.disconnect(false);
    }

    @Override
    public void disconnect() {
        this.disconnect(true);
    }

    private void disconnect(boolean bl) {
        ArrayBlockingQueue arrayBlockingQueue = null;
        if (!bl) {
            this.checkNotOnDispatchThread();
            arrayBlockingQueue = new ArrayBlockingQueue(1);
        }
        DatabaseCommand databaseCommand = new DatabaseCommand(arrayBlockingQueue){

            public void execute() throws Exception {
                Connection connection = MySQLDatabaseServer.this.connProcessor.getConnection();
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {
                        LOGGER.log(Level.FINE, null, sQLException);
                    }
                }
                MySQLDatabaseServer.this.connProcessor.setConnection(null);
                MySQLDatabaseServer.this.updateDisplayName();
                MySQLDatabaseServer.this.refreshDatabaseList();
            }
        };
        this.commandQueue.offer(databaseCommand);
        if (!bl) {
            try {
                arrayBlockingQueue.take();
                if (databaseCommand.getException() != null) {
                    throw new RuntimeException(databaseCommand.getException());
                }
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
    }

    @Override
    public void reconnectAsync() {
        this.reconnect(true, true);
    }

    @Override
    public void reconnect(final boolean bl, boolean bl2) {
        ArrayBlockingQueue arrayBlockingQueue = null;
        if (!bl2) {
            this.checkNotOnDispatchThread();
            arrayBlockingQueue = new ArrayBlockingQueue(1);
        }
        DatabaseCommand databaseCommand = new DatabaseCommand(arrayBlockingQueue){

            public void execute() throws Exception {
                Connection connection = MySQLDatabaseServer.this.connProcessor.getConnection();
                if (connection != null && !connection.isClosed()) {
                    connection.close();
                }
                MySQLDatabaseServer.this.connProcessor.setConnection(null);
                ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)Utils.getMessage("MSG_ConnectingToServer", new Object[0]));
                progressHandle.start();
                progressHandle.switchToIndeterminate();
                while (true) {
                    try {
                        connection = DatabaseUtils.connect(MySQLDatabaseServer.this.getURL(), MySQLDatabaseServer.this.getUser(), MySQLDatabaseServer.this.getPassword());
                        MySQLDatabaseServer.this.connProcessor.setConnection(connection);
                    }
                    catch (DatabaseException databaseException) {
                        String string = Utils.getMessage("MSG_UnableToConnect", new Object[0]);
                        if (!bl) {
                            boolean bl2;
                            if (bl2 = MySQLDatabaseServer.this.postPropertiesDialog(string, databaseException)) continue;
                            break;
                        }
                        progressHandle.finish();
                        throw databaseException;
                    }
                    break;
                }
                progressHandle.finish();
                MySQLDatabaseServer.this.updateDisplayName();
                MySQLDatabaseServer.this.refreshDatabaseList();
            }
        };
        this.commandQueue.offer(databaseCommand);
        if (!bl2) {
            try {
                arrayBlockingQueue.take();
                if (databaseCommand.getException() != null) {
                    throw new RuntimeException(databaseCommand.getException());
                }
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
    }

    private boolean postPropertiesDialog(final String string, final DatabaseException databaseException) {
        final MySQLDatabaseServer mySQLDatabaseServer = this;
        Boolean bl = (Boolean)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            public Boolean run() {
                Utils.displayError(string, (Exception)((Object)databaseException));
                PropertiesDialog propertiesDialog = new PropertiesDialog(mySQLDatabaseServer);
                return propertiesDialog.displayDialog();
            }
        });
        return bl;
    }

    @Override
    public boolean databaseExists(String string) throws DatabaseException {
        return this.databases.containsKey(string);
    }

    @Override
    public void createDatabase(final String string) {
        this.commandQueue.offer(new DatabaseCommand(){

            public void execute() throws Exception {
                Connection connection = MySQLDatabaseServer.this.connProcessor.getConnection();
                connection.prepareStatement(MySQLDatabaseServer.CREATE_DATABASE_SQL + string).executeUpdate();
                MySQLDatabaseServer.this.refreshDatabaseList();
            }
        });
    }

    @Override
    public void dropDatabase(final String string, final boolean bl) {
        this.commandQueue.offer(new DatabaseCommand(){

            public void execute() throws Exception {
                Connection connection = MySQLDatabaseServer.this.connProcessor.getConnection();
                connection.prepareStatement(MySQLDatabaseServer.DROP_DATABASE_SQL + string).executeUpdate();
                if (bl) {
                    DatabaseConnection[] databaseConnectionArray;
                    for (DatabaseConnection databaseConnection : databaseConnectionArray = ConnectionManager.getDefault().getConnections()) {
                        if (!databaseConnection.getDriverClass().equals(MySQLOptions.getDriverClass()) || !databaseConnection.getDatabaseURL().contains("/" + string)) continue;
                        ConnectionManager.getDefault().removeConnection(databaseConnection);
                    }
                }
                MySQLDatabaseServer.this.refreshDatabaseList();
            }
        });
    }

    @Override
    public void dropDatabase(String string) {
        this.dropDatabase(string, true);
    }

    @Override
    public List<DatabaseUser> getUsers() throws DatabaseException {
        final ArrayList<DatabaseUser> arrayList = new ArrayList<DatabaseUser>();
        if (!this.isConnected()) {
            return arrayList;
        }
        ArrayBlockingQueue arrayBlockingQueue = new ArrayBlockingQueue(1);
        DatabaseCommand databaseCommand = new DatabaseCommand(arrayBlockingQueue){

            public void execute() throws Exception {
                ResultSet resultSet = MySQLDatabaseServer.this.connProcessor.getConnection().prepareStatement(MySQLDatabaseServer.GET_USERS_SQL).executeQuery();
                while (resultSet.next()) {
                    String string = resultSet.getString(1).trim();
                    String string2 = resultSet.getString(2).trim();
                    arrayList.add(new DatabaseUser(string, string2));
                }
                resultSet.close();
            }
        };
        this.commandQueue.offer(databaseCommand);
        try {
            arrayBlockingQueue.take();
            if (databaseCommand.getException() != null) {
                throw new DatabaseException(databaseCommand.getException());
            }
        }
        catch (InterruptedException interruptedException) {
            throw new DatabaseException((Throwable)interruptedException);
        }
        return arrayList;
    }

    @Override
    public void grantFullDatabaseRights(final String string, final DatabaseUser databaseUser) {
        this.commandQueue.offer(new DatabaseCommand(){

            public void execute() throws Exception {
                PreparedStatement preparedStatement = MySQLDatabaseServer.this.connProcessor.getConnection().prepareStatement(MySQLDatabaseServer.GRANT_ALL_SQL_1 + string + MySQLDatabaseServer.GRANT_ALL_SQL_2);
                preparedStatement.setString(1, databaseUser.getUser());
                preparedStatement.setString(2, databaseUser.getHost());
                preparedStatement.executeUpdate();
            }
        });
    }

    @Override
    public void start() throws DatabaseException {
        if (!Utils.isValidExecutable(this.getStopPath(), false)) {
            throw new DatabaseException(Utils.getMessage("MSG_InvalidStartCommand", new Object[0]));
        }
        try {
            this.runProcess(this.getStartPath(), this.getStartArgs(), true, Utils.getMessage("LBL_StartOutputTab", new Object[0]));
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    try {
                        MySQLDatabaseServer.this.reconnect();
                    }
                    catch (DatabaseException databaseException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (Exception exception) {
            throw new DatabaseException((Throwable)exception);
        }
    }

    @Override
    public void stop() throws DatabaseException {
        if (!Utils.isValidExecutable(this.getStopPath(), false)) {
            throw new DatabaseException(Utils.getMessage("MSG_InvalidStopCommand", new Object[0]));
        }
        try {
            this.runProcess(this.getStopPath(), this.getStopArgs(), true, Utils.getMessage("LBL_AdminOutputTab", new Object[0]));
        }
        catch (Exception exception) {
            throw new DatabaseException((Throwable)exception);
        }
        this.disconnect();
    }

    @Override
    public void startAdmin() throws DatabaseException {
        String string = this.getAdminPath();
        if (string == null || string.length() == 0) {
            throw new DatabaseException(NbBundle.getMessage(DatabaseServer.class, (String)"MSG_AdminCommandNotSet"));
        }
        if (Utils.isValidURL(string, false)) {
            this.launchBrowser(string);
        } else if (Utils.isValidExecutable(string, false)) {
            this.runProcess(string, this.getAdminArgs(), true, Utils.getMessage("LBL_AdminOutputTab", new Object[0]));
        } else {
            throw new DatabaseException(NbBundle.getMessage(DatabaseServer.class, (String)"MSG_InvalidAdminCommand", (Object)string));
        }
    }

    private void runProcess(String string, String string2, boolean bl, String string3) throws DatabaseException {
        if (Utilities.isMac() && string.endsWith(".app")) {
            string2 = "\"" + string + "\" " + string2;
            string = "/usr/bin/open";
        }
        try {
            NbProcessDescriptor nbProcessDescriptor = new NbProcessDescriptor(string, string2);
            Process process = nbProcessDescriptor.exec();
            if (bl) {
                new ExecSupport().displayProcessOutputs(process, string3);
            }
        }
        catch (Exception exception) {
            throw new DatabaseException((Throwable)exception);
        }
    }

    private void launchBrowser(String string) throws DatabaseException {
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL(string));
        }
        catch (Exception exception) {
            throw new DatabaseException((Throwable)exception);
        }
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    static {
        OPTIONS = MySQLOptions.getDefault();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class DatabaseCommand
    implements Runnable {
        private Throwable throwable;
        private final BlockingQueue<Runnable> outqueue;

        public DatabaseCommand(BlockingQueue<Runnable> blockingQueue) {
            this.outqueue = blockingQueue;
        }

        public DatabaseCommand() {
            this(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.execute();
            }
            catch (Exception exception) {
                if (this.outqueue != null) {
                    this.throwable = exception;
                } else {
                    LOGGER.log(Level.INFO, null, exception);
                }
            }
            finally {
                if (this.outqueue != null) {
                    this.outqueue.offer(this);
                }
            }
        }

        public abstract void execute() throws Exception;

        public Throwable getException() {
            return this.throwable;
        }
    }
}

