/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.impl;

import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.db.explorer.ConnectionListener;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.db.mysql.impl.DbExplorerConnectionListener;
import org.netbeans.modules.db.mysql.impl.Installation;
import org.netbeans.modules.db.mysql.impl.InstallationManager;
import org.netbeans.modules.db.mysql.impl.MySQLOptions;
import org.netbeans.modules.db.mysql.impl.ServerNodeProvider;
import org.netbeans.modules.db.mysql.util.DatabaseUtils;
import org.netbeans.modules.db.mysql.util.Utils;
import org.openide.modules.ModuleInstall;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class ModuleInstaller
extends ModuleInstall {
    private static final Logger LOGGER = Logger.getLogger(ModuleInstaller.class.getName());
    private static final MySQLOptions options = MySQLOptions.getDefault();

    public void restored() {
        if (options.isProviderRemoved() || options.isConnectionRegistered() && options.isProviderRegistered()) {
            return;
        }
        WindowManager.getDefault().invokeWhenUIReady((Runnable)new RegisterMySQL());
    }

    private static final class RegisterMySQL
    implements Runnable {
        private JDBCDriver jdbcDriver;

        private RegisterMySQL() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                RequestProcessor.getDefault().post((Runnable)this);
                return;
            }
            ProgressHandle progressHandle = ProgressHandleFactory.createSystemHandle((String)Utils.getMessage("MSG_RegisterMySQL", new Object[0]));
            progressHandle.start();
            try {
                this.findAndRegisterMySQL();
            }
            finally {
                progressHandle.finish();
            }
        }

        private void findAndRegisterMySQL() {
            this.jdbcDriver = DatabaseUtils.getJDBCDriver();
            if (this.jdbcDriver == null) {
                return;
            }
            this.registerConnectionListener();
            this.findAndRegisterInstallation();
        }

        private void registerConnectionListener() {
            ConnectionManager.getDefault().addConnectionListener((ConnectionListener)new DbExplorerConnectionListener());
        }

        private void findAndRegisterInstallation() {
            Installation installation = InstallationManager.detectInstallation();
            if (installation == null) {
                return;
            }
            String[] stringArray = installation.getAdminCommand();
            if (Utils.isValidExecutable(stringArray[0], true) || Utils.isValidURL(stringArray[0], true)) {
                options.setAdminPath(stringArray[0]);
                options.setAdminArgs(stringArray[1]);
            }
            if (Utils.isValidExecutable((stringArray = installation.getStartCommand())[0], true)) {
                options.setStartPath(stringArray[0]);
                options.setStartArgs(stringArray[1]);
            }
            if (Utils.isValidExecutable((stringArray = installation.getStopCommand())[0], true)) {
                options.setStopPath(stringArray[0]);
                options.setStopArgs(stringArray[1]);
            }
            options.setPort(installation.getDefaultPort());
            ServerNodeProvider.getDefault().setRegistered(true);
        }
    }
}

