/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.html.HTMLCompletionResultItemPaintComponent;
import org.netbeans.editor.ext.html.HTMLSettingsDefaults;
import org.netbeans.editor.ext.html.HTMLSyntaxSupport;
import org.netbeans.editor.ext.html.SyntaxElement;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.editor.ext.html.javadoc.HelpManager;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLCompletionQuery {
    private static final String SCRIPT_TAG_NAME = "SCRIPT";
    private static final String STYLE_TAG_NAME = "STYLE";
    private static boolean lowerCase;
    private static final HTMLCompletionQuery DEFAULT;

    public static HTMLCompletionQuery getDefault() {
        return DEFAULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CompletionItem> query(JTextComponent jTextComponent, int n) {
        Class clazz = Utilities.getKitClass((JTextComponent)jTextComponent);
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        if (clazz != null) {
            lowerCase = SettingsUtil.getBoolean((Class)clazz, (String)"completion-lower-case", (Boolean)HTMLSettingsDefaults.defaultCompletionLowerCase);
        }
        if (baseDocument.getLength() == 0) {
            return null;
        }
        HTMLSyntaxSupport hTMLSyntaxSupport = HTMLSyntaxSupport.get((Document)baseDocument);
        if (hTMLSyntaxSupport == null) {
            return null;
        }
        DTD dTD = hTMLSyntaxSupport.getDTD();
        if (dTD == null) {
            return null;
        }
        baseDocument.readLock();
        try {
            Object object;
            int n2;
            boolean bl;
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence(HTMLTokenId.language());
            if (tokenSequence == null) {
                tokenSequence = tokenHierarchy.tokenSequence();
                tokenSequence.move(n);
                if (tokenSequence.moveNext() || tokenSequence.movePrevious()) {
                    tokenSequence = tokenSequence.embedded(HTMLTokenId.language());
                } else {
                    List<CompletionItem> list = null;
                    return list;
                }
            }
            if (tokenSequence == null) {
                List<CompletionItem> list = null;
                return list;
            }
            tokenSequence.move(n);
            if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                List<CompletionItem> list = null;
                return list;
            }
            Token token = tokenSequence.token();
            boolean bl2 = bl = tokenSequence.offset() < n;
            if (!bl) {
                if (tokenSequence.movePrevious()) {
                    token = tokenSequence.token();
                } else {
                    List<CompletionItem> list = null;
                    return list;
                }
            }
            Token token2 = token;
            while (token2.id() != HTMLTokenId.TAG_OPEN && token2.id() != HTMLTokenId.TAG_CLOSE && tokenSequence.movePrevious()) {
                token2 = tokenSequence.token();
            }
            if (tokenSequence.index() > 0) {
                String string = ((Object)token2.text()).toString();
                for (n2 = 0; n2 < string.length(); ++n2) {
                    char c = string.charAt(n2);
                    if (!Character.isLetter(c)) continue;
                    lowerCase = !Character.isUpperCase(string.charAt(n2));
                    break;
                }
            }
            tokenSequence.move(token.offset(tokenHierarchy));
            int n3 = token.offset(tokenHierarchy);
            n2 = n - n3;
            String string = ((Object)token.text()).toString();
            if (n2 < string.length()) {
                string = string.substring(0, n - n3);
            }
            TokenId tokenId = token.id();
            List<CompletionItem> list = null;
            int n4 = 1;
            if ((tokenId == HTMLTokenId.TEXT || tokenId == HTMLTokenId.VALUE) && string.endsWith("&")) {
                list = this.translateCharRefs(n - n4, n4, dTD.getCharRefList(""));
            } else if (tokenId == HTMLTokenId.CHARACTER) {
                if (bl || !string.endsWith(";")) {
                    n4 = n - n3;
                    list = this.translateCharRefs(n - n4, n4, dTD.getCharRefList(string.substring(1)));
                }
            } else if (tokenId == HTMLTokenId.TAG_OPEN) {
                String string2;
                n4 = n - n3 + 1;
                list = this.translateTags(n3 - 1, n4, dTD.getElementList(string));
                if (list.size() == 1 && string.equals(string2 = ((TagItem)(object = (TagItem)list.get(0))).getItemText())) {
                    tokenSequence.move(n);
                    tokenSequence.moveNext();
                    Token token3 = tokenSequence.token();
                    if (token3.id() == HTMLTokenId.WS && tokenSequence.moveNext() && ((token3 = tokenSequence.token()).id() == HTMLTokenId.TAG_CLOSE || token3.id() == HTMLTokenId.ARGUMENT)) {
                        list = null;
                    }
                }
            } else if (tokenId != HTMLTokenId.BLOCK_COMMENT && string.endsWith("<")) {
                list = this.translateTags(n - n4, n4, dTD.getElementList(""));
            } else if (tokenId == HTMLTokenId.TEXT && string.endsWith("</")) {
                n4 = 2;
                list = hTMLSyntaxSupport.getPossibleEndTags(n, "");
            } else if (tokenId == HTMLTokenId.TAG_OPEN_SYMBOL && string.endsWith("</")) {
                n4 = 2;
                list = hTMLSyntaxSupport.getPossibleEndTags(n, "");
            } else if (tokenId == HTMLTokenId.TAG_CLOSE) {
                n4 = n - n3;
                list = hTMLSyntaxSupport.getPossibleEndTags(n, string);
            } else if (tokenId == HTMLTokenId.TAG_CLOSE_SYMBOL) {
                list = hTMLSyntaxSupport.getAutocompletedEndTag(n);
            } else if (tokenId == HTMLTokenId.WS || tokenId == HTMLTokenId.ARGUMENT) {
                object = null;
                try {
                    object = hTMLSyntaxSupport.getElementChain(n);
                    if (object == null || ((SyntaxElement)object).getType() == 4 && ">".equals(((SyntaxElement)object).getText())) {
                        object = hTMLSyntaxSupport.getElementChain(n - 1);
                    }
                }
                catch (BadLocationException badLocationException) {
                    List<CompletionItem> list2 = null;
                    baseDocument.readUnlock();
                    return list2;
                }
                if (object == null) {
                    List<CompletionItem> list3 = null;
                    return list3;
                }
                if (((SyntaxElement)object).getElementOffset() == n) {
                    object = hTMLSyntaxSupport.getElementChain(n - 1);
                }
                if (((SyntaxElement)object).getType() == 4) {
                    Object object2;
                    SyntaxElement.Tag tag = (SyntaxElement.Tag)object;
                    String string3 = tag.getName().toUpperCase();
                    DTD.Element element = dTD.getElement(string3);
                    if (element == null) {
                        List<CompletionItem> list4 = null;
                        return list4;
                    }
                    String string4 = tokenId == HTMLTokenId.ARGUMENT ? string : "";
                    n4 = string4.length();
                    List list5 = element.getAttributeList(string4);
                    List<SyntaxElement.TagAttribute> list6 = tag.getAttributes();
                    ArrayList<String> arrayList = new ArrayList<String>(list6.size());
                    Object object3 = list6.iterator();
                    while (object3.hasNext()) {
                        object2 = (SyntaxElement.TagAttribute)object3.next();
                        arrayList.add(((SyntaxElement.TagAttribute)object2).getName());
                    }
                    Object object4 = object3 = token == null ? null : ((Object)token.text()).toString();
                    if (object3 == null) {
                        object3 = "";
                    }
                    object2 = new ArrayList();
                    for (DTD.Attribute attribute : list5) {
                        String string5 = attribute.getName();
                        if (!string5.equals(string4) && (arrayList.contains(string5.toUpperCase()) || arrayList.contains(string5.toLowerCase())) && (!((String)object3).equals(string5) || string4.length() <= 0)) continue;
                        object2.add(attribute);
                    }
                    list = this.translateAttribs(n - n4, n4, (List<DTD.Attribute>)object2, element);
                }
            } else if (tokenId == HTMLTokenId.VALUE || tokenId == HTMLTokenId.OPERATOR || tokenId == HTMLTokenId.WS) {
                if (tokenId == HTMLTokenId.WS) {
                    tokenSequence.move(token.offset(tokenHierarchy));
                    tokenSequence.movePrevious();
                    object = tokenSequence.token();
                    if (object.id() != HTMLTokenId.OPERATOR) {
                        List<CompletionItem> list7 = null;
                        return list7;
                    }
                }
                object = null;
                try {
                    object = hTMLSyntaxSupport.getElementChain(n);
                }
                catch (BadLocationException badLocationException) {
                    List<CompletionItem> list8 = null;
                    baseDocument.readUnlock();
                    return list8;
                }
                if (object == null) {
                    List<CompletionItem> list9 = null;
                    return list9;
                }
                if (((SyntaxElement)object).getType() == 2 && (object = ((SyntaxElement)object).getPrevious()) == null) {
                    List<CompletionItem> list10 = null;
                    return list10;
                }
                if (((SyntaxElement)object).getType() == 4) {
                    SyntaxElement.Tag tag = (SyntaxElement.Tag)object;
                    String string6 = tag.getName().toUpperCase();
                    DTD.Element element = dTD.getElement(string6);
                    if (element == null) {
                        List<CompletionItem> list11 = null;
                        return list11;
                    }
                    tokenSequence.move(token.offset(tokenHierarchy));
                    tokenSequence.moveNext();
                    Token token4 = tokenSequence.token();
                    while (token4.id() != HTMLTokenId.ARGUMENT && tokenSequence.movePrevious()) {
                        token4 = tokenSequence.token();
                    }
                    if (token4.id() != HTMLTokenId.ARGUMENT) {
                        List<CompletionItem> list12 = null;
                        return list12;
                    }
                    String string7 = ((Object)token4.text()).toString().toLowerCase();
                    DTD.Attribute attribute = element.getAttribute(string7);
                    if (attribute == null || attribute.getType() != 1) {
                        List<CompletionItem> list13 = null;
                        return list13;
                    }
                    if (tokenId != HTMLTokenId.VALUE) {
                        n4 = 0;
                        list = this.translateValues(n - n4, n4, attribute.getValueList(""));
                    } else {
                        n4 = n - n3;
                        String string8 = null;
                        if (string != null && string.length() > 0) {
                            if (string.substring(0, 1).equals("'")) {
                                string8 = "'";
                            }
                            if (string.substring(0, 1).equals("\"")) {
                                string8 = "\"";
                            }
                        }
                        list = this.translateValues(n - n4, n4, attribute.getValueList(string8 == null ? string : string.substring(1)), string8);
                    }
                }
            } else if (tokenId == HTMLTokenId.SCRIPT) {
                list = this.addEndTag(SCRIPT_TAG_NAME, string, n);
            } else if (tokenId == HTMLTokenId.STYLE) {
                list = this.addEndTag(STYLE_TAG_NAME, string, n);
            }
            object = list;
            return object;
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
        }
        finally {
            baseDocument.readUnlock();
        }
        return null;
    }

    private List<CompletionItem> addEndTag(String string, String string2, int n) {
        int n2 = this.getLastCommonCharIndex("</" + string + ">", string2.toUpperCase().trim());
        if (n2 == -1) {
            n2 = 0;
        }
        if (n2 == string2.trim().length()) {
            ArrayList<CompletionItem> arrayList = new ArrayList<CompletionItem>(1);
            arrayList.add(new EndTagItem(lowerCase ? string.toLowerCase() : string, n - n2, n2));
            return arrayList;
        }
        return null;
    }

    private int getLastCommonCharIndex(String string, String string2) {
        int n;
        for (n = 0; n < string.length() && n < string2.length(); ++n) {
            if (string.charAt(n) == string2.charAt(n)) continue;
            --n;
            break;
        }
        return n;
    }

    List<CompletionItem> translateCharRefs(int n, int n2, List list) {
        ArrayList<CompletionItem> arrayList = new ArrayList<CompletionItem>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = ((DTD.CharRef)iterator.next()).getName();
            arrayList.add(new CharRefItem(string, n, n2, string));
        }
        return arrayList;
    }

    List<CompletionItem> translateTags(int n, int n2, List list) {
        ArrayList<CompletionItem> arrayList = new ArrayList<CompletionItem>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = ((DTD.Element)iterator.next()).getName();
            arrayList.add(new TagItem(string, n, n2, string));
        }
        return arrayList;
    }

    List<CompletionItem> translateAttribs(int n, int n2, List<DTD.Attribute> list, DTD.Element element) {
        ArrayList<CompletionItem> arrayList = new ArrayList<CompletionItem>(list.size());
        String string = element.getName() + "#";
        for (DTD.Attribute attribute : list) {
            String string2 = attribute.getName();
            switch (attribute.getType()) {
                case 0: {
                    arrayList.add(new BooleanAttribItem(string2, n, n2, attribute.isRequired(), string + string2));
                    break;
                }
                case 1: {
                    arrayList.add(new SetAttribItem(string2, n, n2, attribute.isRequired(), string + string2));
                    break;
                }
                case 2: {
                    arrayList.add(new PlainAttribItem(string2, n, n2, attribute.isRequired(), string + string2));
                }
            }
        }
        return arrayList;
    }

    List<CompletionItem> translateValues(int n, int n2, List list) {
        return this.translateValues(n, n2, list, null);
    }

    List<CompletionItem> translateValues(int n, int n2, List list, String string) {
        if (list == null) {
            return new ArrayList<CompletionItem>(0);
        }
        ArrayList<CompletionItem> arrayList = new ArrayList<CompletionItem>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(new ValueItem(((DTD.Value)iterator.next()).getName(), n, n2, string));
        }
        return arrayList;
    }

    static {
        DEFAULT = new HTMLCompletionQuery();
    }

    public static class HTMLCompletionResult
    extends CompletionQuery.DefaultResult {
        private int substituteOffset;

        public HTMLCompletionResult(JTextComponent jTextComponent, String string, List list, int n, int n2) {
            super(jTextComponent, string, list, n, n2);
            this.substituteOffset = n - n2;
        }

        public int getSubstituteOffset() {
            return this.substituteOffset;
        }
    }

    public static class DocItem
    implements CompletionDocumentation {
        private String name;

        public DocItem(HTMLResultItem hTMLResultItem) {
            this(hTMLResultItem.getHelpID());
        }

        public DocItem(String string) {
            this.name = string;
        }

        public String getText() {
            String string = HelpManager.getDefault().getHelp(this.name);
            return string;
        }

        public URL getURL() {
            return HelpManager.getDefault().getHelpURL(this.name);
        }

        public CompletionDocumentation resolveLink(String string) {
            String string2 = HelpManager.getDefault().findHelpItem(this.name).getFile();
            return new LinkDocItem(HelpManager.getDefault().getRelativeURL(HelpManager.getDefault().getHelpURL(this.name), string));
        }

        public Action getGotoSourceAction() {
            return null;
        }
    }

    static class LinkDocItem
    implements CompletionDocumentation {
        private URL url;

        public LinkDocItem(URL uRL) {
            this.url = uRL;
        }

        public String getText() {
            return null;
        }

        public URL getURL() {
            return this.url;
        }

        public CompletionDocumentation resolveLink(String string) {
            return new LinkDocItem(HelpManager.getDefault().getRelativeURL(this.url, string));
        }

        public Action getGotoSourceAction() {
            return null;
        }
    }

    static class DocQuery
    extends AsyncCompletionQuery {
        private HTMLResultItem item;

        DocQuery(HTMLResultItem hTMLResultItem) {
            this.item = hTMLResultItem;
        }

        protected void query(CompletionResultSet completionResultSet, Document document, int n) {
            if (this.item != null && this.item.getHelpID() != null && HelpManager.getDefault().findHelpItem(this.item.getHelpID()) != null) {
                completionResultSet.setDocumentation((CompletionDocumentation)new DocItem(this.item));
            }
            completionResultSet.finish();
        }
    }

    private static class ValueItem
    extends HTMLResultItem {
        private String quotationChar = null;

        public ValueItem(String string, int n, int n2, String string2) {
            this(string, n, n2);
            this.quotationChar = string2;
        }

        public ValueItem(String string, int n, int n2) {
            super(string, n, n2);
        }

        public CharSequence getInsertPrefix() {
            if (this.quotationChar == null) {
                return super.getInsertPrefix();
            }
            return this.quotationChar + super.getInsertPrefix();
        }

        Color getPaintColor() {
            return Color.magenta;
        }

        public boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
            String string;
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            boolean bl2 = false;
            try {
                string = baseDocument.getText(jTextComponent.getCaretPosition(), 1);
                bl2 = "\"".equals(string);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            string = this.quotationChar == null ? this.baseText : this.quotationChar + this.baseText + (bl2 ? "" : this.quotationChar);
            this.replaceText(jTextComponent, string);
            return !bl;
        }
    }

    private static class PlainAttribItem
    extends HTMLResultItem {
        boolean required;

        public PlainAttribItem(String string, int n, int n2, boolean bl) {
            super(string, n, n2);
            this.required = bl;
        }

        public PlainAttribItem(String string, int n, int n2, boolean bl, String string2) {
            super(string, n, n2, string2);
            this.required = bl;
        }

        Color getPaintColor() {
            return this.required ? Color.red : Color.green.darker();
        }

        public boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
            this.replaceText(jTextComponent, this.baseText + "=\"\"");
            Caret caret = jTextComponent.getCaret();
            caret.setDot(caret.getDot() - 1);
            return false;
        }
    }

    private static class BooleanAttribItem
    extends HTMLResultItem {
        boolean required;

        public BooleanAttribItem(String string, int n, int n2, boolean bl) {
            super(string, n, n2);
            this.required = bl;
        }

        public BooleanAttribItem(String string, int n, int n2, boolean bl, String string2) {
            super(string, n, n2, string2);
            this.required = bl;
        }

        Color getPaintColor() {
            return this.required ? Color.red : Color.green.darker();
        }

        public boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
            this.replaceText(jTextComponent, bl ? this.baseText + " " : this.baseText);
            return false;
        }
    }

    private static class SetAttribItem
    extends HTMLResultItem {
        boolean required;

        public SetAttribItem(String string, int n, int n2, boolean bl) {
            super(string, n, n2);
            this.required = bl;
        }

        public SetAttribItem(String string, int n, int n2, boolean bl, String string2) {
            super(string, n, n2, string2);
            this.required = bl;
        }

        Color getPaintColor() {
            return this.required ? Color.red : Color.green.darker();
        }

        String getPaintText() {
            return this.baseText;
        }

        public String getItemText() {
            return this.baseText;
        }

        public boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
            this.replaceText(jTextComponent, this.baseText + "=\"\"");
            Caret caret = jTextComponent.getCaret();
            caret.setDot(caret.getDot() - 1);
            return false;
        }
    }

    private static class TagItem
    extends HTMLResultItem {
        public TagItem(String string, int n, int n2) {
            super(string, n, n2);
        }

        public TagItem(String string, int n, int n2, String string2) {
            super(string, n, n2, string2);
        }

        public boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
            this.replaceText(jTextComponent, "<" + this.baseText + (bl ? " >" : ">"));
            if (bl) {
                Caret caret = jTextComponent.getCaret();
                caret.setDot(caret.getDot() - 1);
            }
            Completion.get().showCompletion();
            return !bl;
        }

        Color getPaintColor() {
            return Color.blue;
        }

        public String getItemText() {
            return "<" + this.baseText + ">";
        }
    }

    private static class CharRefItem
    extends HTMLResultItem {
        public CharRefItem(String string, int n, int n2) {
            super(string, n, n2);
            this.baseText = string;
        }

        public CharRefItem(String string, int n, int n2, String string2) {
            super(string, n, n2, string2);
            this.baseText = string;
        }

        Color getPaintColor() {
            return Color.red.darker();
        }

        public CharSequence getSortText() {
            String string = this.getItemText();
            return string.endsWith(";") ? string.substring(0, string.length() - 1) : string;
        }

        public String getItemText() {
            return "&" + this.baseText + ";";
        }
    }

    static class EndTagItem
    extends HTMLResultItem {
        private int order = 0;

        public EndTagItem(String string, int n, int n2) {
            super(string, n, n2);
        }

        public EndTagItem(String string, int n, int n2, String string2) {
            super(string, n, n2, string2);
        }

        public EndTagItem(String string, int n, int n2, String string2, int n3) {
            this(string, n, n2, string2);
            this.order = n3;
        }

        public CharSequence getSortText() {
            return this.getSortText(this.order);
        }

        private String getSortText(int n) {
            int n2 = n > 100 ? 0 : (n > 10 ? 1 : 2);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append('0');
            }
            stringBuffer.append("" + n);
            return stringBuffer.toString();
        }

        Color getPaintColor() {
            return Color.blue;
        }

        public String getItemText() {
            return "</" + this.baseText + ">";
        }

        public boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
            return super.substituteText(jTextComponent, n, n2, bl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void reformat(JTextComponent jTextComponent, String string) {
            try {
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                int n = jTextComponent.getCaretPosition();
                Reformat reformat = Reformat.get((Document)baseDocument);
                reformat.lock();
                try {
                    baseDocument.atomicLock();
                    try {
                        int n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
                        int n3 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
                        reformat.reformat(n2, n3);
                    }
                    finally {
                        baseDocument.atomicUnlock();
                    }
                }
                finally {
                    reformat.unlock();
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public static class AutocompleteEndTagItem
    extends EndTagItem {
        public AutocompleteEndTagItem(String string, int n) {
            this(string, n, true);
        }

        public AutocompleteEndTagItem(String string, int n, boolean bl) {
            super(string, n, 0);
            if (!bl) {
                this.baseText = string;
            }
        }

        boolean replaceText(JTextComponent jTextComponent, String string) {
            boolean bl = super.replaceText(jTextComponent, string);
            if (bl) {
                jTextComponent.setCaretPosition(this.offset);
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void reformat(JTextComponent jTextComponent, String string) {
            try {
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                int n = jTextComponent.getCaretPosition();
                Reformat reformat = Reformat.get((Document)baseDocument);
                reformat.lock();
                try {
                    baseDocument.atomicLock();
                    try {
                        int n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
                        int n3 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
                        reformat.reformat(n2, n3);
                    }
                    finally {
                        baseDocument.atomicUnlock();
                    }
                }
                finally {
                    reformat.unlock();
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public CharSequence getInsertPrefix() {
            return null;
        }
    }

    public static abstract class HTMLResultItem
    implements CompletionItem {
        String baseText;
        int offset;
        int length;
        String helpID;
        boolean shift = false;
        private HTMLCompletionResultItemPaintComponent component;
        private static final int HTML_ITEMS_SORT_PRIORITY = 20;
        protected int selectionStartOffset = -1;
        protected int selectionEndOffset = -1;
        public static final String COMPLETION_SUBSTITUTE_TEXT = "completion-substitute-text";
        static int substituteOffset = -1;

        public HTMLResultItem(String string, int n, int n2) {
            this.baseText = lowerCase ? string.toLowerCase() : string.toUpperCase();
            this.offset = n;
            this.length = n2;
            this.helpID = null;
        }

        public HTMLResultItem(String string, int n, int n2, String string2) {
            this(string, n, n2);
            this.helpID = string2;
        }

        public int getSortPriority() {
            return 20;
        }

        public CharSequence getSortText() {
            return this.getItemText();
        }

        public CharSequence getInsertPrefix() {
            return this.getItemText();
        }

        public Component getPaintComponent(boolean bl) {
            HTMLCompletionResultItemPaintComponent.StringPaintComponent stringPaintComponent = new HTMLCompletionResultItemPaintComponent.StringPaintComponent(this.getPaintColor());
            stringPaintComponent.setSelected(bl);
            stringPaintComponent.setString(this.getItemText());
            return stringPaintComponent;
        }

        public int getPreferredWidth(Graphics graphics, Font font) {
            HTMLCompletionResultItemPaintComponent hTMLCompletionResultItemPaintComponent = (HTMLCompletionResultItemPaintComponent)this.getPaintComponent(false);
            return hTMLCompletionResultItemPaintComponent.getPreferredWidth(graphics, font);
        }

        public void render(Graphics graphics, Font font, Color color, Color color2, int n, int n2, boolean bl) {
            Component component = this.getPaintComponent(bl);
            component.setFont(font);
            component.setForeground(color);
            component.setBackground(color2);
            component.setBounds(0, 0, n, n2);
            ((HTMLCompletionResultItemPaintComponent)component).paintComponent(graphics);
        }

        protected Object getAssociatedObject() {
            return this.getItemText();
        }

        public int getSubstituteOffset() {
            return substituteOffset;
        }

        public boolean instantSubstitution(JTextComponent jTextComponent) {
            this.defaultAction(jTextComponent);
            return true;
        }

        public CompletionTask createDocumentationTask() {
            return new AsyncCompletionTask((AsyncCompletionQuery)new DocQuery(this));
        }

        public CompletionTask createToolTipTask() {
            return null;
        }

        public int getImportance() {
            return 0;
        }

        public void processKeyEvent(KeyEvent keyEvent) {
            this.shift = keyEvent.getKeyCode() == 10 && keyEvent.getID() == 401 && keyEvent.isShiftDown();
        }

        public void defaultAction(JTextComponent jTextComponent) {
            int n = this.getSubstituteOffset();
            if (n == -1) {
                n = jTextComponent.getCaretPosition();
            }
            if (!this.shift) {
                Completion.get().hideAll();
            }
            this.substituteText(jTextComponent, n, jTextComponent.getCaretPosition() - n, this.shift);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean replaceText(JTextComponent jTextComponent, String string) {
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            baseDocument.atomicLock();
            try {
                String string2 = baseDocument.getText(this.offset, baseDocument.getLength() - this.offset < string.length() ? baseDocument.getLength() - this.offset : string.length());
                if (!string.equals(string2)) {
                    baseDocument.remove(this.offset, this.length);
                    baseDocument.insertString(this.offset, string, null);
                } else {
                    int n = jTextComponent.getCaret().getDot() + string.length() - this.length;
                    jTextComponent.setCaretPosition(n < baseDocument.getLength() ? n : baseDocument.getLength());
                }
            }
            catch (BadLocationException badLocationException) {
                boolean bl = false;
                return bl;
            }
            finally {
                baseDocument.atomicUnlock();
            }
            return true;
        }

        protected void reformat(JTextComponent jTextComponent, String string) {
        }

        public boolean substituteCommonText(JTextComponent jTextComponent, int n, int n2, int n3) {
            String string = this.getItemText().substring(0, n3);
            boolean bl = this.replaceText(jTextComponent, string);
            this.reformat(jTextComponent, string);
            return bl;
        }

        public boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
            String string = this.getItemText();
            boolean bl2 = this.replaceText(jTextComponent, string);
            this.reformat(jTextComponent, string);
            return bl2;
        }

        public Component getPaintComponent(JList jList, boolean bl, boolean bl2) {
            Component component = this.getPaintComponent(bl);
            if (component == null) {
                return null;
            }
            if (bl) {
                component.setBackground(jList.getSelectionBackground());
                component.setForeground(jList.getSelectionForeground());
            } else {
                component.setBackground(jList.getBackground());
                component.setForeground(jList.getForeground());
            }
            component.getAccessibleContext().setAccessibleName(this.getItemText());
            component.getAccessibleContext().setAccessibleDescription(this.getItemText());
            return component;
        }

        String getPaintText() {
            return this.getItemText();
        }

        abstract Color getPaintColor();

        public String getItemText() {
            return this.baseText;
        }

        public String getHelpID() {
            return this.helpID;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            String string = this.getClass().getName();
            string = string.substring(string.lastIndexOf(46) + 1);
            stringBuffer.append(string);
            stringBuffer.append('(');
            stringBuffer.append(this.getItemText());
            stringBuffer.append(';');
            stringBuffer.append(this.getSubstituteOffset());
            stringBuffer.append(';');
            stringBuffer.append(this.getHelpID());
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
    }
}

