/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.bridge.impl;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.input.InputRequest;
import org.apache.tools.ant.input.MultipleChoiceInputRequest;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class NbInputHandler
implements InputHandler {
    private JComboBox combo = null;
    private JTextField input = null;
    private final Runnable interestingOutputCallback;
    private static String defaultValue;

    public NbInputHandler(Runnable interestingOutputCallback) {
        this.interestingOutputCallback = interestingOutputCallback;
    }

    public void handleInput(InputRequest request) throws BuildException {
        this.interestingOutputCallback.run();
        this.combo = null;
        this.input = null;
        JPanel panel = this.createPanel(request);
        DialogDescriptor dlg = new DialogDescriptor((Object)panel, NbBundle.getMessage(NbInputHandler.class, (String)"TITLE_input_handler"));
        do {
            DialogDisplayer.getDefault().createDialog(dlg).setVisible(true);
            if (dlg.getValue() != NotifyDescriptor.OK_OPTION) {
                throw new BuildException(NbBundle.getMessage(NbInputHandler.class, (String)"MSG_input_aborted"));
            }
            String value = this.combo != null ? (String)this.combo.getSelectedItem() : this.input.getText();
            request.setInput(value);
        } while (!request.isInputValid());
    }

    private JPanel createPanel(InputRequest request) {
        JPanel pane = new JPanel();
        pane.setLayout(new GridBagLayout());
        JLabel jLabel1 = new JLabel(request.getPrompt());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 11, 6);
        pane.add((Component)jLabel1, gridBagConstraints);
        JComponent comp = null;
        if (request instanceof MultipleChoiceInputRequest) {
            this.combo = new JComboBox(((MultipleChoiceInputRequest)request).getChoices());
            if (defaultValue != null && defaultValue.length() > 0) {
                this.combo.setSelectedItem(NbInputHandler.getDefaultValue(request));
            }
            comp = this.combo;
        } else {
            comp = this.input = new JTextField(NbInputHandler.getDefaultValue(request), 25);
        }
        ((Component)comp).getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbInputHandler.class, (String)"ACSD_input_handler"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 11, 6);
        pane.add((Component)comp, gridBagConstraints);
        jLabel1.setLabelFor(comp);
        if (request.getPrompt().length() > 0) {
            jLabel1.setDisplayedMnemonic(request.getPrompt().charAt(0));
        }
        pane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NbInputHandler.class, (String)"TITLE_input_handler"));
        pane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbInputHandler.class, (String)"ACSD_input_handler"));
        HelpCtx.setHelpIDString((JComponent)pane, (String)"org.apache.tools.ant.module.run.NBInputHandler");
        return pane;
    }

    static void setDefaultValue(String d) {
        defaultValue = d;
    }

    private static String getDefaultValue(InputRequest req) {
        try {
            return (String)InputRequest.class.getMethod("getDefaultValue", new Class[0]).invoke((Object)req, new Object[0]);
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return defaultValue;
    }
}

