/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.Reader;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ScriptRuntime;
import org.netbeans.spi.lexer.LexerInput;

public class TokenStream {
    private static final int EOF_CHAR = -1;
    private LexerInput lexerInput;
    private int seenSpaces;
    private boolean skipUngetCheck;
    private boolean syntaxLexing;
    private boolean divIsRegexp = true;
    private static final int NO_LITERAL = 0;
    private static final int IN_ERROR = 1;
    private static final int IN_STRING = 2;
    private static final int END_STRING = 3;
    private static final int IN_REGEXP = 4;
    private static final int END_REGEXP = 5;
    private short stringMode = 0;
    private boolean dirtyLine;
    String regExpFlags;
    private String string = "";
    private double number;
    private static char[] stringBuffer = new char[128];
    private int stringBufferTop;
    private ObjToIntMap allStrings = new ObjToIntMap(50);
    private final int[] ungetBuffer = new int[3];
    private int ungetCursor;
    private boolean hitEOF = false;
    private int lineStart = 0;
    private int lineno;
    private int lineEndChar = -1;
    private String sourceString;
    private Reader sourceReader;
    private char[] sourceBuffer;
    private int sourceEnd;
    private int sourceCursor;
    private boolean xmlIsAttribute;
    private boolean xmlIsTagContent;
    private int xmlOpenTagsCount;
    private Parser parser;

    public void setInput(LexerInput lexerInput) {
        this.lexerInput = lexerInput;
    }

    public TokenStream(Parser parser, LexerInput lexerInput, Reader reader, String string, int n) {
        this(parser, reader, string, n);
        this.lexerInput = lexerInput;
        this.syntaxLexing = true;
    }

    TokenStream(Parser parser, Reader reader, String string, int n) {
        this.parser = parser;
        this.lineno = n;
        if (reader != null) {
            if (string != null) {
                Kit.codeBug();
            }
            this.sourceReader = reader;
            this.sourceBuffer = new char[512];
            this.sourceEnd = 0;
        } else {
            if (string == null) {
                Kit.codeBug();
            }
            this.sourceString = string;
            this.sourceEnd = string.length();
        }
        this.sourceCursor = 0;
    }

    String tokenToString(int n) {
        return "";
    }

    static boolean isKeyword(String string) {
        return 0 != TokenStream.stringToKeyword(string);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int stringToKeyword(String string) {
        String string2 = string;
        int n = 0;
        String string3 = null;
        block0 : switch (string2.length()) {
            case 2: {
                char c = string2.charAt(1);
                if (c == 'f') {
                    if (string2.charAt(0) != 'i') break;
                    return 108;
                }
                if (c == 'n') {
                    if (string2.charAt(0) != 'i') break;
                    return 51;
                }
                if (c != 'o' || string2.charAt(0) != 'd') break;
                return 114;
            }
            case 3: {
                switch (string2.charAt(0)) {
                    case 'f': {
                        if (string2.charAt(2) != 'r' || string2.charAt(1) != 'o') break;
                        return 115;
                    }
                    case 'i': {
                        if (string2.charAt(2) != 't' || string2.charAt(1) != 'n') break;
                        return 123;
                    }
                    case 'n': {
                        if (string2.charAt(2) != 'w' || string2.charAt(1) != 'e') break;
                        return 30;
                    }
                    case 't': {
                        if (string2.charAt(2) != 'y' || string2.charAt(1) != 'r') break;
                        return 77;
                    }
                    case 'v': {
                        if (string2.charAt(2) != 'r' || string2.charAt(1) != 'a') break;
                        return 118;
                    }
                }
                break;
            }
            case 4: {
                switch (string2.charAt(0)) {
                    case 'b': {
                        string3 = "byte";
                        n = 123;
                        break;
                    }
                    case 'c': {
                        char c = string2.charAt(3);
                        if (c == 'e') {
                            if (string2.charAt(2) != 's' || string2.charAt(1) != 'a') break;
                            return 111;
                        }
                        if (c != 'r' || string2.charAt(2) != 'a' || string2.charAt(1) != 'h') break;
                        return 123;
                    }
                    case 'e': {
                        char c = string2.charAt(3);
                        if (c == 'e') {
                            if (string2.charAt(2) != 's' || string2.charAt(1) != 'l') break;
                            return 109;
                        }
                        if (c != 'm' || string2.charAt(2) != 'u' || string2.charAt(1) != 'n') break;
                        return 123;
                    }
                    case 'g': {
                        string3 = "goto";
                        n = 123;
                        break;
                    }
                    case 'l': {
                        string3 = "long";
                        n = 123;
                        break;
                    }
                    case 'n': {
                        string3 = "null";
                        n = 41;
                        break;
                    }
                    case 't': {
                        char c = string2.charAt(3);
                        if (c == 'e') {
                            if (string2.charAt(2) != 'u' || string2.charAt(1) != 'r') break;
                            return 44;
                        }
                        if (c != 's' || string2.charAt(2) != 'i' || string2.charAt(1) != 'h') break;
                        return 42;
                    }
                    case 'v': {
                        string3 = "void";
                        n = 122;
                        break;
                    }
                    case 'w': {
                        string3 = "with";
                        n = 119;
                        break;
                    }
                }
                break;
            }
            case 5: {
                switch (string2.charAt(2)) {
                    case 'a': {
                        string3 = "class";
                        n = 123;
                        break;
                    }
                    case 'e': {
                        string3 = "break";
                        n = 116;
                        break;
                    }
                    case 'i': {
                        string3 = "while";
                        n = 113;
                        break;
                    }
                    case 'l': {
                        string3 = "false";
                        n = 43;
                        break;
                    }
                    case 'n': {
                        char c = string2.charAt(0);
                        if (c == 'c') {
                            string3 = "const";
                            n = 149;
                            break;
                        }
                        if (c != 'f') break;
                        string3 = "final";
                        n = 123;
                        break;
                    }
                    case 'o': {
                        char c = string2.charAt(0);
                        if (c == 'f') {
                            string3 = "float";
                            n = 123;
                            break;
                        }
                        if (c != 's') break;
                        string3 = "short";
                        n = 123;
                        break;
                    }
                    case 'p': {
                        string3 = "super";
                        n = 123;
                        break;
                    }
                    case 'r': {
                        string3 = "throw";
                        n = 49;
                        break;
                    }
                    case 't': {
                        string3 = "catch";
                        n = 120;
                        break;
                    }
                }
                break;
            }
            case 6: {
                switch (string2.charAt(1)) {
                    case 'a': {
                        string3 = "native";
                        n = 123;
                        break;
                    }
                    case 'e': {
                        char c = string2.charAt(0);
                        if (c == 'd') {
                            string3 = "delete";
                            n = 31;
                            break;
                        }
                        if (c != 'r') break;
                        string3 = "return";
                        n = 4;
                        break;
                    }
                    case 'h': {
                        string3 = "throws";
                        n = 123;
                        break;
                    }
                    case 'm': {
                        string3 = "import";
                        n = 107;
                        break;
                    }
                    case 'o': {
                        string3 = "double";
                        n = 123;
                        break;
                    }
                    case 't': {
                        string3 = "static";
                        n = 123;
                        break;
                    }
                    case 'u': {
                        string3 = "public";
                        n = 123;
                        break;
                    }
                    case 'w': {
                        string3 = "switch";
                        n = 110;
                        break;
                    }
                    case 'x': {
                        string3 = "export";
                        n = 106;
                        break;
                    }
                    case 'y': {
                        string3 = "typeof";
                        n = 32;
                        break;
                    }
                }
                break;
            }
            case 7: {
                switch (string2.charAt(1)) {
                    case 'a': {
                        string3 = "package";
                        n = 123;
                        break block0;
                    }
                    case 'e': {
                        string3 = "default";
                        n = 112;
                        break block0;
                    }
                    case 'i': {
                        string3 = "finally";
                        n = 121;
                        break block0;
                    }
                    case 'o': {
                        string3 = "boolean";
                        n = 123;
                        break block0;
                    }
                    case 'r': {
                        string3 = "private";
                        n = 123;
                        break block0;
                    }
                    case 'x': {
                        string3 = "extends";
                        n = 123;
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                switch (string2.charAt(0)) {
                    case 'a': {
                        string3 = "abstract";
                        n = 123;
                        break block0;
                    }
                    case 'c': {
                        string3 = "continue";
                        n = 117;
                        break block0;
                    }
                    case 'd': {
                        string3 = "debugger";
                        n = 123;
                        break block0;
                    }
                    case 'f': {
                        string3 = "function";
                        n = 105;
                        break block0;
                    }
                    case 'v': {
                        string3 = "volatile";
                        n = 123;
                        break block0;
                    }
                }
                break;
            }
            case 9: {
                char c = string2.charAt(0);
                if (c == 'i') {
                    string3 = "interface";
                    n = 123;
                    break;
                }
                if (c == 'p') {
                    string3 = "protected";
                    n = 123;
                    break;
                }
                if (c != 't') break;
                string3 = "transient";
                n = 123;
                break;
            }
            case 10: {
                char c = string2.charAt(1);
                if (c == 'm') {
                    string3 = "implements";
                    n = 123;
                    break;
                }
                if (c != 'n') break;
                string3 = "instanceof";
                n = 52;
                break;
            }
            case 12: {
                string3 = "synchronized";
                n = 123;
            }
        }
        if (string3 != null && string3 != string2 && !string3.equals(string2)) {
            return 0;
        }
        if (n != 0) return n & 0xFF;
        return 0;
    }

    public final int getLineno() {
        return this.lineno;
    }

    public final String getString() {
        return this.string;
    }

    public final double getNumber() {
        return this.number;
    }

    public final boolean eof() {
        return this.hitEOF;
    }

    public int seenSpaces() {
        return this.seenSpaces;
    }

    public int getToken() throws IOException {
        if (this.syntaxLexing && this.stringMode != 0) {
            switch (this.stringMode) {
                case 1: {
                    int n = this.string.length();
                    for (int i = 1; i < n; ++i) {
                        int n2 = this.lexerInput.read();
                        assert (n2 == this.string.charAt(i)) : this.string + i + ":" + (char)n2;
                    }
                    this.stringMode = 0;
                    return -1;
                }
                case 2: {
                    if (this.string.length() == 2) {
                        int n = this.lexerInput.read();
                        assert (n == 34 || n == 39) : (char)n;
                        this.stringMode = 0;
                        return 159;
                    }
                    int n = this.string.length() - 1;
                    for (int i = 1; i < n; ++i) {
                        int n3 = this.lexerInput.read();
                        assert (n3 == this.string.charAt(i)) : this.string + i + ":" + (char)n3;
                    }
                    this.stringMode = (short)3;
                    return 40;
                }
                case 3: {
                    int n = this.lexerInput.read();
                    assert (n == 34 || n == 39) : (char)n;
                    this.stringMode = 0;
                    return 159;
                }
                case 4: {
                    if (this.string.length() == 2) {
                        int n = this.lexerInput.read();
                        assert (n == 47) : (char)n;
                        this.stringMode = 0;
                        return 162;
                    }
                    int n = this.string.lastIndexOf(47);
                    for (int i = 1; i < n; ++i) {
                        int n4 = this.lexerInput.read();
                        assert (n4 == this.string.charAt(i)) : this.string + i + ":" + (char)n4;
                    }
                    this.stringMode = (short)5;
                    return 47;
                }
                case 5: {
                    int n;
                    int n5 = this.string.length();
                    for (int i = n = this.string.lastIndexOf(47); i < n5; ++i) {
                        int n6 = this.lexerInput.read();
                        assert (n6 == this.string.charAt(i)) : this.string + i + ":" + (char)n6;
                    }
                    this.stringMode = 0;
                    return 162;
                }
            }
            assert (false) : this.stringMode;
        }
        int n = this.privateGetToken();
        if (this.syntaxLexing) {
            if (n != 154 && n != 1) {
                boolean bl = this.divIsRegexp = n == 83 || n == 85 || n == 26 || n == 86 || n == 78 || n == 99;
            }
            if (n == 40) {
                assert (this.stringMode == 0);
                this.string = ((Object)this.lexerInput.readText()).toString();
                int n7 = this.string.length() - 1;
                if (n7 > 0) {
                    this.lexerInput.backup(n7);
                    this.stringMode = (short)2;
                } else {
                    this.stringMode = 0;
                }
                n = 158;
            } else if (n == 47) {
                assert (this.stringMode == 0);
                this.string = ((Object)this.lexerInput.readText()).toString();
                int n8 = this.string.length() - 1;
                if (n8 > 0) {
                    this.lexerInput.backup(n8);
                    this.stringMode = (short)4;
                } else {
                    this.stringMode = 0;
                }
                n = 161;
            } else if (n == 163) {
                assert (this.stringMode == 0);
                this.string = ((Object)this.lexerInput.readText()).toString();
                int n9 = this.string.length() - 1;
                if (n9 > 0) {
                    this.lexerInput.backup(n9);
                    this.stringMode = 1;
                } else {
                    this.stringMode = 0;
                }
                n = 161;
            } else if (n == 160) {
                assert (this.stringMode == 0);
                this.string = ((Object)this.lexerInput.readText()).toString();
                int n10 = this.string.length() - 1;
                if (n10 > 0) {
                    this.lexerInput.backup(n10);
                    this.stringMode = 1;
                } else {
                    this.stringMode = 0;
                }
                n = 158;
            }
        }
        return n;
    }

    final int privateGetToken() throws IOException {
        this.seenSpaces = 0;
        block41: while (true) {
            int n;
            boolean bl;
            int n2;
            if ((n2 = this.getChar()) == -1) {
                return 0;
            }
            if (n2 == 10) {
                this.dirtyLine = false;
                ++this.seenSpaces;
                return 1;
            }
            if (!TokenStream.isJSSpace(n2)) {
                if (n2 != 45) {
                    this.dirtyLine = true;
                }
            } else {
                ++this.seenSpaces;
                continue;
            }
            if (this.syntaxLexing && this.seenSpaces > 0) {
                this.ungetChar(n2);
                return 154;
            }
            if (n2 == 64) {
                return 143;
            }
            int n3 = 0;
            if (n2 == 92) {
                n2 = this.getChar();
                if (n2 == 117) {
                    bl = true;
                    n3 = 1;
                    this.stringBufferTop = 0;
                } else {
                    bl = false;
                    this.ungetChar(n2);
                    n2 = 92;
                }
            } else {
                bl = Character.isJavaIdentifierStart((char)n2);
                if (bl) {
                    this.stringBufferTop = 0;
                    this.addToString(n2);
                }
            }
            if (bl) {
                int n4;
                n = n3;
                while (true) {
                    if (n3 != 0) {
                        int n5 = 0;
                        for (n4 = 0; n4 != 4 && (n5 = Kit.xDigitToInt(n2 = this.getChar(), n5)) >= 0; ++n4) {
                        }
                        if (n5 < 0) {
                            this.parser.addError("msg.invalid.escape");
                            return -1;
                        }
                        this.addToString(n5);
                        n3 = 0;
                        continue;
                    }
                    n2 = this.getChar();
                    if (n2 == 92) {
                        n2 = this.getChar();
                        if (n2 == 117) {
                            n3 = 1;
                            n = 1;
                            continue;
                        }
                        this.parser.addError("msg.illegal.character");
                        return -1;
                    }
                    if (n2 == -1 || !Character.isJavaIdentifierPart((char)n2)) break;
                    this.addToString(n2);
                }
                this.ungetChar(n2);
                String string = this.getStringFromBuffer();
                if (n == 0 && (n4 = TokenStream.stringToKeyword(string)) != 0) {
                    if (n4 != 123) {
                        return n4;
                    }
                    if (!this.parser.compilerEnv.isReservedKeywordAsIdentifier()) {
                        return n4;
                    }
                    this.parser.addWarning("msg.reserved.keyword", string, new Object[]{null, string});
                }
                if (this.syntaxLexing && "undefined".equals(string)) {
                    return 165;
                }
                this.string = (String)this.allStrings.intern(string);
                return 38;
            }
            if (TokenStream.isDigit(n2) || n2 == 46 && TokenStream.isDigit(this.peekChar())) {
                double d;
                this.stringBufferTop = 0;
                n = 10;
                if (n2 == 48) {
                    n2 = this.getChar();
                    if (n2 == 120 || n2 == 88) {
                        n = 16;
                        n2 = this.getChar();
                    } else if (TokenStream.isDigit(n2)) {
                        n = 8;
                    } else {
                        this.addToString(48);
                    }
                }
                if (n == 16) {
                    while (0 <= Kit.xDigitToInt(n2, 0)) {
                        this.addToString(n2);
                        n2 = this.getChar();
                    }
                } else {
                    while (48 <= n2 && n2 <= 57) {
                        if (n == 8 && n2 >= 56) {
                            this.parser.addWarning("msg.bad.octal.literal", n2 == 56 ? "8" : "9", null);
                            n = 10;
                        }
                        this.addToString(n2);
                        n2 = this.getChar();
                    }
                }
                boolean bl2 = true;
                if (n == 10 && (n2 == 46 || n2 == 101 || n2 == 69)) {
                    bl2 = false;
                    if (n2 == 46) {
                        do {
                            this.addToString(n2);
                        } while (TokenStream.isDigit(n2 = this.getChar()));
                    }
                    if (n2 == 101 || n2 == 69) {
                        this.addToString(n2);
                        n2 = this.getChar();
                        if (n2 == 43 || n2 == 45) {
                            this.addToString(n2);
                            n2 = this.getChar();
                        }
                        if (!TokenStream.isDigit(n2)) {
                            this.parser.addError("msg.missing.exponent");
                            return -1;
                        }
                        do {
                            this.addToString(n2);
                        } while (TokenStream.isDigit(n2 = this.getChar()));
                    }
                }
                this.ungetChar(n2);
                String string = this.getStringFromBuffer();
                if (n == 10 && !bl2) {
                    try {
                        d = Double.valueOf(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.parser.addError("msg.caught.nfe");
                        return -1;
                    }
                } else {
                    d = ScriptRuntime.stringToNumber(string, 0, n);
                }
                this.number = d;
                return 39;
            }
            if (n2 == 34 || n2 == 39) {
                n = n2;
                this.stringBufferTop = 0;
                n2 = this.getChar();
                block48: while (n2 != n) {
                    if (n2 == 10 || n2 == -1) {
                        this.ungetChar(n2);
                        this.parser.addError("msg.unterminated.string.lit");
                        return 160;
                    }
                    if (n2 == 92) {
                        n2 = this.getChar();
                        switch (n2) {
                            case 98: {
                                n2 = 8;
                                break;
                            }
                            case 102: {
                                n2 = 12;
                                break;
                            }
                            case 110: {
                                n2 = 10;
                                break;
                            }
                            case 114: {
                                n2 = 13;
                                break;
                            }
                            case 116: {
                                n2 = 9;
                                break;
                            }
                            case 118: {
                                n2 = 11;
                                break;
                            }
                            case 117: {
                                int n6;
                                int n7 = this.stringBufferTop;
                                this.addToString(117);
                                int n8 = 0;
                                for (n6 = 0; n6 != 4; ++n6) {
                                    n2 = this.getChar();
                                    n8 = Kit.xDigitToInt(n2, n8);
                                    if (n8 < 0) continue block48;
                                    this.addToString(n2);
                                }
                                this.stringBufferTop = n7;
                                n2 = n8;
                                break;
                            }
                            case 120: {
                                n2 = this.getChar();
                                int n8 = Kit.xDigitToInt(n2, 0);
                                if (n8 < 0) {
                                    this.addToString(120);
                                    continue block48;
                                }
                                int n6 = n2;
                                n2 = this.getChar();
                                n8 = Kit.xDigitToInt(n2, n8);
                                if (n8 < 0) {
                                    this.addToString(120);
                                    this.addToString(n6);
                                    continue block48;
                                }
                                n2 = n8;
                                break;
                            }
                            case 10: {
                                n2 = this.getChar();
                                continue block48;
                            }
                            default: {
                                if (48 > n2 || n2 >= 56) break;
                                int n6 = n2 - 48;
                                n2 = this.getChar();
                                if (48 <= n2 && n2 < 56) {
                                    n6 = 8 * n6 + n2 - 48;
                                    n2 = this.getChar();
                                    if (48 <= n2 && n2 < 56 && n6 <= 31) {
                                        n6 = 8 * n6 + n2 - 48;
                                        n2 = this.getChar();
                                    }
                                }
                                this.ungetChar(n2);
                                n2 = n6;
                            }
                        }
                    }
                    this.addToString(n2);
                    n2 = this.getChar();
                }
                String string = this.getStringFromBuffer();
                this.string = (String)this.allStrings.intern(string);
                return 40;
            }
            switch (n2) {
                case 59: {
                    return 78;
                }
                case 91: {
                    return 79;
                }
                case 93: {
                    return 80;
                }
                case 123: {
                    return 81;
                }
                case 125: {
                    return 82;
                }
                case 40: {
                    return 83;
                }
                case 41: {
                    return 84;
                }
                case 44: {
                    return 85;
                }
                case 63: {
                    return 98;
                }
                case 58: {
                    if (this.matchChar(58)) {
                        return 140;
                    }
                    return 99;
                }
                case 46: {
                    if (this.matchChar(46)) {
                        return 139;
                    }
                    if (this.matchChar(40)) {
                        return 142;
                    }
                    return 104;
                }
                case 124: {
                    if (this.matchChar(124)) {
                        return 100;
                    }
                    if (this.matchChar(61)) {
                        return 87;
                    }
                    return 9;
                }
                case 94: {
                    if (this.matchChar(61)) {
                        return 88;
                    }
                    return 10;
                }
                case 38: {
                    if (this.matchChar(38)) {
                        return 101;
                    }
                    if (this.matchChar(61)) {
                        return 89;
                    }
                    return 11;
                }
                case 61: {
                    if (this.matchChar(61)) {
                        if (this.matchChar(61)) {
                            return 45;
                        }
                        return 12;
                    }
                    return 86;
                }
                case 33: {
                    if (this.matchChar(61)) {
                        if (this.matchChar(61)) {
                            return 46;
                        }
                        return 13;
                    }
                    return 26;
                }
                case 60: {
                    if (this.matchChar(33)) {
                        if (this.matchChar(45)) {
                            if (this.matchChar(45)) {
                                this.skipLine();
                                continue block41;
                            }
                            this.ungetChar(45);
                        }
                        this.ungetChar(33);
                    }
                    if (this.matchChar(60)) {
                        if (this.matchChar(61)) {
                            return 90;
                        }
                        return 18;
                    }
                    if (this.matchChar(61)) {
                        return 15;
                    }
                    return 14;
                }
                case 62: {
                    if (this.matchChar(62)) {
                        if (this.matchChar(62)) {
                            if (this.matchChar(61)) {
                                return 92;
                            }
                            return 20;
                        }
                        if (this.matchChar(61)) {
                            return 91;
                        }
                        return 19;
                    }
                    if (this.matchChar(61)) {
                        return 17;
                    }
                    return 16;
                }
                case 42: {
                    if (this.matchChar(61)) {
                        return 95;
                    }
                    return 23;
                }
                case 47: {
                    if (this.matchChar(47)) {
                        this.skipLine();
                        if (!this.syntaxLexing) continue block41;
                        return 152;
                    }
                    if (this.matchChar(42)) {
                        n = 0;
                        while (true) {
                            if ((n2 = this.getChar()) == -1) {
                                this.parser.addError("msg.unterminated.comment");
                                return -1;
                            }
                            if (n2 == 42) {
                                n = 1;
                                continue;
                            }
                            if (n2 == 47) {
                                if (n == 0) continue;
                                if (!this.syntaxLexing) continue block41;
                                return 153;
                            }
                            n = 0;
                        }
                    }
                    if (this.syntaxLexing && this.divIsRegexp) {
                        try {
                            this.readRegExp(24);
                        }
                        catch (Throwable throwable) {
                            return 163;
                        }
                        return 47;
                    }
                    if (this.matchChar(61)) {
                        return 96;
                    }
                    return 24;
                }
                case 37: {
                    if (this.matchChar(61)) {
                        return 97;
                    }
                    return 25;
                }
                case 126: {
                    return 27;
                }
                case 43: {
                    if (this.matchChar(61)) {
                        return 93;
                    }
                    if (this.matchChar(43)) {
                        return 102;
                    }
                    return 21;
                }
                case 45: {
                    if (this.matchChar(61)) {
                        n2 = 94;
                    } else if (this.matchChar(45)) {
                        if (!this.dirtyLine && this.matchChar(62)) {
                            this.skipLine();
                            continue block41;
                        }
                        n2 = 103;
                    } else {
                        n2 = 22;
                    }
                    this.dirtyLine = true;
                    return n2;
                }
            }
            break;
        }
        this.parser.addError("msg.illegal.character");
        return -1;
    }

    private static boolean isAlpha(int n) {
        if (n <= 90) {
            return 65 <= n;
        }
        return 97 <= n && n <= 122;
    }

    static boolean isDigit(int n) {
        return 48 <= n && n <= 57;
    }

    static boolean isJSSpace(int n) {
        if (n <= 127) {
            return n == 32 || n == 9 || n == 12 || n == 11;
        }
        return n == 160 || Character.getType((char)n) == 12;
    }

    private static boolean isJSFormatChar(int n) {
        return n > 127 && Character.getType((char)n) == 16;
    }

    public void readRegExp(int n) throws IOException {
        int n2;
        this.stringBufferTop = 0;
        if (n == 96) {
            this.addToString(61);
        } else if (n != 24) {
            Kit.codeBug();
        }
        while ((n2 = this.getChar()) != 47) {
            if (n2 == 10 || n2 == -1) {
                this.ungetChar(n2);
                throw this.parser.reportError("msg.unterminated.re.lit");
            }
            if (n2 == 92) {
                this.addToString(n2);
                n2 = this.getChar();
            }
            this.addToString(n2);
        }
        int n3 = this.stringBufferTop;
        while (true) {
            if (this.matchChar(103)) {
                this.addToString(103);
                continue;
            }
            if (this.matchChar(105)) {
                this.addToString(105);
                continue;
            }
            if (!this.matchChar(109)) break;
            this.addToString(109);
        }
        if (TokenStream.isAlpha(this.peekChar())) {
            throw this.parser.reportError("msg.invalid.re.flag");
        }
        this.string = new String(stringBuffer, 0, n3);
        this.regExpFlags = new String(stringBuffer, n3, this.stringBufferTop - n3);
    }

    boolean isXMLAttribute() {
        return this.xmlIsAttribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getFirstXMLToken() throws IOException {
        this.xmlOpenTagsCount = 0;
        this.xmlIsAttribute = false;
        this.xmlIsTagContent = false;
        try {
            this.skipUngetCheck = true;
            this.ungetChar(60);
        }
        finally {
            this.skipUngetCheck = false;
        }
        return this.getNextXMLToken();
    }

    int getNextXMLToken() throws IOException {
        this.stringBufferTop = 0;
        int n = this.getChar();
        while (n != -1) {
            if (this.xmlIsTagContent) {
                switch (n) {
                    case 62: {
                        this.addToString(n);
                        this.xmlIsTagContent = false;
                        this.xmlIsAttribute = false;
                        break;
                    }
                    case 47: {
                        this.addToString(n);
                        if (this.peekChar() != 62) break;
                        n = this.getChar();
                        this.addToString(n);
                        this.xmlIsTagContent = false;
                        --this.xmlOpenTagsCount;
                        break;
                    }
                    case 123: {
                        this.ungetChar(n);
                        this.string = this.getStringFromBuffer();
                        return 141;
                    }
                    case 34: 
                    case 39: {
                        this.addToString(n);
                        if (this.readQuotedString(n)) break;
                        return -1;
                    }
                    case 61: {
                        this.addToString(n);
                        this.xmlIsAttribute = true;
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: {
                        this.addToString(n);
                        break;
                    }
                    default: {
                        this.addToString(n);
                        this.xmlIsAttribute = false;
                    }
                }
                if (!this.xmlIsTagContent && this.xmlOpenTagsCount == 0) {
                    this.string = this.getStringFromBuffer();
                    return 144;
                }
            } else {
                block8 : switch (n) {
                    case 60: {
                        this.addToString(n);
                        n = this.peekChar();
                        switch (n) {
                            case 33: {
                                n = this.getChar();
                                this.addToString(n);
                                n = this.peekChar();
                                switch (n) {
                                    case 45: {
                                        n = this.getChar();
                                        this.addToString(n);
                                        n = this.getChar();
                                        if (n == 45) {
                                            this.addToString(n);
                                            if (this.readXmlComment()) break block8;
                                            return -1;
                                        }
                                        this.stringBufferTop = 0;
                                        this.string = null;
                                        this.parser.addError("msg.XML.bad.form");
                                        return -1;
                                    }
                                    case 91: {
                                        n = this.getChar();
                                        this.addToString(n);
                                        if (this.getChar() == 67 && this.getChar() == 68 && this.getChar() == 65 && this.getChar() == 84 && this.getChar() == 65 && this.getChar() == 91) {
                                            this.addToString(67);
                                            this.addToString(68);
                                            this.addToString(65);
                                            this.addToString(84);
                                            this.addToString(65);
                                            this.addToString(91);
                                            if (this.readCDATA()) break block8;
                                            return -1;
                                        }
                                        this.stringBufferTop = 0;
                                        this.string = null;
                                        this.parser.addError("msg.XML.bad.form");
                                        return -1;
                                    }
                                    default: {
                                        if (this.readEntity()) break block8;
                                        return -1;
                                    }
                                }
                            }
                            case 63: {
                                n = this.getChar();
                                this.addToString(n);
                                if (this.readPI()) break block8;
                                return -1;
                            }
                            case 47: {
                                n = this.getChar();
                                this.addToString(n);
                                if (this.xmlOpenTagsCount == 0) {
                                    this.stringBufferTop = 0;
                                    this.string = null;
                                    this.parser.addError("msg.XML.bad.form");
                                    return -1;
                                }
                                this.xmlIsTagContent = true;
                                --this.xmlOpenTagsCount;
                                break;
                            }
                            default: {
                                this.xmlIsTagContent = true;
                                ++this.xmlOpenTagsCount;
                                break;
                            }
                        }
                        break;
                    }
                    case 123: {
                        this.ungetChar(n);
                        this.string = this.getStringFromBuffer();
                        return 141;
                    }
                    default: {
                        this.addToString(n);
                    }
                }
            }
            n = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return -1;
    }

    private boolean readQuotedString(int n) throws IOException {
        int n2 = this.getChar();
        while (n2 != -1) {
            this.addToString(n2);
            if (n2 == n) {
                return true;
            }
            n2 = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return false;
    }

    private boolean readXmlComment() throws IOException {
        int n = this.getChar();
        while (n != -1) {
            this.addToString(n);
            if (n == 45 && this.peekChar() == 45) {
                n = this.getChar();
                this.addToString(n);
                if (this.peekChar() != 62) continue;
                n = this.getChar();
                this.addToString(n);
                return true;
            }
            n = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return false;
    }

    private boolean readCDATA() throws IOException {
        int n = this.getChar();
        while (n != -1) {
            this.addToString(n);
            if (n == 93 && this.peekChar() == 93) {
                n = this.getChar();
                this.addToString(n);
                if (this.peekChar() != 62) continue;
                n = this.getChar();
                this.addToString(n);
                return true;
            }
            n = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return false;
    }

    private boolean readEntity() throws IOException {
        int n = 1;
        int n2 = this.getChar();
        while (n2 != -1) {
            this.addToString(n2);
            switch (n2) {
                case 60: {
                    ++n;
                    break;
                }
                case 62: {
                    if (--n != 0) break;
                    return true;
                }
            }
            n2 = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return false;
    }

    private boolean readPI() throws IOException {
        int n = this.getChar();
        while (n != -1) {
            this.addToString(n);
            if (n == 63 && this.peekChar() == 62) {
                n = this.getChar();
                this.addToString(n);
                return true;
            }
            n = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return false;
    }

    private String getStringFromBuffer() {
        return new String(stringBuffer, 0, this.stringBufferTop);
    }

    private void addToString(int n) {
        int n2 = this.stringBufferTop;
        if (n2 == stringBuffer.length) {
            char[] cArray = new char[stringBuffer.length * 2];
            System.arraycopy(stringBuffer, 0, cArray, 0, n2);
            stringBuffer = cArray;
        }
        TokenStream.stringBuffer[n2] = (char)n;
        this.stringBufferTop = n2 + 1;
    }

    private void ungetChar(int n) {
        if (this.lexerInput != null) {
            this.lexerInput.backup(1);
            return;
        }
        if (!this.skipUngetCheck && this.ungetCursor != 0 && this.ungetBuffer[this.ungetCursor - 1] == 10) {
            Kit.codeBug();
        }
        this.ungetBuffer[this.ungetCursor++] = n;
    }

    private boolean matchChar(int n) throws IOException {
        int n2 = this.getChar();
        if (n2 == n) {
            return true;
        }
        this.ungetChar(n2);
        return false;
    }

    private int peekChar() throws IOException {
        int n = this.getChar();
        this.ungetChar(n);
        return n;
    }

    private int getChar() throws IOException {
        int n;
        block12: {
            if (this.lexerInput != null) {
                int n2 = this.lexerInput.read();
                return n2;
            }
            if (this.ungetCursor != 0) {
                return this.ungetBuffer[--this.ungetCursor];
            }
            while (true) {
                if (this.sourceString != null) {
                    if (this.sourceCursor == this.sourceEnd) {
                        this.hitEOF = true;
                        return -1;
                    }
                    n = this.sourceString.charAt(this.sourceCursor++);
                } else {
                    if (this.sourceCursor == this.sourceEnd && !this.fillSourceBuffer()) {
                        this.hitEOF = true;
                        return -1;
                    }
                    n = this.sourceBuffer[this.sourceCursor++];
                }
                if (this.lineEndChar >= 0) {
                    if (this.lineEndChar == 13 && n == 10) {
                        this.lineEndChar = 10;
                        continue;
                    }
                    this.lineEndChar = -1;
                    this.lineStart = this.sourceCursor - 1;
                    ++this.lineno;
                }
                if (n <= 127) {
                    if (n == 10 || n == 13) {
                        this.lineEndChar = n;
                        n = 10;
                    }
                    break block12;
                }
                if (!TokenStream.isJSFormatChar(n)) break;
            }
            if (ScriptRuntime.isJSLineTerminator(n)) {
                this.lineEndChar = n;
                n = 10;
            }
        }
        return n;
    }

    private void skipLine() throws IOException {
        int n;
        while ((n = this.getChar()) != -1 && n != 10) {
        }
        this.ungetChar(n);
    }

    final int getOffset() {
        int n = this.sourceCursor - this.lineStart;
        if (this.lineEndChar >= 0) {
            --n;
        }
        return n;
    }

    public final int getBufferOffset() {
        int n = this.sourceCursor - this.ungetCursor;
        return n;
    }

    final String getLine() {
        if (this.lexerInput != null) {
            return "?";
        }
        if (this.sourceString != null) {
            int n;
            if (this.lineEndChar >= 0) {
                --n;
            } else {
                char c;
                for (n = this.sourceCursor; n != this.sourceEnd && !ScriptRuntime.isJSLineTerminator(c = this.sourceString.charAt(n)); ++n) {
                }
            }
            return this.sourceString.substring(this.lineStart, n);
        }
        int n = this.sourceCursor - this.lineStart;
        if (this.lineEndChar >= 0) {
            --n;
        } else {
            while (true) {
                char c;
                int n2;
                if ((n2 = this.lineStart + n) == this.sourceEnd) {
                    try {
                        if (!this.fillSourceBuffer()) {
                        }
                    }
                    catch (IOException iOException) {}
                    break;
                    n2 = this.lineStart + n;
                }
                if (ScriptRuntime.isJSLineTerminator(c = this.sourceBuffer[n2])) break;
                ++n;
            }
        }
        return new String(this.sourceBuffer, this.lineStart, n);
    }

    private boolean fillSourceBuffer() throws IOException {
        int n;
        if (this.lexerInput != null) {
            return true;
        }
        if (this.sourceString != null) {
            Kit.codeBug();
        }
        if (this.sourceEnd == this.sourceBuffer.length) {
            if (this.lineStart != 0) {
                System.arraycopy(this.sourceBuffer, this.lineStart, this.sourceBuffer, 0, this.sourceEnd - this.lineStart);
                this.sourceEnd -= this.lineStart;
                this.sourceCursor -= this.lineStart;
                this.lineStart = 0;
            } else {
                char[] cArray = new char[this.sourceBuffer.length * 2];
                System.arraycopy(this.sourceBuffer, 0, cArray, 0, this.sourceEnd);
                this.sourceBuffer = cArray;
            }
        }
        if ((n = this.sourceReader.read(this.sourceBuffer, this.sourceEnd, this.sourceBuffer.length - this.sourceEnd)) < 0) {
            return false;
        }
        this.sourceEnd += n;
        return true;
    }

    public void setSyntaxLexing(boolean bl) {
        this.syntaxLexing = bl;
    }

    public void fromState(Object object) {
        if (object == null) {
            return;
        }
        LexingState lexingState = (LexingState)object;
        lexingState.restore(this);
    }

    public Object toState() {
        LexingState lexingState = new LexingState(this);
        return lexingState;
    }

    private static class LexingState {
        private static final int DIV_REGEXP = 1;
        private static final int DIRTY = 2;
        private static final int EOF = 4;
        private static final int XML_ATTR = 8;
        private static final int XML_TAG = 16;
        private static final int STRING_MODE_SHIFT = 5;
        private int flags;
        private String regExpFlags;
        private String bufferedString;
        private int xmlOpenTagsCount;
        private String string;

        LexingState(TokenStream tokenStream) {
            this.regExpFlags = tokenStream.regExpFlags;
            if (tokenStream.stringBufferTop > 0) {
                this.bufferedString = new String(stringBuffer, 0, tokenStream.stringBufferTop);
            }
            this.xmlOpenTagsCount = tokenStream.xmlOpenTagsCount;
            this.string = tokenStream.string;
            int n = 0;
            if (tokenStream.dirtyLine) {
                n += 2;
            }
            if (tokenStream.divIsRegexp) {
                ++n;
            }
            if (tokenStream.hitEOF) {
                n += 4;
            }
            if (tokenStream.xmlIsAttribute) {
                n += 8;
            }
            if (tokenStream.xmlIsTagContent) {
                n += 16;
            }
            if (tokenStream.stringMode != 0) {
                n += tokenStream.stringMode << 5;
            }
            this.flags = n;
        }

        public void restore(TokenStream tokenStream) {
            tokenStream.regExpFlags = this.regExpFlags;
            tokenStream.dirtyLine = (this.flags & 2) != 0;
            tokenStream.divIsRegexp = (this.flags & 1) != 0;
            tokenStream.hitEOF = (this.flags & 4) != 0;
            tokenStream.xmlIsAttribute = (this.flags & 8) != 0;
            tokenStream.xmlIsTagContent = (this.flags & 0x10) != 0;
            if (this.bufferedString != null) {
                assert (stringBuffer.length >= this.bufferedString.length());
                char[] cArray = this.bufferedString.toCharArray();
                System.arraycopy(cArray, 0, stringBuffer, 0, cArray.length);
                tokenStream.stringBufferTop = this.bufferedString.length();
            } else {
                tokenStream.stringBufferTop = 0;
            }
            tokenStream.xmlOpenTagsCount = this.xmlOpenTagsCount;
            tokenStream.stringMode = (short)(this.flags >> 5);
            tokenStream.string = this.string;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            LexingState lexingState = (LexingState)object;
            if (this.flags != lexingState.flags) {
                return false;
            }
            if (!(this.regExpFlags == lexingState.regExpFlags || this.regExpFlags != null && this.regExpFlags.equals(lexingState.regExpFlags))) {
                return false;
            }
            if (!(this.bufferedString == lexingState.bufferedString || this.bufferedString != null && this.bufferedString.equals(lexingState.bufferedString))) {
                return false;
            }
            if (!(this.string == lexingState.string || this.string != null && this.string.equals(lexingState.string))) {
                return false;
            }
            return this.xmlOpenTagsCount == lexingState.xmlOpenTagsCount;
        }

        public int hashCode() {
            int n = 7;
            n = 37 * n + (this.regExpFlags != null ? this.regExpFlags.hashCode() : 0);
            n = 37 * n + (this.bufferedString != null ? this.bufferedString.hashCode() : 0);
            n = 37 * n + this.flags;
            n = 37 * n + (this.string != null ? this.string.hashCode() : 0);
            n = 37 * n + (this.regExpFlags != null ? this.regExpFlags.hashCode() : 0);
            n = 37 * n + this.xmlOpenTagsCount;
            return n;
        }

        private String toStateString(int n) {
            StringBuilder stringBuilder = new StringBuilder();
            if ((n & 1) != 0) {
                stringBuilder.append("divregexp|");
            }
            if ((n & 2) != 0) {
                stringBuilder.append("dirty|");
            }
            if ((n & 4) != 0) {
                stringBuilder.append("eof|");
            }
            if ((n & 0x10) != 0) {
                stringBuilder.append("xmltag|");
            }
            if ((n & 8) != 0) {
                stringBuilder.append("xmlattr|");
            }
            stringBuilder.append("stringmode=" + (n >> 5));
            String string = stringBuilder.toString();
            return string;
        }

        public String toString() {
            return "LS(regexp=" + this.regExpFlags + ",string=" + this.bufferedString + "xmlOpen=" + this.xmlOpenTagsCount + ",flags=" + this.toStateString(this.flags) + ",stringlit=" + this.string + ")";
        }
    }
}

