/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.support;

import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.remote.support.PasswordDlg;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class RemoteUserInfo
implements UserInfo,
UIKeyboardInteractive {
    private static Map<String, RemoteUserInfo> map;
    private String passwd;
    private JTextField passwordField = new JPasswordField(20);
    private final GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
    private Container panel;
    private boolean cancelled = false;
    private static final Object DLGLOCK;
    private Component parent;

    private RemoteUserInfo() {
        RemoteUserInfo.setParentComponent(this);
    }

    public static synchronized RemoteUserInfo getUserInfo(String string, boolean bl) {
        RemoteUserInfo remoteUserInfo;
        if (map == null) {
            map = new HashMap<String, RemoteUserInfo>();
        }
        if ((remoteUserInfo = map.get(string)) == null) {
            remoteUserInfo = new RemoteUserInfo();
            map.put(string, remoteUserInfo);
        }
        if (bl) {
            remoteUserInfo.cancelled = false;
            remoteUserInfo.reset();
        }
        return remoteUserInfo;
    }

    private void reset() {
        this.passwd = "";
        this.passwordField.setText("");
        this.cancelled = false;
    }

    public String getPassword() {
        return this.passwd;
    }

    public void setPassword(String string) {
        this.passwd = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean promptYesNo(String string) {
        int n;
        Object[] objectArray = new Object[]{"yes", "no"};
        Object object = DLGLOCK;
        synchronized (object) {
            n = JOptionPane.showOptionDialog(this.parent, string, NbBundle.getMessage(RemoteUserInfo.class, (String)"TITLE_YN_Warning"), -1, 2, null, objectArray, objectArray[0]);
        }
        return n == 0;
    }

    public String getPassphrase() {
        return null;
    }

    public boolean promptPassphrase(String string) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean promptPassword(String string) {
        if (!this.isCancelled()) {
            boolean bl;
            if (this.passwd != null && this.passwd.length() > 0) {
                return true;
            }
            PasswordDlg passwordDlg = new PasswordDlg();
            Object object = DLGLOCK;
            synchronized (object) {
                bl = passwordDlg.askPassword(string);
            }
            if (bl) {
                this.passwd = passwordDlg.getPassword();
                return true;
            }
            this.passwd = "";
            this.cancelled = true;
            return false;
        }
        return false;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showMessage(String string) {
        Object object = DLGLOCK;
        synchronized (object) {
            JOptionPane.showMessageDialog(this.parent, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String[] promptKeyboardInteractive(String string, String string2, String string3, String[] stringArray, boolean[] blArray) {
        if (stringArray.length == 1 && !blArray[0]) {
            if (!this.promptPassword(NbBundle.getMessage(RemoteUserInfo.class, (String)"MSG_PasswordInteractive", (Object)string, (Object)stringArray[0]))) {
                return null;
            }
            return new String[]{this.getPassword()};
        }
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        this.gbc.weightx = 1.0;
        this.gbc.gridwidth = 0;
        this.gbc.gridx = 0;
        this.panel.add((Component)new JLabel(string3), this.gbc);
        ++this.gbc.gridy;
        this.gbc.gridwidth = -1;
        JTextField[] jTextFieldArray = new JTextField[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.gbc.fill = 0;
            this.gbc.gridx = 0;
            this.gbc.weightx = 1.0;
            this.panel.add((Component)new JLabel(stringArray[i]), this.gbc);
            this.gbc.gridx = 1;
            this.gbc.fill = 2;
            this.gbc.weighty = 1.0;
            jTextFieldArray[i] = blArray[i] ? new JTextField(20) : new JPasswordField(20);
            this.panel.add((Component)jTextFieldArray[i], this.gbc);
            ++this.gbc.gridy;
        }
        Object object = DLGLOCK;
        synchronized (object) {
            if (!this.isCancelled() && JOptionPane.showConfirmDialog(this.parent, this.panel, NbBundle.getMessage(RemoteUserInfo.class, (String)"TITLE_KeyboardInteractive", (Object)string, (Object)string2), 2, 3) == 0) {
                String[] stringArray2 = new String[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray2[i] = jTextFieldArray[i].getText();
                }
                return stringArray2;
            }
            this.cancelled = true;
            return null;
        }
    }

    private static void setParentComponent(final RemoteUserInfo remoteUserInfo) {
        if (SwingUtilities.isEventDispatchThread()) {
            remoteUserInfo.parent = WindowManager.getDefault().getMainWindow();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    remoteUserInfo.parent = WindowManager.getDefault().getMainWindow();
                }
            });
        }
    }

    static {
        DLGLOCK = new Object();
    }
}

