/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.support;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.netbeans.modules.cnd.remote.support.RemoteConnectionSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteInteractiveCommandSupport
extends RemoteConnectionSupport {
    private InputStream in;
    private OutputStream out;
    private final String cmd;
    private final Map<String, String> env;

    public RemoteInteractiveCommandSupport(String string, String string2, Map<String, String> map) {
        this(string, string2, map, null, null);
    }

    public RemoteInteractiveCommandSupport(String string, String string2, Map<String, String> map, InputStream inputStream, OutputStream outputStream) {
        super(string, 22);
        this.cmd = string2;
        this.env = map;
        this.in = inputStream;
        this.out = outputStream;
        if (!this.isFailedOrCancelled()) {
            log.fine("RemoteInteractiveCommandSupport<Init>: Running [" + string2 + "] on " + string);
            try {
                this.channel = this.createChannel();
            }
            catch (JSchException jSchException) {
                // empty catch block
            }
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.channel.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.channel.getOutputStream();
    }

    @Override
    protected Channel createChannel() throws JSchException {
        ChannelExec channelExec = (ChannelExec)this.session.openChannel("exec");
        StringBuilder stringBuilder = new StringBuilder();
        if (this.env != null) {
            for (String string : this.env.keySet()) {
                stringBuilder.append("export " + string + "=\"" + this.env.get(string) + "\";");
            }
        }
        stringBuilder.append(this.cmd);
        channelExec.setCommand(stringBuilder.toString());
        channelExec.setInputStream(this.in);
        channelExec.setOutputStream(this.out);
        channelExec.setErrStream(this.out);
        channelExec.connect();
        return channelExec;
    }
}

