/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.support;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import org.netbeans.modules.cnd.remote.support.RemoteConnectionSupport;
import org.openide.util.Exceptions;

public class RemoteCopySupport
extends RemoteConnectionSupport {
    public RemoteCopySupport(String string, int n) {
        super(string, n);
        this.revitalize();
    }

    public RemoteCopySupport(String string) {
        this(string, 22);
    }

    private void setChannelCommand(String string) {
        ((ChannelExec)this.getChannel()).setCommand(string);
    }

    private void revitalize() {
        try {
            this.channel = null;
            this.channel = this.createChannel();
        }
        catch (JSchException jSchException) {
            Exceptions.printStackTrace((Throwable)jSchException);
        }
    }

    public static boolean copyFrom(String string, String string2, String string3) {
        RemoteCopySupport remoteCopySupport = new RemoteCopySupport(string);
        return remoteCopySupport.copyFrom(string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyFrom(String string, String string2) {
        if (this.channel == null) {
            return false;
        }
        FileOutputStream fileOutputStream = null;
        try {
            String string3 = null;
            if (new File(string2).isDirectory()) {
                string3 = string2 + File.separator;
            }
            String string4 = "scp -f " + string;
            this.setChannelCommand(string4);
            OutputStream outputStream = this.channel.getOutputStream();
            InputStream inputStream = this.channel.getInputStream();
            this.channel.connect();
            byte[] byArray = new byte[1024];
            byArray[0] = 0;
            outputStream.write(byArray, 0, 1);
            outputStream.flush();
            while (true) {
                long l = System.currentTimeMillis();
                int n = RemoteCopySupport.checkAck(inputStream);
                if (n != 67) {
                    break;
                }
                inputStream.read(byArray, 0, 5);
                long l2 = 0L;
                while (inputStream.read(byArray, 0, 1) >= 0 && byArray[0] != 32) {
                    l2 = l2 * 10L + (long)(byArray[0] - 48);
                }
                String string5 = null;
                int n2 = 0;
                while (true) {
                    inputStream.read(byArray, n2, 1);
                    if (byArray[n2] == 10) break;
                    ++n2;
                }
                string5 = new String(byArray, 0, n2);
                byArray[0] = 0;
                outputStream.write(byArray, 0, 1);
                outputStream.flush();
                fileOutputStream = new FileOutputStream(string3 == null ? string2 : string3 + string5);
                do {
                    n2 = (long)byArray.length < l2 ? byArray.length : (int)l2;
                    if ((n2 = inputStream.read(byArray, 0, n2)) < 0) break;
                    fileOutputStream.write(byArray, 0, n2);
                } while ((l2 -= (long)n2) != 0L);
                fileOutputStream.close();
                fileOutputStream = null;
                if (RemoteCopySupport.checkAck(inputStream) != 0) {
                    System.exit(0);
                }
                byArray[0] = 0;
                outputStream.write(byArray, 0, 1);
                outputStream.flush();
                System.err.println("Copying: filesize=" + l2 + "b, file=" + string5 + " took " + (System.currentTimeMillis() - l) + " ms");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.channel.isConnected()) {
                this.setExitStatus(this.channel.getExitStatus());
                this.channel.disconnect();
            }
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (Exception exception) {}
        }
        this.revitalize();
        return this.getExitStatus() == 0;
    }

    public static boolean copyTo(String string, String string2, String string3) {
        RemoteCopySupport remoteCopySupport = new RemoteCopySupport(string);
        return remoteCopySupport.copyTo(string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyTo(String string, String string2) {
        if (this.channel == null) {
            return false;
        }
        FileInputStream fileInputStream = null;
        try {
            int n;
            String string3 = "scp -p -t " + string2;
            this.setChannelCommand(string3);
            OutputStream outputStream = this.channel.getOutputStream();
            InputStream inputStream = this.channel.getInputStream();
            this.channel.connect();
            if (RemoteCopySupport.checkAck(inputStream) != 0) {
                System.exit(0);
            }
            long l = new File(string).length();
            string3 = "C0644 " + l + " ";
            string3 = string.lastIndexOf(File.separator) > 0 ? string3 + string.substring(string.lastIndexOf(File.separator) + 1) : string3 + string;
            string3 = string3 + "\n";
            outputStream.write(string3.getBytes());
            outputStream.flush();
            if (RemoteCopySupport.checkAck(inputStream) != 0) {
                System.exit(0);
            }
            fileInputStream = new FileInputStream(string);
            byte[] byArray = new byte[1024];
            while ((n = fileInputStream.read(byArray, 0, byArray.length)) > 0) {
                outputStream.write(byArray, 0, n);
            }
            fileInputStream.close();
            fileInputStream = null;
            byArray[0] = 0;
            outputStream.write(byArray, 0, 1);
            outputStream.flush();
            if (RemoteCopySupport.checkAck(inputStream) != 0) {
                System.exit(0);
            }
            outputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.channel.isConnected()) {
                this.channel.disconnect();
            }
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception exception) {}
        }
        return this.getExitStatus() == 0;
    }

    private static int checkAck(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == 0) {
            return n;
        }
        if (n == -1) {
            return n;
        }
        if (n == 1 || n == 2) {
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            do {
                n2 = inputStream.read();
                stringBuffer.append((char)n2);
            } while (n2 != 10);
            if (n == 1) {
                System.out.print(stringBuffer.toString());
            }
            if (n == 2) {
                System.out.print(stringBuffer.toString());
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run(String string) {
        if (this.channel == null) {
            return false;
        }
        try {
            String string2;
            long l = System.currentTimeMillis();
            this.setChannelCommand(string);
            InputStream inputStream = this.channel.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StringWriter stringWriter = new StringWriter();
            this.channel.connect();
            while ((string2 = bufferedReader.readLine()) != null || !this.channel.isClosed()) {
                if (string2 != null) {
                    stringWriter.write(string2);
                    stringWriter.flush();
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
            bufferedReader.close();
            inputStream.close();
            System.err.println("run `" + string + "` took " + (System.currentTimeMillis() - l) + " ms.");
            String string3 = stringWriter.toString();
            if (string3.length() > 0) {
                System.err.println(string3);
            }
        }
        catch (JSchException jSchException) {
            Exceptions.printStackTrace((Throwable)jSchException);
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.channel.isConnected()) {
                this.channel.disconnect();
            }
        }
        this.revitalize();
        return true;
    }
}

