/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.server;

import java.beans.PropertyChangeSupport;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.remote.server.RemoteServerSetup;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class RemoteServerRecord
implements ServerRecord {
    public static final Object STATE_UNINITIALIZED = "STATE_UNINITIALIZED";
    public static final Object STATE_INITIALIZING = "STATE_INITIALIZING";
    public static final Object STATE_ONLINE = "STATE_ONLINE";
    public static final Object STATE_OFFLINE = "STATE_OFFLINE";
    public static final Object STATE_CANCELLED = "STATE_CANCELLED";
    public static final String PROP_STATE_CHANGED = "stateChanged";
    private final String user;
    private final String server;
    private final String name;
    private final boolean editable;
    private Object state;
    private final Object stateLock;
    private String reason;
    private static final Logger log = Logger.getLogger("cnd.remote.logger");

    protected RemoteServerRecord(String string) {
        this.name = string;
        int n = string.indexOf(64);
        if (n != -1) {
            this.user = string.substring(0, n);
            this.server = string.substring(n + 1);
        } else {
            this.user = "";
            this.server = string;
        }
        this.stateLock = new String("RemoteServerRecord state lock for " + string);
        this.reason = null;
        if (string.equals("localhost")) {
            this.editable = false;
            this.state = STATE_ONLINE;
        } else {
            this.editable = true;
            this.state = STATE_UNINITIALIZED;
        }
    }

    public void validate() {
        if (!this.isOnline()) {
            if (SwingUtilities.isEventDispatchThread()) {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        RemoteServerRecord.this.validateOutOfEDT();
                    }
                });
            } else {
                this.validateOutOfEDT();
            }
        }
    }

    private void validateOutOfEDT() {
        log.fine("RSR.validate2: Validating " + this.name);
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(RemoteServerRecord.class, (String)"PBAR_ConnectingTo", (Object)this.name));
        progressHandle.start();
        this.init(null);
        progressHandle.finish();
        String string = this.isOnline() ? NbBundle.getMessage(RemoteServerRecord.class, (String)"Validation_OK", (Object)this.name) : NbBundle.getMessage(RemoteServerRecord.class, (String)"Validation_ERR", (Object)this.name, (Object)this.getStateAsText(), (Object)this.getReason());
        StatusDisplayer.getDefault().setStatusText(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init(PropertyChangeSupport propertyChangeSupport) {
        assert (!SwingUtilities.isEventDispatchThread()) : "RemoteServer initialization must be done out of EDT";
        Object object = this.state;
        if (this.state != STATE_UNINITIALIZED) {
            return;
        }
        this.state = STATE_INITIALIZING;
        RemoteServerSetup remoteServerSetup = new RemoteServerSetup(this.name);
        if (remoteServerSetup.needsSetupOrUpdate()) {
            remoteServerSetup.setup();
        }
        Object object2 = this.stateLock;
        synchronized (object2) {
            if (remoteServerSetup.isCancelled()) {
                this.state = STATE_CANCELLED;
            } else if (remoteServerSetup.isFailed()) {
                this.state = STATE_OFFLINE;
                this.reason = remoteServerSetup.getReason();
            } else {
                this.state = STATE_ONLINE;
                CompilerSetManager.getDefault((String)this.name);
            }
        }
        if (propertyChangeSupport != null) {
            propertyChangeSupport.firePropertyChange(PROP_STATE_CHANGED, object, this.state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resetOfflineState() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state != STATE_INITIALIZING && this.state != STATE_ONLINE) {
                this.state = STATE_UNINITIALIZED;
                return true;
            }
        }
        return false;
    }

    public String getStateAsText() {
        return NbBundle.getMessage(RemoteServerRecord.class, (String)this.state.toString());
    }

    public boolean isOnline() {
        return this.state == STATE_ONLINE;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isRemote() {
        return !this.name.equals("localhost");
    }

    public String getName() {
        return this.name;
    }

    public String getServerName() {
        return this.server;
    }

    public String getUserName() {
        return this.user;
    }

    public String getReason() {
        return this.reason;
    }
}

