/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FCLSupport;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.util.io.NbMarshalledObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Repository
implements Serializable {
    static final long serialVersionUID = -6344768369160069704L;
    private ArrayList<FileSystem> fileSystems;
    private transient ArrayList<FileSystem> fileSystemsClone;
    private FileSystem system;
    private Hashtable<String, FileSystem> names;
    private transient FCLSupport fclSupport;
    private Hashtable<RepositoryListener, RepositoryListener> listeners = new Hashtable();
    private VetoableChangeListener vetoListener = new VetoableChangeListener(){

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (propertyChangeEvent.getPropertyName().equals("systemName")) {
                String string = (String)propertyChangeEvent.getOldValue();
                String string2 = (String)propertyChangeEvent.getNewValue();
                if (Repository.this.names.get(string2) != null) {
                    throw new PropertyVetoException("system name already exists: " + string + " -> " + string2, propertyChangeEvent);
                }
            }
        }
    };
    private PropertyChangeListener propListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("systemName")) {
                String string = (String)propertyChangeEvent.getOldValue();
                String string2 = (String)propertyChangeEvent.getNewValue();
                FileSystem fileSystem = (FileSystem)propertyChangeEvent.getSource();
                if (fileSystem.isValid()) {
                    Repository.this.names.remove(string);
                }
                Repository.this.names.put(string2, fileSystem);
                fileSystem.setValid(true);
            }
        }
    };

    public Repository(FileSystem fileSystem) {
        this.system = fileSystem;
        this.init();
    }

    public static Repository getDefault() {
        return ExternalUtil.getRepository();
    }

    private void init() {
        this.fileSystems = new ArrayList();
        this.names = new Hashtable();
        if (ExternalUtil.addFileSystemDelayed(this.system)) {
            this.addFileSystem(this.system);
        }
    }

    public final FileSystem getDefaultFileSystem() {
        return this.system;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void addFileSystem(FileSystem fileSystem) {
        boolean bl = false;
        Repository repository = this;
        synchronized (repository) {
            if (!fileSystem.assigned && !this.fileSystems.contains(fileSystem)) {
                boolean bl2;
                fileSystem.setRepository(this);
                this.fileSystems.add(fileSystem);
                this.fileSystemsClone = new ArrayList<FileSystem>(this.fileSystems);
                String string = fileSystem.getSystemName();
                boolean bl3 = bl2 = this.names.get(string) == null;
                if (bl2 && !string.equals("")) {
                    this.names.put(string, fileSystem);
                    fileSystem.setValid(true);
                } else {
                    fileSystem.setValid(false);
                }
                fileSystem.assigned = true;
                fileSystem.addPropertyChangeListener(this.propListener);
                fileSystem.addVetoableChangeListener(this.vetoListener);
                fileSystem.addNotify();
                bl = true;
            }
        }
        if (bl) {
            this.fireFileSystem(fileSystem, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void removeFileSystem(FileSystem fileSystem) {
        boolean bl = false;
        Repository repository = this;
        synchronized (repository) {
            if (fileSystem.isDefault()) {
                return;
            }
            bl = this.fileSystems.remove(fileSystem);
            if (bl) {
                fileSystem.setRepository(null);
                this.fileSystemsClone = new ArrayList<FileSystem>(this.fileSystems);
                if (fileSystem.isValid()) {
                    this.names.remove(fileSystem.getSystemName());
                    fileSystem.setValid(false);
                }
                fileSystem.removePropertyChangeListener(this.propListener);
                fileSystem.removeVetoableChangeListener(this.vetoListener);
                fileSystem.removeNotify();
            }
            fileSystem.assigned = false;
        }
        if (bl) {
            this.fireFileSystem(fileSystem, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void reorder(int[] nArray) {
        Repository repository = this;
        synchronized (repository) {
            if (nArray == null) {
                throw new IllegalArgumentException("null permutation");
            }
            if (nArray.length != this.fileSystems.size()) {
                throw new IllegalArgumentException("permutation is wrong size: " + nArray.length + " elements but should be " + this.fileSystems.size());
            }
            if (!Repository.isPermutation(nArray)) {
                StringBuffer stringBuffer = new StringBuffer("permutation is not really a permutation:");
                for (int i = 0; i < nArray.length; ++i) {
                    stringBuffer.append(' ');
                    stringBuffer.append(nArray[i]);
                }
                throw new IllegalArgumentException(stringBuffer.toString());
            }
            ArrayList<FileSystem> arrayList = new ArrayList<FileSystem>(this.fileSystems.size());
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                arrayList.add(this.fileSystems.get(nArray[i]));
            }
            this.fileSystems = arrayList;
            this.fileSystemsClone = new ArrayList<FileSystem>(this.fileSystems);
        }
        this.fireFileSystemReordered(nArray);
    }

    private static boolean isPermutation(int[] nArray) {
        int n = nArray.length;
        boolean[] blArray = new boolean[n];
        try {
            for (int i = 0; i < n; ++i) {
                if (blArray[nArray[i]]) {
                    return false;
                }
                blArray[nArray[i]] = true;
            }
            return true;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
    }

    @Deprecated
    public final Enumeration<? extends FileSystem> getFileSystems() {
        ArrayList<FileSystem> arrayList = this.fileSystemsClone;
        return Collections.enumeration(arrayList);
    }

    @Deprecated
    public final Enumeration<? extends FileSystem> fileSystems() {
        return this.getFileSystems();
    }

    @Deprecated
    public final FileSystem[] toArray() {
        ArrayList<FileSystem> arrayList = this.fileSystemsClone;
        FileSystem[] fileSystemArray = new FileSystem[arrayList.size()];
        arrayList.toArray(fileSystemArray);
        return fileSystemArray;
    }

    @Deprecated
    public final FileSystem findFileSystem(String string) {
        FileSystem fileSystem = this.names.get(string);
        return fileSystem;
    }

    @Deprecated
    public final synchronized void writeExternal(ObjectOutput objectOutput) throws IOException {
        for (FileSystem fileSystem : this.fileSystems) {
            if (fileSystem.isDefault() || fileSystem.isPersistent()) continue;
            objectOutput.writeObject(new NbMarshalledObject((Object)fileSystem));
        }
        objectOutput.writeObject(null);
    }

    @Deprecated
    public final synchronized void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Object object;
        FileSystem fileSystem;
        Enumeration<? extends FileSystem> enumeration;
        ArrayList<FileSystem> arrayList = new ArrayList<FileSystem>(10);
        while ((enumeration = objectInput.readObject()) != null) {
            if (enumeration instanceof FileSystem) {
                fileSystem = (FileSystem)((Object)enumeration);
            } else {
                try {
                    object = (NbMarshalledObject)enumeration;
                    fileSystem = (FileSystem)object.get();
                }
                catch (IOException iOException) {
                    ExternalUtil.exception(iOException);
                    fileSystem = null;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ExternalUtil.exception(classNotFoundException);
                    fileSystem = null;
                }
            }
            if (fileSystem == null) continue;
            arrayList.add(fileSystem);
        }
        enumeration = this.getFileSystems();
        while (enumeration.hasMoreElements()) {
            fileSystem = enumeration.nextElement();
            if (fileSystem.isPersistent()) continue;
            this.removeFileSystem(fileSystem);
        }
        this.system.assigned = false;
        this.init();
        object = arrayList.iterator();
        while (object.hasNext()) {
            this.addFileSystem((FileSystem)object.next());
        }
    }

    @Deprecated
    public final FileObject find(String string, String string2, String string3) {
        assert (FileUtil.assertDeprecatedMethod());
        Enumeration<? extends FileSystem> enumeration = this.getFileSystems();
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem = enumeration.nextElement();
            FileObject fileObject = fileSystem.find(string, string2, string3);
            if (fileObject == null) continue;
            return fileObject;
        }
        return null;
    }

    @Deprecated
    public final FileObject findResource(String string) {
        assert (FileUtil.assertDeprecatedMethod());
        Enumeration<? extends FileSystem> enumeration = this.getFileSystems();
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem = enumeration.nextElement();
            FileObject fileObject = fileSystem.findResource(string);
            if (fileObject == null) continue;
            return fileObject;
        }
        return null;
    }

    @Deprecated
    public final Enumeration<? extends FileObject> findAllResources(String string) {
        assert (FileUtil.assertDeprecatedMethod());
        Vector<FileObject> vector = new Vector<FileObject>(8);
        Enumeration<? extends FileSystem> enumeration = this.getFileSystems();
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem = enumeration.nextElement();
            FileObject fileObject = fileSystem.findResource(string);
            if (fileObject == null) continue;
            vector.addElement(fileObject);
        }
        return vector.elements();
    }

    @Deprecated
    public final Enumeration<? extends FileObject> findAll(String string, String string2, String string3) {
        assert (FileUtil.assertDeprecatedMethod());
        Enumeration<? extends FileSystem> enumeration = this.getFileSystems();
        Vector<FileObject> vector = new Vector<FileObject>();
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem = enumeration.nextElement();
            FileObject fileObject = fileSystem.find(string, string2, string3);
            if (fileObject == null) continue;
            vector.addElement(fileObject);
        }
        return vector.elements();
    }

    private void fireFileSystem(FileSystem fileSystem, boolean bl) {
        RepositoryEvent repositoryEvent = new RepositoryEvent(this, fileSystem, bl);
        for (RepositoryListener repositoryListener : new HashSet<RepositoryListener>(this.listeners.values())) {
            if (bl) {
                repositoryListener.fileSystemAdded(repositoryEvent);
                continue;
            }
            repositoryListener.fileSystemRemoved(repositoryEvent);
        }
    }

    private void fireFileSystemReordered(int[] nArray) {
        RepositoryReorderedEvent repositoryReorderedEvent = new RepositoryReorderedEvent(this, nArray);
        for (RepositoryListener repositoryListener : new HashSet<RepositoryListener>(this.listeners.values())) {
            repositoryListener.fileSystemPoolReordered(repositoryReorderedEvent);
        }
    }

    @Deprecated
    public final void addRepositoryListener(RepositoryListener repositoryListener) {
        this.listeners.put(repositoryListener, repositoryListener);
    }

    @Deprecated
    public final void removeRepositoryListener(RepositoryListener repositoryListener) {
        this.listeners.remove(repositoryListener);
    }

    private Object writeReplace() {
        return new Replacer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final FCLSupport getFCLSupport() {
        Class<FCLSupport> clazz = FCLSupport.class;
        synchronized (FCLSupport.class) {
            if (this.fclSupport == null) {
                this.fclSupport = new FCLSupport();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.fclSupport;
        }
    }

    @Deprecated
    public final void addFileChangeListener(FileChangeListener fileChangeListener) {
        this.getFCLSupport().addFileChangeListener(fileChangeListener);
    }

    @Deprecated
    public final void removeFileChangeListener(FileChangeListener fileChangeListener) {
        this.getFCLSupport().removeFileChangeListener(fileChangeListener);
    }

    private static class Replacer
    implements Serializable {
        static final long serialVersionUID = -3814531276726840241L;

        Replacer() {
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            ExternalUtil.getRepository().writeExternal(objectOutputStream);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            ExternalUtil.getRepository().readExternal(objectInputStream);
        }

        public Object readResolve() {
            return ExternalUtil.getRepository();
        }
    }
}

