/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileObject;
import org.openide.util.NbCollections;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Ordering {
    private static final Logger LOG = Logger.getLogger(Ordering.class.getName());
    private static final String ATTR_POSITION = "position";

    private Ordering() {
    }

    /*
     * WARNING - void declaration
     */
    static List<FileObject> getOrder(Collection<FileObject> collection, final boolean bl) throws IllegalArgumentException {
        Object object;
        Object object222;
        Iterator iterator;
        Serializable serializable;
        LOG.log(Level.FINE, "getOrder for {0}", collection);
        Iterator<FileObject> iterator2 = collection.iterator();
        if (!iterator2.hasNext()) {
            return Collections.emptyList();
        }
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ChildAndPosition
        implements Comparable<ChildAndPosition> {
            final FileObject child;
            private final Number position;

            ChildAndPosition(FileObject fileObject, Number number) {
                this.child = fileObject;
                this.position = number;
            }

            @Override
            public int compareTo(ChildAndPosition childAndPosition) {
                int n;
                if (this.position instanceof Float || this.position instanceof Double || childAndPosition.position instanceof Float || childAndPosition.position instanceof Double) {
                    n = Double.compare(this.position.doubleValue(), childAndPosition.position.doubleValue());
                } else {
                    long l;
                    long l2 = this.position.longValue();
                    int n2 = l2 < (l = childAndPosition.position.longValue()) ? -1 : (n = l2 == l ? 0 : 1);
                }
                if (n != 0) {
                    return n;
                }
                if (bl && childAndPosition != this && !this.position.equals(0)) {
                    LOG.warning("Found same position " + this.position + " for both " + childAndPosition.child.getPath() + " and " + this.child.getPath());
                }
                return this.child.getNameExt().compareTo(childAndPosition.child.getNameExt());
            }
        }
        TreeSet<ChildAndPosition> treeSet = new TreeSet<ChildAndPosition>();
        FileObject fileObject = null;
        while (iterator2.hasNext()) {
            serializable = iterator2.next();
            if (hashMap.put(((FileObject)serializable).getNameExt(), serializable) != null) {
                throw new IllegalArgumentException("Duplicate in children list: " + ((FileObject)serializable).getPath());
            }
            iterator = ((FileObject)serializable).getAttribute(ATTR_POSITION);
            if (iterator instanceof Number) {
                treeSet.add(new ChildAndPosition((FileObject)serializable, (Number)((Object)iterator)));
            } else if (bl && iterator != null) {
                LOG.warning("Encountered nonnumeric position attribute " + iterator + " of " + iterator.getClass() + " for " + ((FileObject)serializable).getPath());
            }
            if (fileObject == null) {
                fileObject = ((FileObject)serializable).getParent();
                continue;
            }
            if (((FileObject)serializable).getParent() == fileObject) continue;
            throw new IllegalArgumentException("All children must have the same parent: " + ((FileObject)serializable).getParent().getPath() + " vs. " + fileObject.getPath());
        }
        serializable = new HashMap();
        for (Object object222 : NbCollections.iterable(fileObject.getAttributes())) {
            int n = ((String)object222).indexOf(47);
            if (n == -1) continue;
            Object collection22 = fileObject.getAttribute((String)object222);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("  reading attribute " + fileObject + "(" + object222 + ") -> " + collection22);
            }
            if (!Boolean.TRUE.equals(collection22)) {
                if (!bl || collection22 == null || collection22 instanceof Boolean) continue;
                LOG.warning("Encountered non-boolean relative ordering attribute " + collection22 + " from " + (String)object222 + " on " + fileObject.getPath());
                continue;
            }
            object = (FileObject)hashMap.get(((String)object222).substring(0, n));
            FileObject fileObject2 = (FileObject)hashMap.get(((String)object222).substring(n + 1));
            if (object != null && fileObject2 != null) {
                HashSet<FileObject> hashSet = (HashSet<FileObject>)serializable.get(object);
                if (hashSet == null) {
                    hashSet = new HashSet<FileObject>();
                    serializable.put(object, hashSet);
                }
                hashSet.add(fileObject2);
                if (!bl) continue;
                LOG.warning("Relative ordering attribute " + (String)object222 + " on " + fileObject.getPath() + " is deprecated in favor of numeric position attributes");
                continue;
            }
            if (!bl) continue;
            LOG.warning("Could not find both sides of relative ordering attribute " + (String)object222 + " on " + fileObject.getPath());
        }
        iterator = treeSet.iterator();
        if (iterator.hasNext()) {
            object222 = ((ChildAndPosition)iterator.next()).child;
            while (iterator.hasNext()) {
                void var10_17;
                FileObject fileObject2 = ((ChildAndPosition)iterator.next()).child;
                Set set = (Set)serializable.get(object222);
                if (set == null) {
                    HashSet hashSet = new HashSet();
                    serializable.put(object222, hashSet);
                }
                var10_17.add(fileObject2);
                object222 = fileObject2;
            }
        }
        if (bl && !treeSet.isEmpty() && treeSet.size() < collection.size()) {
            object222 = new ArrayList<FileObject>(collection);
            for (ChildAndPosition childAndPosition : treeSet) {
                object222.remove(childAndPosition.child);
            }
            if (!object222.isEmpty()) {
                ArrayList arrayList = new ArrayList(object222.size());
                Iterator iterator3 = object222.iterator();
                while (iterator3.hasNext()) {
                    object = (FileObject)iterator3.next();
                    arrayList.add(((FileObject)object).getNameExt());
                }
                ArrayList<String> arrayList2 = new ArrayList<String>(treeSet.size());
                for (ChildAndPosition childAndPosition : treeSet) {
                    arrayList2.add(childAndPosition.child.getNameExt());
                }
                LOG.warning("Not all children in " + fileObject.getPath() + "/ marked with the position attribute: " + arrayList + ", but some are: " + arrayList2);
            }
        }
        if (serializable.isEmpty()) {
            return new ArrayList<FileObject>(collection);
        }
        try {
            return Utilities.topologicalSort(collection, (Map)((Object)serializable));
        }
        catch (TopologicalSortException topologicalSortException) {
            if (bl) {
                LOG.log(Level.WARNING, "Contradictory partial ordering in " + fileObject.getPath(), topologicalSortException);
            }
            return NbCollections.checkedListByCopy((List)topologicalSortException.partialSort(), FileObject.class, (boolean)true);
        }
    }

    static void setOrder(List<FileObject> list) throws IllegalArgumentException, IOException {
        int n;
        List<FileObject> list2;
        FileObject fileObject2;
        boolean bl = true;
        for (FileObject fileObject2 : list) {
            if (Ordering.findPosition(fileObject2) != null) continue;
            bl = false;
            break;
        }
        Object object = null;
        fileObject2 = null;
        FileObject fileObject3 = null;
        if (bl) {
            int n2;
            list2 = Ordering.getOrder(list, false);
            if (((Object)list).equals(list2)) {
                return;
            }
            int n3 = list.size();
            for (n = 0; n < n3 && list.get(n).equals(list2.get(n)); ++n) {
            }
            for (n2 = n3 - 1; n2 >= 0 && list.get(n2).equals(list2.get(n2)); --n2) {
            }
            int n4 = n2 - n + 1;
            if (n4 > 2) {
                if (list.get(n2).equals(list2.get(n)) && ((Object)list.subList(n, n2)).equals(list2.subList(n + 1, n2 + 1))) {
                    object = list.get(n2);
                    fileObject2 = list.get(n2 - 1);
                    fileObject3 = n2 + 1 < n3 ? list.get(n2 + 1) : null;
                } else if (list.get(n).equals(list2.get(n2)) && ((Object)list.subList(n + 1, n2 + 1)).equals(list2.subList(n, n2))) {
                    object = list.get(n);
                    fileObject2 = n - 1 >= 0 ? list.get(n - 1) : null;
                    fileObject3 = list.get(n + 1);
                }
            } else if (n4 == 2) {
                if (n == 0) {
                    object = list.get(n);
                    fileObject3 = list.get(n2);
                } else if (n2 == n3 - 1) {
                    object = list.get(n2);
                    fileObject2 = list.get(n);
                } else {
                    Float f = Ordering.findPosition(list.get(n - 1));
                    Float f2 = Ordering.findPosition(list.get(n2 + 1));
                    Float f3 = Ordering.findPosition(list.get(n));
                    Float f4 = Ordering.findPosition(list.get(n2));
                    if (f != null && f2 != null && f3 != null && f4 != null) {
                        if (f3.floatValue() - f.floatValue() < f2.floatValue() - f4.floatValue()) {
                            object = list.get(n2);
                            fileObject2 = list.get(n);
                            fileObject3 = list.get(n2 + 1);
                        } else {
                            object = list.get(n);
                            fileObject2 = list.get(n - 1);
                            fileObject3 = list.get(n2);
                        }
                    }
                }
            } else assert (n4 == 0) : list2 + " => " + list;
        } else if (list.size() > 1) {
            list2 = null;
            for (FileObject fileObject4 : list) {
                if (Ordering.findPosition(fileObject4) != null) continue;
                if (list2 == null) {
                    list2 = fileObject4;
                    continue;
                }
                list2 = null;
                break;
            }
            if (list2 != null) {
                object = list2;
                int n5 = list.indexOf(list2);
                fileObject2 = n5 == 0 ? null : list.get(n5 - 1);
                FileObject fileObject5 = fileObject3 = n5 == list.size() - 1 ? null : list.get(n5 + 1);
            }
        }
        if (object != null) {
            if (fileObject2 == null) {
                ((FileObject)object).setAttribute(ATTR_POSITION, Math.round(Ordering.findPosition(fileObject3).floatValue() - 100.0f));
            } else if (fileObject3 == null) {
                ((FileObject)object).setAttribute(ATTR_POSITION, Math.round(Ordering.findPosition(fileObject2).floatValue() + 100.0f));
            } else {
                list2 = Ordering.findPosition(fileObject2);
                Float f = Ordering.findPosition(fileObject3);
                n = Math.round(((Float)((Object)list2)).floatValue() + f.floatValue()) / 2;
                if (((Float)((Object)list2)).floatValue() < (float)n && (float)n < f.floatValue()) {
                    ((FileObject)object).setAttribute(ATTR_POSITION, n);
                } else {
                    object = null;
                }
            }
        }
        if (object == null) {
            int n6 = 100;
            for (FileObject fileObject6 : list) {
                fileObject6.setAttribute(ATTR_POSITION, n6);
                n6 += 100;
            }
        }
        FileObject fileObject7 = list.get(0).getParent();
        for (String string : NbCollections.iterable(fileObject7.getAttributes())) {
            if (string.indexOf(47) == -1 || !(fileObject7.getAttribute(string) instanceof Boolean)) continue;
            fileObject7.setAttribute(string, null);
        }
        boolean bl2 = false;
        if (!$assertionsDisabled) {
            bl2 = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (bl2) {
            List<FileObject> list3 = Ordering.getOrder(list, false);
            assert (((Object)list3).equals(list)) : "setOrder(" + list + ") -> " + list3;
        }
    }

    private static Float findPosition(FileObject fileObject) {
        Object object = fileObject.getAttribute(ATTR_POSITION);
        if (object instanceof Number) {
            return Float.valueOf(((Number)object).floatValue());
        }
        return null;
    }

    static boolean affectsOrder(FileAttributeEvent fileAttributeEvent) {
        String string = fileAttributeEvent.getName();
        if (string == null) {
            return true;
        }
        return string.equals(ATTR_POSITION) || fileAttributeEvent.getFile().isFolder() && string.indexOf(47) != -1;
    }
}

