/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.utils;

import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.support.ResolvedPath;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APTIncludeUtils {
    private static Lock maRefLock = new ReentrantLock();
    private static Lock mapFoldersRefLock = new ReentrantLock();
    private static Reference<Map<String, Boolean>> mapRef = new SoftReference(new ConcurrentHashMap());
    private static Reference<Map<String, Boolean>> mapFoldersRef = new SoftReference(new ConcurrentHashMap());

    private APTIncludeUtils() {
    }

    public static ResolvedPath resolveFilePath(String string, String string2) {
        String string3;
        File file;
        if (string2 != null && !APTIncludeUtils.isDirectory(file = new File(string3 = new File(string2).getParent(), string)) && APTIncludeUtils.exists(file)) {
            return new ResolvedPath(string3, file.getAbsolutePath(), true, 0);
        }
        return null;
    }

    public static ResolvedPath resolveAbsFilePath(String string) {
        File file;
        if (APTTraceFlags.APT_ABSOLUTE_INCLUDES && (file = new File(string)).isAbsolute() && !APTIncludeUtils.isDirectory(file) && APTIncludeUtils.exists(file)) {
            return new ResolvedPath(file.getParent(), string, false, 0);
        }
        return null;
    }

    public static void clearFileExistenceCache() {
        mapRef.clear();
        mapFoldersRef.clear();
    }

    public static ResolvedPath resolveFilePath(Iterator<String> iterator, String string, int n) {
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            File file = new File(new File(string2), string);
            if (!APTIncludeUtils.isDirectory(file) && APTIncludeUtils.exists(file)) {
                return new ResolvedPath(string2, file.getAbsolutePath(), false, n);
            }
            ++n;
        }
        return null;
    }

    private static boolean exists(File file) {
        if (APTTraceFlags.OPTIMIZE_INCLUDE_SEARCH) {
            String string = file.getAbsolutePath();
            Map<String, Boolean> map = APTIncludeUtils.getFilesMap();
            Boolean bl = map.get(string);
            if (bl == null) {
                bl = file.exists();
                map.put(((Object)FilePathCache.getString((CharSequence)string)).toString(), bl);
            }
            return bl;
        }
        return file.exists();
    }

    private static boolean isDirectory(File file) {
        if (APTTraceFlags.OPTIMIZE_INCLUDE_SEARCH) {
            String string = file.getAbsolutePath();
            Map<String, Boolean> map = APTIncludeUtils.getFoldersMap();
            Boolean bl = map.get(string);
            if (bl == null) {
                bl = file.isDirectory();
                map.put(((Object)FilePathCache.getString((CharSequence)string)).toString(), bl);
            }
            return bl;
        }
        return file.isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Boolean> getFilesMap() {
        Map<String, Boolean> map = mapRef.get();
        if (map == null) {
            try {
                maRefLock.lock();
                map = mapRef.get();
                if (map == null) {
                    map = new ConcurrentHashMap<String, Boolean>();
                    mapRef = new SoftReference<Map<String, Boolean>>(map);
                }
            }
            finally {
                maRefLock.unlock();
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Boolean> getFoldersMap() {
        Map<String, Boolean> map = mapFoldersRef.get();
        if (map == null) {
            try {
                mapFoldersRefLock.lock();
                map = mapFoldersRef.get();
                if (map == null) {
                    map = new ConcurrentHashMap<String, Boolean>();
                    mapFoldersRef = new SoftReference<Map<String, Boolean>>(map);
                }
            }
            finally {
                mapFoldersRefLock.unlock();
            }
        }
        return map;
    }
}

