/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.support;

import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.TokenStreamSelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.modules.cnd.apt.debug.DebugUtils;
import org.netbeans.modules.cnd.apt.impl.support.APTSystemMacroMap;
import org.netbeans.modules.cnd.apt.support.APTMacro;
import org.netbeans.modules.cnd.apt.support.APTMacroCallback;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.support.APTTokenStreamBuilder;
import org.netbeans.modules.cnd.apt.utils.APTCommentsFilter;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.apt.utils.ListBasedTokenStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APTExpandedStream
implements TokenStream {
    private final TokenStreamSelector selector = new TokenStreamSelector();
    private final APTMacroCallback callback;
    private boolean extractingMacroParams = false;
    private final boolean expandPPExpression;
    private Token paramsRParen = null;
    private static final int BODY_STREAM = 0;
    private static final int STRINGIZE_PARAM = 1;
    private static final int CONCATENATE = 2;
    private static final long MACRO_EXPANDING_THREASHOLD = 16384L;

    public APTExpandedStream(TokenStream tokenStream, APTMacroCallback aPTMacroCallback, boolean bl) {
        this.selector.select(tokenStream);
        this.callback = aPTMacroCallback;
        this.expandPPExpression = bl;
        assert (!(aPTMacroCallback instanceof APTSystemMacroMap)) : "system macro map can't be used as callback";
    }

    public APTExpandedStream(TokenStream tokenStream, APTMacroCallback aPTMacroCallback) {
        this(tokenStream, aPTMacroCallback, false);
    }

    public Token nextToken() throws TokenStreamException {
        Token token;
        boolean bl;
        do {
            token = this.selector.nextToken();
            if (this.extractingMacroParams) {
                return token;
            }
            bl = false;
            if (APTUtils.isID(token)) {
                APTMacro aPTMacro = this.callback.getMacro(token);
                if (aPTMacro == null || this.callback.isExpanding(token)) continue;
                bl = this.pushMacroExpanding(token, aPTMacro);
                continue;
            }
            if (!APTUtils.isEOF(token)) continue;
            bl = this.continueOnEOF();
        } while (bl);
        return token;
    }

    private boolean isExpandingPPExpression() {
        return this.expandPPExpression;
    }

    private boolean pushMacroExpanding(Token token, APTMacro aPTMacro) throws TokenStreamException {
        boolean bl = true;
        try {
            TokenStream tokenStream = this.createMacroBodyWrapper(token, aPTMacro);
            bl = this.callback.pushExpanding(token);
            if (bl) {
                this.selector.push(tokenStream);
            }
        }
        catch (RecognitionException recognitionException) {
            APTUtils.LOG.log(Level.SEVERE, "error on expanding " + token, recognitionException);
            bl = false;
        }
        return bl;
    }

    private boolean popMacroExpanding() {
        boolean bl = true;
        this.callback.popExpanding();
        this.selector.pop();
        return bl;
    }

    protected TokenStream createMacroBodyWrapper(Token token, APTMacro aPTMacro) throws TokenStreamException, RecognitionException {
        assert (aPTMacro != null) : "must be valid macro object";
        assert (aPTMacro.getName() != null) : "macro object must have valid name token";
        assert (!this.callback.isExpanding(aPTMacro.getName())) : "macro must not be under recursive expanding";
        Object object = null;
        this.paramsRParen = null;
        if (!aPTMacro.isFunctionLike()) {
            object = new APTCommentsFilter(aPTMacro.getBody());
            if (this.isExpandingPPExpression()) {
                object = APTUtils.isEOF(object.nextToken()) ? new ListBasedTokenStream(APTUtils.DEF_MACRO_BODY) : new APTCommentsFilter(aPTMacro.getBody());
            }
        } else {
            boolean bl;
            Token token2 = null;
            do {
                bl = false;
                while (APTUtils.isCommentToken(token2 = this.selector.nextToken())) {
                }
            } while (bl = APTUtils.isEOF(token2) && this.continueOnEOF());
            if (token2.getType() == 137) {
                List<List<Token>> list = this.extractParams(aPTMacro, token, token2);
                List<Token> list2 = APTExpandedStream.subsituteParams(aPTMacro, list, this.callback, this.isExpandingPPExpression());
                object = new ListBasedTokenStream(list2);
            } else {
                ArrayList<Token> arrayList = new ArrayList<Token>(2);
                arrayList.add(token);
                arrayList.add(token2);
                object = new ListBasedTokenStream(arrayList);
            }
        }
        APTUtils.LOG.log(Level.INFO, "token {0} \n was expanded by macro substitution to \n {1}", new Object[]{token, object});
        return object;
    }

    private boolean continueOnEOF() {
        boolean bl = false;
        if (!this.selector.isEmpty()) {
            bl = this.popMacroExpanding();
        }
        return bl;
    }

    protected Token getLastExtractedParamRPAREN() {
        return this.paramsRParen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<List<Token>> extractParams(APTMacro aPTMacro, Token token, Token token2) throws TokenStreamException, RecognitionException {
        assert (!this.extractingMacroParams) : "already extracting params";
        this.extractingMacroParams = true;
        ArrayList<List<Token>> arrayList = new ArrayList<List<Token>>();
        try {
            if (token2.getType() != 137) {
                throw new RecognitionException("Error on expanding " + token + "\n by macro " + aPTMacro + "\n Expecting LPAREN, found " + token2);
            }
            int n = 0;
            ArrayList<Object> arrayList2 = new ArrayList<Token>();
            token2 = this.nextToken();
            while (!APTUtils.isEOF(token2) || this.continueOnEOF()) {
                int n2 = token2.getType();
                if (n2 == 137) {
                    this.add2Param(arrayList2, token2);
                    ++n;
                } else if (n2 == 138) {
                    if (n == 0) {
                        arrayList.add(arrayList2);
                        arrayList2 = null;
                        this.paramsRParen = token2;
                        break;
                    }
                    this.add2Param(arrayList2, token2);
                    if (--n < 0) {
                        throw new RecognitionException("Error on expanding " + token + "\n by macro " + aPTMacro + "\n Unbalanced RPAREN " + token2);
                    }
                } else if (n2 == 133 && n == 0) {
                    arrayList.add(arrayList2);
                    arrayList2 = new ArrayList();
                } else {
                    this.add2Param(arrayList2, token2);
                }
                token2 = this.nextToken();
            }
            if (APTUtils.isEOF(token2)) {
                APTUtils.LOG.log(Level.SEVERE, "error expanding macro " + token + " : unterminated arguments list");
            }
        }
        finally {
            this.extractingMacroParams = false;
        }
        return arrayList;
    }

    private void add2Param(List<Token> list, Token token) {
        if (!APTUtils.isCommentToken(token)) {
            list.add(token);
        }
    }

    private static List<Token> subsituteParams(APTMacro aPTMacro, List<List<Token>> list, APTMacroCallback aPTMacroCallback, boolean bl) throws TokenStreamException {
        Map<String, List<Token>> map = APTExpandedStream.createParamsMap(aPTMacro, list);
        LinkedList<Token> linkedList = new LinkedList<Token>();
        APTCommentsFilter aPTCommentsFilter = new APTCommentsFilter(aPTMacro.getBody());
        int n = 0;
        Token token = null;
        Token token2 = aPTCommentsFilter.nextToken();
        Token token3 = null;
        do {
            block0 : switch (n) {
                case 0: {
                    List<Token> list2;
                    Object object;
                    token = token2;
                    token2 = aPTCommentsFilter.nextToken();
                    switch (token2.getType()) {
                        case 181: {
                            token3 = token;
                            n = 2;
                            token = null;
                            break block0;
                        }
                    }
                    switch (token.getType()) {
                        case 182: {
                            n = 1;
                            token = null;
                            break;
                        }
                        case 204: {
                            object = map.get(APTUtils.getTokenTextKey(token));
                            if (object == null) break;
                            list2 = APTExpandedStream.expandParamValue((List<Token>)object, aPTMacroCallback, bl);
                            if ((long)list2.size() > 16384L) {
                                if (DebugUtils.STANDALONE) {
                                    System.err.printf("parameter '%s' was empty substituted due to very long output value when expanding macros:\n %s\n", APTUtils.getTokenTextKey(token), aPTMacro.getName());
                                } else {
                                    APTUtils.LOG.log(Level.WARNING, "parameter '{0}' was empty substituted due to very long output value when expanding macros:\n {1}\n", new Object[]{APTUtils.getTokenTextKey(token), aPTMacro.getName()});
                                }
                                return Collections.emptyList();
                            }
                            token = null;
                            linkedList.addAll(list2);
                            break;
                        }
                    }
                    break;
                }
                case 2: {
                    token = null;
                    assert (token2.getType() == 181);
                    assert (token3 != null);
                    Object object = aPTCommentsFilter.nextToken();
                    List<Token> list2 = APTExpandedStream.createConcatenation(token3, object, map);
                    token2 = aPTCommentsFilter.nextToken();
                    switch (token2.getType()) {
                        case 181: {
                            int n2 = list2.size() - 1;
                            APTToken aPTToken = token3 = n2 < 0 ? APTUtils.EMPTY_ID_TOKEN : list2.remove(n2);
                            if (list2.size() > 0) {
                                linkedList.addAll(list2);
                            }
                            n = 2;
                            break block0;
                        }
                    }
                    token3 = null;
                    linkedList.addAll(list2);
                    n = 0;
                    break;
                }
                case 1: {
                    token = null;
                    assert (token2.getType() == 204);
                    Object object = APTExpandedStream.stringizeParam(map.get(APTUtils.getTokenTextKey(token2)));
                    token2 = aPTCommentsFilter.nextToken();
                    switch (token2.getType()) {
                        case 181: {
                            token3 = object;
                            n = 2;
                            break block0;
                        }
                    }
                    token = object;
                    n = 0;
                    break;
                }
            }
            if (token == null) continue;
            if (APTUtils.isEOF(token)) break;
            linkedList.add(token);
            token = null;
        } while (token == null);
        return linkedList;
    }

    private static Map<String, List<Token>> createParamsMap(APTMacro aPTMacro, List<List<Token>> list) {
        HashMap<String, List<Token>> hashMap = new HashMap<String, List<Token>>();
        Collection<Token> collection = aPTMacro.getParams();
        int n = list.size();
        int n2 = 0;
        Token token = null;
        for (Token token2 : collection) {
            hashMap.put(APTUtils.getTokenTextKey(token2), n2 < n ? list.get(n2) : Collections.emptyList());
            ++n2;
            token = token2;
        }
        if (n2 < n && APTUtils.isVaArgsToken(token)) {
            List list2 = (List)hashMap.get(APTUtils.getTokenTextKey(token));
            while (n2 < n) {
                list2.add(APTUtils.COMMA_TOKEN);
                list2.addAll((Collection)list.get(n2));
                ++n2;
            }
        }
        return hashMap;
    }

    private static List<Token> createConcatenation(Token token, Token token2, Map<String, List<Token>> map) {
        List<Token> list = map.get(APTUtils.getTokenTextKey(token));
        String string = list != null ? APTExpandedStream.toText(list, false) : token.getText();
        List<Token> list2 = map.get(APTUtils.getTokenTextKey(token2));
        String string2 = list2 != null ? APTExpandedStream.toText(list2, false) : token2.getText();
        String string3 = string + string2;
        TokenStream tokenStream = APTTokenStreamBuilder.buildTokenStream(string3);
        List<Token> list3 = APTUtils.toList(tokenStream);
        return list3;
    }

    private static Token stringizeParam(List<Token> list) {
        assert (list != null);
        APTToken aPTToken = APTUtils.createAPTToken();
        aPTToken.setType(192);
        aPTToken.setText(APTExpandedStream.toText(list, true));
        return aPTToken;
    }

    private static String toText(List<Token> list, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append('\"');
        }
        Iterator<Token> iterator = list.iterator();
        while (iterator.hasNext()) {
            Token token = iterator.next();
            if (bl) {
                stringBuilder.append(APTExpandedStream.escape(token.getText()));
                continue;
            }
            stringBuilder.append(token.getText());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(' ');
        }
        if (bl) {
            stringBuilder.append('\"');
        }
        return stringBuilder.toString();
    }

    private static CharSequence escape(CharSequence charSequence) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (c == '\"' || c == '\\') {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c);
        }
        return stringBuilder;
    }

    private static List<Token> expandParamValue(List<Token> list, APTMacroCallback aPTMacroCallback, boolean bl) {
        ListBasedTokenStream listBasedTokenStream = new ListBasedTokenStream(list);
        APTExpandedStream aPTExpandedStream = new APTExpandedStream(listBasedTokenStream, aPTMacroCallback, bl);
        List<Token> list2 = APTUtils.toList(aPTExpandedStream);
        return list2;
    }
}

