/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support;

import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.impl.structure.APTDefineNode;
import org.netbeans.modules.cnd.apt.impl.support.APTMacroMapSnapshot;
import org.netbeans.modules.cnd.apt.support.APTMacro;
import org.netbeans.modules.cnd.apt.support.APTMacroMap;
import org.netbeans.modules.cnd.apt.support.APTTokenStreamBuilder;
import org.netbeans.modules.cnd.apt.utils.APTSerializeUtils;
import org.netbeans.modules.cnd.apt.utils.APTUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class APTBaseMacroMap {
    protected APTMacroMapSnapshot active = this.makeSnapshot(null);
    private static final String DEFINE_PREFIX = "#define ";
    protected static final APTMacroMap EMPTY = new EmptyMacroMap();

    protected final void fill(List<String> list) {
        for (String string : list) {
            if (APTTraceFlags.TRACE_APT) {
                System.err.println("adding macro in map " + string);
            }
            this.define(string);
        }
    }

    private void define(String string) {
        string = DEFINE_PREFIX + string;
        TokenStream tokenStream = APTTokenStreamBuilder.buildTokenStream(string);
        try {
            Token token = tokenStream.nextToken();
            APTDefineNode aPTDefineNode = new APTDefineNode(token);
            boolean bl = true;
            do {
                token = tokenStream.nextToken();
                if (!bl || token.getType() != 131) continue;
                bl = false;
                token = tokenStream.nextToken();
            } while (aPTDefineNode.accept(token));
            List<Token> list = aPTDefineNode.getBody();
            if (list == APTUtils.EMPTY_STREAM) {
                list = APTUtils.DEF_MACRO_BODY;
            }
            this.defineImpl(aPTDefineNode.getName(), aPTDefineNode.getParams(), list);
        }
        catch (TokenStreamException tokenStreamException) {
            APTUtils.LOG.log(Level.SEVERE, "error on lexing macros {0}\n\t{1}", new Object[]{string, tokenStreamException.getMessage()});
        }
    }

    public final void define(Token token, List<Token> list) {
        this.defineImpl(token, list);
    }

    protected final void defineImpl(Token token, List<Token> list) {
        this.define(token, null, list);
    }

    protected void define(Token token, Collection<Token> collection, List<Token> list) {
        this.defineImpl(token, collection, list);
    }

    protected void defineImpl(Token token, Collection<Token> collection, List<Token> list) {
        this.active.macros.put(APTUtils.getTokenTextKey(token), this.createMacro(token, collection, list));
    }

    protected void undef(Token token) {
        this.active.macros.put(APTUtils.getTokenTextKey(token), APTMacroMapSnapshot.UNDEFINED_MACRO);
    }

    protected abstract APTMacro createMacro(Token var1, Collection<Token> var2, List<Token> var3);

    public final boolean isDefined(Token token) {
        return this.getMacro(token) != null;
    }

    protected APTMacro getMacro(Token token) {
        return this.active.getMacro(token);
    }

    protected abstract APTMacroMapSnapshot makeSnapshot(APTMacroMapSnapshot var1);

    public APTMacroMap.State getState() {
        this.changeActiveSnapshotIfNeeded();
        return new StateImpl(this.active.parent);
    }

    protected void changeActiveSnapshotIfNeeded() {
        this.active = this.makeSnapshot(this.active);
    }

    public void setState(APTMacroMap.State state) {
        this.active = this.makeSnapshot(((StateImpl)state).snap);
    }

    public String toString() {
        HashMap<String, APTMacro> hashMap = new HashMap<String, APTMacro>();
        APTMacroMapSnapshot.addAllMacros(this.active, hashMap);
        return APTUtils.macros2String(hashMap);
    }

    private static final class EmptyMacroMap
    implements APTMacroMap {
        private EmptyMacroMap() {
        }

        protected APTMacro createMacro(Token token, Token[] tokenArray, List list) {
            return null;
        }

        public boolean pushExpanding(Token token) {
            return false;
        }

        public void popExpanding() {
        }

        public boolean isExpanding(Token token) {
            return false;
        }

        public boolean isDefined(Token token) {
            return false;
        }

        public APTMacro getMacro(Token token) {
            return null;
        }

        public void define(Token token, Collection collection, List list) {
        }

        public void define(Token token, List list) {
        }

        public void undef(Token token) {
        }

        public void setState(APTMacroMap.State state) {
        }

        public APTMacroMap.State getState() {
            return new StateImpl((APTMacroMapSnapshot)null);
        }
    }

    public static class StateImpl
    implements APTMacroMap.State {
        public final APTMacroMapSnapshot snap;

        public StateImpl(APTMacroMapSnapshot aPTMacroMapSnapshot) {
            this.snap = aPTMacroMapSnapshot;
        }

        protected StateImpl(StateImpl stateImpl, boolean bl) {
            this.snap = bl ? this.getFirstSnapshot(stateImpl.snap) : stateImpl.snap;
        }

        public String toString() {
            return this.snap != null ? this.snap.toString() : "<no snap>";
        }

        public StateImpl copyCleaned() {
            return new StateImpl(this, true);
        }

        public void write(DataOutput dataOutput) throws IOException {
            APTSerializeUtils.writeSnapshot(this.snap, dataOutput);
        }

        public StateImpl(DataInput dataInput) throws IOException {
            this.snap = APTSerializeUtils.readSnapshot(dataInput);
        }

        private APTMacroMapSnapshot getFirstSnapshot(APTMacroMapSnapshot aPTMacroMapSnapshot) {
            if (aPTMacroMapSnapshot != null) {
                while (aPTMacroMapSnapshot.parent != null) {
                    aPTMacroMapSnapshot = aPTMacroMapSnapshot.parent;
                }
            }
            return aPTMacroMapSnapshot;
        }
    }
}

