/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.semantic;

import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.highlight.semantic.HighlighterBase;
import org.netbeans.modules.cnd.highlight.semantic.SemanticEntitiesProvider;
import org.netbeans.modules.cnd.highlight.semantic.SemanticEntity;
import org.netbeans.modules.cnd.highlight.semantic.options.SemanticHighlightingOptions;
import org.netbeans.modules.cnd.model.tasks.CsmFileTaskFactory;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.modelutil.FontColorProvider;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;

public class SemanticHighlighter
extends HighlighterBase {
    private static final boolean SHOW_TIMES = Boolean.getBoolean("cnd.highlighting.times");

    public SemanticHighlighter(Document document) {
        super(document);
    }

    protected void updateFontColors(FontColorProvider fontColorProvider) {
        for (SemanticEntity semanticEntity : SemanticEntitiesProvider.instance().get()) {
            semanticEntity.updateFontColors(fontColorProvider);
        }
    }

    public static OffsetsBag getHighlightsBag(Document document) {
        if (document == null) {
            return null;
        }
        OffsetsBag offsetsBag = (OffsetsBag)document.getProperty(SemanticHighlighter.class);
        if (offsetsBag == null) {
            offsetsBag = new OffsetsBag(document);
            document.putProperty(SemanticHighlighter.class, offsetsBag);
        }
        return offsetsBag;
    }

    private void update() {
        BaseDocument baseDocument = this.getDocument();
        if (baseDocument != null) {
            OffsetsBag offsetsBag = new OffsetsBag((Document)baseDocument);
            offsetsBag.clear();
            CsmFile csmFile = CsmUtilities.getCsmFile((Document)baseDocument, (boolean)false);
            long l = System.currentTimeMillis();
            if (SHOW_TIMES) {
                System.err.println("#@# Semantic Highlighting update() have started for file " + csmFile.getAbsolutePath());
            }
            if (csmFile != null && csmFile.isParsed()) {
                for (SemanticEntity semanticEntity : SemanticEntitiesProvider.instance().get()) {
                    long l2 = System.currentTimeMillis();
                    if (SemanticHighlightingOptions.instance().isEnabled(semanticEntity.getName())) {
                        for (CsmOffsetable csmOffsetable : semanticEntity.getBlocks(csmFile)) {
                            offsetsBag.addHighlight(csmOffsetable.getStartOffset(), csmOffsetable.getEndOffset(), semanticEntity.getColor(csmOffsetable));
                        }
                    }
                    if (!SHOW_TIMES) continue;
                    System.err.println("#@# Highlighter '" + semanticEntity.getName() + "' have finished. Took " + (System.currentTimeMillis() - l2) + "ms.");
                }
            }
            SemanticHighlighter.getHighlightsBag((Document)baseDocument).setHighlights(offsetsBag);
            if (SHOW_TIMES) {
                System.err.println("#@# Semantic Highlighting update() done in " + (System.currentTimeMillis() - l) + "ms for file " + csmFile.getAbsolutePath());
            }
        }
    }

    public void run(CsmFileTaskFactory.PhaseRunner.Phase phase) {
        BaseDocument baseDocument;
        if (phase == CsmFileTaskFactory.PhaseRunner.Phase.PARSED || phase == CsmFileTaskFactory.PhaseRunner.Phase.INIT) {
            try {
                this.update();
            }
            catch (AssertionError assertionError) {
                ((Throwable)((Object)assertionError)).printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (phase == CsmFileTaskFactory.PhaseRunner.Phase.CLEANUP && (baseDocument = this.getDocument()) != null) {
            SemanticHighlighter.getHighlightsBag((Document)baseDocument).clear();
        }
    }

    public boolean isValid() {
        return true;
    }
}

